/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.Druids;
import org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.druid.query.Order;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScanQueryRunnerTest
extends InitializedNullHandlingTest {
    private static final VirtualColumn EXPR_COLUMN = new ExpressionVirtualColumn("expr", "index * 2", ColumnType.LONG, TestExprMacroTable.INSTANCE);
    public static final String[] V_0112 = ScanQueryRunnerTest.readLinesFromSample(0, 13).toArray(new String[0]);
    public static final String[] V_0113 = ScanQueryRunnerTest.readLinesFromSample(13, 26).toArray(new String[0]);
    public static final QuerySegmentSpec I_0112_0114 = new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z"));
    public static final String[] V_0112_0114 = (String[])ObjectArrays.concat((Object[])V_0112, (Object[])V_0113, String.class);
    private static final ScanQueryQueryToolChest TOOL_CHEST = new ScanQueryQueryToolChest(DefaultGenericQueryMetricsFactory.instance());
    private static final ScanQueryRunnerFactory FACTORY = new ScanQueryRunnerFactory(TOOL_CHEST, new ScanQueryEngine(), new ScanQueryConfig());
    private final QueryRunner runner;
    private final List<String> columns;

    private static List<String> readLinesFromSample(final int startLineNum, final int endLineNum) {
        CharSource sampleData = TestIndex.getResourceCharSource("druid.sample.numeric.tsv");
        final ArrayList<String> lines = new ArrayList<String>();
        try {
            sampleData.readLines((LineProcessor)new LineProcessor<Object>(){
                int count = 0;

                public boolean processLine(String line) {
                    if (this.count >= startLineNum && this.count < endLineNum) {
                        lines.add(line);
                    }
                    ++this.count;
                    return this.count < endLineNum;
                }

                public Object getResult() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lines;
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ScanQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
        this.columns = Lists.newArrayList((Object[])new String[]{"__time", "expr", "market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "longNumericNull", "floatNumericNull", "doubleNumericNull", "placement", "placementish", "partial_null_column", "null_column", "index", "indexMin", "indexMaxPlusTen", "quality_uniques", "indexFloat", "indexMaxFloat", "indexMinFloat"});
    }

    private Druids.ScanQueryBuilder newTestQuery() {
        return Druids.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("testing")).columns(Collections.emptyList()).eternityInterval().limit(3L);
    }

    @Test
    public void testFullOnSelect() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).build();
        StubServiceEmitter stubServiceEmitter = new StubServiceEmitter("", "");
        MetricsEmittingQueryRunner metricsEmittingQueryRunner = new MetricsEmittingQueryRunner((ServiceEmitter)stubServiceEmitter, (QueryToolChest)TOOL_CHEST, this.runner, (obj, lng) -> {}, metrics -> {}).withWaitMeasuredFromNow();
        List results = metricsEmittingQueryRunner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = this.toExpected(this.toFullEvents(new String[][]{V_0112_0114}), this.columns, 0, 3);
        stubServiceEmitter.verifyEmitted("query/wait/time", (Map)ImmutableMap.of((Object)"vectorized", (Object)false), 1);
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    @Test
    public void testFullOnSelectAsCompactedList() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = this.toExpected(this.toFullEvents(new String[][]{V_0112_0114}), this.columns, 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(this.compactedListToRow(results), "null_column"));
    }

    @Test
    public void testSelectWithUnderscoreUnderscoreTime() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"__time", "market", "index"}).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<List<Map<String, Object>>> expectedEvents = ScanQueryRunnerTest.toEvents(new String[]{"__time:TIME", "market:STRING", null, null, null, null, null, null, null, null, null, null, "index:DOUBLE"}, new String[][]{V_0112_0114});
        List<ScanResultValue> expectedResults = this.toExpected(expectedEvents, Lists.newArrayList((Object[])new String[]{"__time", "market", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectWithDimsAndMets() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"market", "index"}).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = this.toExpected(ScanQueryRunnerTest.toEvents(new String[]{null, "market:STRING", null, null, null, null, null, null, null, null, null, null, "index:DOUBLE"}, new String[][]{V_0112_0114}), Lists.newArrayList((Object[])new String[]{"market", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectWithDimsAndMetsAsCompactedList() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"market", "index"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = this.toExpected(ScanQueryRunnerTest.toEvents(new String[]{null, "market:STRING", null, null, null, null, null, null, null, null, null, null, "index:DOUBLE"}, new String[][]{V_0112_0114}), Lists.newArrayList((Object[])new String[]{"market", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, this.compactedListToRow(results));
    }

    @Test
    public void testFullOnSelectWithFilterAndLimit() {
        for (int limit : new int[]{3, 1, 5, 7, 0}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"quality", "index"}).limit((long)limit).build();
            List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            List<List<Map<String, Object>>> events = ScanQueryRunnerTest.toEvents(new String[]{null, null, "quality:STRING", null, null, "index:DOUBLE"}, {"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"}, {"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"});
            List<ScanResultValue> expectedResults = this.toExpected(events, Lists.newArrayList((Object[])new String[]{"quality", "index"}), 0, limit);
            ScanQueryRunnerTest.verify(expectedResults, results);
        }
    }

    @Test
    public void testSelectWithFilterLookupExtractionFn() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("total_market", "replaced");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(true));
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "replaced", (ExtractionFn)lookupExtractionFn)).columns(new String[]{"quality", "index"}).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List resultsOptimize = TOOL_CHEST.postMergeQueryDecoration(TOOL_CHEST.mergeResults(TOOL_CHEST.preMergeQueryDecoration(this.runner))).run(QueryPlus.wrap((Query)query)).toList();
        List<List<Map<String, Object>>> events = ScanQueryRunnerTest.toEvents(new String[]{null, null, "quality:STRING", null, null, "index:DOUBLE"}, {"2011-01-12T00:00:00.000Z\ttotal_market\tmezzanine\tpreferred\tm\u0001preferred\t1000.000000", "2011-01-12T00:00:00.000Z\ttotal_market\tpremium\tpreferred\tp\u0001preferred\t1000.000000"}, {"2011-01-13T00:00:00.000Z\ttotal_market\tmezzanine\tpreferred\tm\u0001preferred\t1040.945505", "2011-01-13T00:00:00.000Z\ttotal_market\tpremium\tpreferred\tp\u0001preferred\t1689.012875"});
        List<ScanResultValue> expectedResults = this.toExpected(events, Lists.newArrayList((Object[])new String[]{"quality", "index"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
        ScanQueryRunnerTest.verify(expectedResults, resultsOptimize);
    }

    @Test
    public void testFullSelectNoResults() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new AndDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "foo", null)))).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<ScanResultValue> expectedResults = Collections.emptyList();
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    @Test
    public void testFullSelectNoDimensionAndMetric() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).columns(new String[]{"foo", "foo2"}).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List<List<Map<String, Object>>> events = ScanQueryRunnerTest.toEvents(new String[0], new String[][]{V_0112_0114});
        List<ScanResultValue> expectedResults = this.toExpected(events, Lists.newArrayList((Object[])new String[]{"foo", "foo2"}), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testFullOnSelectWithFilterLimitAndAscendingTimeOrderingListFormat() {
        for (int limit : new int[]{3, 1, 5, 7, 0}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"__time", "quality", "index"}).limit((long)limit).order(Order.ASCENDING).context((Map)ImmutableMap.of((Object)"scanOutermost", (Object)false)).build();
            List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            Object[] seg1Results = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"};
            Object[] seg2Results = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"};
            List<List<Map<String, Object>>> ascendingEvents = ScanQueryRunnerTest.toEvents(new String[]{"__time", null, "quality:STRING", null, null, "index:DOUBLE"}, new String[][]{(String[])ArrayUtils.addAll((Object[])seg1Results, (Object[])seg2Results)});
            for (List<Map<String, Object>> batch : ascendingEvents) {
                for (Map<String, Object> event : batch) {
                    event.put("__time", DateTimes.of((String)((String)event.get("__time"))).getMillis());
                }
            }
            List<ScanResultValue> ascendingExpectedResults = this.toExpected(ascendingEvents, Lists.newArrayList((Object[])new String[]{"__time", "quality", "index"}), 0, limit);
            ScanQueryRunnerTest.verify(ascendingExpectedResults, results);
        }
    }

    @Test
    public void testFullOnSelectWithFilterLimitAndDescendingTimeOrderingListFormat() {
        for (int limit : new int[]{3, 1, 5, 7, 0}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"__time", "quality", "index"}).limit((long)limit).order(Order.DESCENDING).build();
            List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            Object[] seg1Results = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"};
            Object[] seg2Results = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"};
            Object[] expectedRet = (String[])ArrayUtils.addAll((Object[])seg1Results, (Object[])seg2Results);
            ArrayUtils.reverse((Object[])expectedRet);
            List<List<Map<String, Object>>> descendingEvents = ScanQueryRunnerTest.toEvents(new String[]{"__time", null, "quality:STRING", null, null, "index:DOUBLE"}, new String[][]{expectedRet});
            for (List<Map<String, Object>> batch : descendingEvents) {
                for (Map<String, Object> event : batch) {
                    event.put("__time", DateTimes.of((String)((String)event.get("__time"))).getMillis());
                }
            }
            List<ScanResultValue> descendingExpectedResults = this.toExpected(descendingEvents, Lists.newArrayList((Object[])new String[]{"__time", "quality", "index"}), 0, limit);
            ScanQueryRunnerTest.verify(descendingExpectedResults, results);
        }
    }

    @Test
    public void testFullOnSelectWithFilterLimitAndAscendingTimeOrderingCompactedListFormat() {
        Object[] seg1Results = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"};
        Object[] seg2Results = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"};
        for (int limit : new int[]{3, 0}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"__time", "quality", "index"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).order(Order.ASCENDING).limit((long)limit).build();
            Iterable<Object> results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            List<List<Map<String, Object>>> ascendingEvents = ScanQueryRunnerTest.toEvents(new String[]{"__time", null, "quality:STRING", null, null, "index:DOUBLE"}, new String[][]{(String[])ArrayUtils.addAll((Object[])seg1Results, (Object[])seg2Results)});
            for (List<Map<String, Object>> batch : ascendingEvents) {
                for (Map<String, Object> event : batch) {
                    event.put("__time", DateTimes.of((String)((String)event.get("__time"))).getMillis());
                }
            }
            List<ScanResultValue> ascendingExpectedResults = this.toExpected(ascendingEvents, Lists.newArrayList((Object[])new String[]{"__time", "quality", "index"}), 0, limit);
            results = this.compactedListToRow(results);
            ScanQueryRunnerTest.verify(ascendingExpectedResults, results);
        }
    }

    @Test
    public void testFullOnSelectWithFilterLimitAndDescendingTimeOrderingCompactedListFormat() {
        Object[] seg1Results = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"};
        Object[] seg2Results = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"};
        for (int limit : new int[]{3, 1}) {
            ScanQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).columns(new String[]{"__time", "quality", "index"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).order(Order.DESCENDING).context((Map)ImmutableMap.of((Object)"scanOutermost", (Object)false)).limit((long)limit).build();
            Iterable<Object> results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
            Object[] expectedRet = (String[])ArrayUtils.addAll((Object[])seg1Results, (Object[])seg2Results);
            ArrayUtils.reverse((Object[])expectedRet);
            List<List<Map<String, Object>>> descendingEvents = ScanQueryRunnerTest.toEvents(new String[]{"__time", null, "quality:STRING", null, null, "index:DOUBLE"}, new String[][]{expectedRet});
            for (List<Map<String, Object>> batch : descendingEvents) {
                for (Map<String, Object> event : batch) {
                    event.put("__time", DateTimes.of((String)((String)event.get("__time"))).getMillis());
                }
            }
            List<ScanResultValue> descendingExpectedResults = this.toExpected(descendingEvents, Lists.newArrayList((Object[])new String[]{"__time", "quality", "index"}), 0, limit);
            results = this.compactedListToRow(results);
            ScanQueryRunnerTest.verify(descendingExpectedResults, results);
        }
    }

    @Test
    public void testScanQueryTimeout() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).context((Map)ImmutableMap.of((Object)"timeout", (Object)1)).build();
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        long timeoutAt = System.currentTimeMillis();
        responseContext.putTimeoutTime(timeoutAt);
        try {
            this.runner.run(QueryPlus.wrap((Query)query), (ResponseContext)responseContext).toList();
            Assert.fail((String)"didn't timeout");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e instanceof QueryTimeoutException));
            Assert.assertEquals((Object)"Query timeout", (Object)((QueryTimeoutException)e).getErrorCode());
            Assert.assertEquals((long)timeoutAt, (long)responseContext.getTimeoutTime());
        }
    }

    @Test
    public void testScanQueryTimeoutMerge() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).context((Map)ImmutableMap.of((Object)"timeout", (Object)1)).build();
        try {
            FACTORY.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, (Iterable)ImmutableList.of((queryPlus, responseContext) -> {
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.runner.run(queryPlus, responseContext);
            })).run(QueryPlus.wrap((Query)query), (ResponseContext)DefaultResponseContext.createEmpty()).toList();
            Assert.fail((String)"didn't timeout");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e instanceof QueryTimeoutException));
            Assert.assertEquals((Object)"Query timeout", (Object)((QueryTimeoutException)e).getErrorCode());
        }
    }

    @Test
    public void testScanQueryTimeoutZeroDoesntTimeOut() {
        ScanQuery query = this.newTestQuery().intervals(I_0112_0114).virtualColumns(new VirtualColumn[]{EXPR_COLUMN}).context((Map)ImmutableMap.of((Object)"timeout", (Object)0)).build();
        List results = FACTORY.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, (Iterable)ImmutableList.of((queryPlus, responseContext) -> {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.runner.run(queryPlus, responseContext);
        })).run(QueryPlus.wrap((Query)query), (ResponseContext)DefaultResponseContext.createEmpty()).toList();
        List<ScanResultValue> expectedResults = this.toExpected(this.toFullEvents(new String[][]{V_0112_0114}), this.columns, 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, ScanQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    private List<List<Map<String, Object>>> toFullEvents(String[] ... valueSet) {
        return ScanQueryRunnerTest.toEvents(new String[]{"__time:TIME", "market:STRING", "quality:STRING", "qualityLong:LONG", "qualityFloat:FLOAT", "qualityDouble:DOUBLE", "qualityNumericString:STRING", "longNumericNull:LONG", "floatNumericNull:FLOAT", "doubleNumericNull:DOUBLE", "placement:STRING", "placementish:STRINGS", "index:DOUBLE", "partial_null_column:STRING", "expr", "indexMin", "indexFloat", "indexMaxPlusTen", "indexMinFloat", "indexMaxFloat", "quality_uniques"}, valueSet);
    }

    public static List<List<Map<String, Object>>> toEvents(String[] dimSpecs, String[] ... valueSet) {
        ArrayList<String> values = new ArrayList<String>();
        for (String[] vSet : valueSet) {
            values.addAll(Arrays.asList(vSet));
        }
        ArrayList<List<Map<String, Object>>> events = new ArrayList<List<Map<String, Object>>>();
        events.add(Lists.newArrayList((Iterable)Iterables.transform(values, input -> {
            HashMap<String, Object> event = new HashMap<String, Object>();
            String[] values1 = input.split("\\t");
            for (int i = 0; i < dimSpecs.length; ++i) {
                Object eventVal;
                if (dimSpecs[i] == null || i >= dimSpecs.length) continue;
                if (dimSpecs[i].equals(EXPR_COLUMN.getOutputName())) {
                    event.put(EXPR_COLUMN.getOutputName(), (Double)event.get("index") * 2.0);
                    continue;
                }
                if (dimSpecs[i].equals("indexMin")) {
                    event.put("indexMin", (Double)event.get("index"));
                    continue;
                }
                if (dimSpecs[i].equals("indexFloat")) {
                    event.put("indexFloat", Float.valueOf((float)((Double)event.get("index")).doubleValue()));
                    continue;
                }
                if (dimSpecs[i].equals("indexMaxPlusTen")) {
                    event.put("indexMaxPlusTen", (Double)event.get("index") + 10.0);
                    continue;
                }
                if (dimSpecs[i].equals("indexMinFloat")) {
                    event.put("indexMinFloat", Float.valueOf((float)((Double)event.get("index")).doubleValue()));
                    continue;
                }
                if (dimSpecs[i].equals("indexMaxFloat")) {
                    event.put("indexMaxFloat", Float.valueOf((float)((Double)event.get("index")).doubleValue()));
                    continue;
                }
                if (dimSpecs[i].equals("quality_uniques")) {
                    HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                    collector.add(Hashing.murmur3_128().hashBytes(StringUtils.toUtf8((String)((String)event.get("quality")))).asBytes());
                    event.put("quality_uniques", collector);
                }
                if (i >= values1.length) continue;
                String[] specs = dimSpecs[i].split(":");
                if (specs.length == 1 || specs[1].equals("STRING")) {
                    eventVal = values1[i];
                } else if (specs[1].equals("TIME")) {
                    eventVal = DateTimes.of((String)values1[i]).getMillis();
                } else if (specs[1].equals("FLOAT")) {
                    try {
                        eventVal = values1[i].isEmpty() ? null : Float.valueOf(values1[i]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new ISE("This object cannot be converted to a Float!", new Object[0]);
                    }
                } else if (specs[1].equals("DOUBLE")) {
                    try {
                        eventVal = values1[i].isEmpty() ? null : Double.valueOf(values1[i]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new ISE("This object cannot be converted to a Double!", new Object[0]);
                    }
                } else if (specs[1].equals("LONG")) {
                    try {
                        eventVal = values1[i].isEmpty() ? null : Long.valueOf(values1[i]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new ISE("This object cannot be converted to a Long!", new Object[0]);
                    }
                } else {
                    eventVal = specs[1].equals("NULL") ? null : (specs[1].equals("STRINGS") ? Arrays.asList(values1[i].split("\u0001")) : values1[i]);
                }
                event.put(specs[0], eventVal);
            }
            return event;
        })));
        return events;
    }

    private List<ScanResultValue> toExpected(List<List<Map<String, Object>>> targets, List<String> columns, int offset, int limit) {
        ArrayList expected = Lists.newArrayListWithExpectedSize((int)targets.size());
        for (List<Map<String, Object>> group : targets) {
            ArrayList events = Lists.newArrayListWithExpectedSize((int)limit);
            int end = Math.min(group.size(), offset + limit);
            if (end == 0) {
                end = group.size();
            }
            events.addAll(group.subList(offset, end));
            expected.add(new ScanResultValue(QueryRunnerTestHelper.SEGMENT_ID.toString(), columns, (Object)events));
        }
        return expected;
    }

    public static void verify(Iterable<ScanResultValue> expectedResults, Iterable<ScanResultValue> actualResults) {
        Iterator<ScanResultValue> expectedIter = expectedResults.iterator();
        Iterator<ScanResultValue> actualIter = actualResults.iterator();
        while (expectedIter.hasNext()) {
            ScanResultValue expected = expectedIter.next();
            ScanResultValue actual = actualIter.next();
            Assert.assertEquals((Object)expected.getSegmentId(), (Object)actual.getSegmentId());
            TreeSet exColumns = Sets.newTreeSet((Iterable)expected.getColumns());
            TreeSet acColumns = Sets.newTreeSet((Iterable)actual.getColumns());
            Assert.assertEquals((Object)exColumns, (Object)acColumns);
            Iterator expectedEvts = ((List)expected.getEvents()).iterator();
            Iterator actualEvts = ((List)actual.getEvents()).iterator();
            while (expectedEvts.hasNext()) {
                Map exHolder = (Map)expectedEvts.next();
                Map acHolder = (Map)actualEvts.next();
                for (Map.Entry ex : exHolder.entrySet()) {
                    Object exValue;
                    Object actVal = acHolder.get(ex.getKey());
                    if (actVal instanceof String[]) {
                        actVal = Arrays.asList((String[])actVal);
                    }
                    if ((exValue = ex.getValue()) instanceof Double || exValue instanceof Float) {
                        double expectedDoubleValue = ((Number)exValue).doubleValue();
                        Assert.assertNotNull((String)StringUtils.format((String)"invalid null value for %s (expected %f)", (Object[])new Object[]{ex.getKey(), expectedDoubleValue}), actVal);
                        Assert.assertEquals((String)("invalid value for " + (String)ex.getKey()), (double)expectedDoubleValue, (double)((Number)actVal).doubleValue(), (double)(expectedDoubleValue * 1.0E-6));
                        continue;
                    }
                    Assert.assertEquals((String)("invalid value for " + (String)ex.getKey()), ex.getValue(), actVal);
                }
                for (Map.Entry ac : acHolder.entrySet()) {
                    Object exVal = exHolder.get(ac.getKey());
                    Object actVal = ac.getValue();
                    if (actVal instanceof String[]) {
                        actVal = Arrays.asList((String[])actVal);
                    }
                    if (exVal instanceof Double || exVal instanceof Float) {
                        double exDoubleValue = ((Number)exVal).doubleValue();
                        Assert.assertEquals((String)("invalid value for " + (String)ac.getKey()), (double)exDoubleValue, (double)((Number)actVal).doubleValue(), (double)(exDoubleValue * 1.0E-6));
                        continue;
                    }
                    Assert.assertEquals((String)("invalid value for " + (String)ac.getKey()), exVal, actVal);
                }
            }
            if (!actualEvts.hasNext()) continue;
            throw new ISE("This event iterator should be exhausted!", new Object[0]);
        }
        if (actualIter.hasNext()) {
            throw new ISE("This iterator should be exhausted!", new Object[0]);
        }
    }

    private static Iterable<ScanResultValue> populateNullColumnAtLastForQueryableIndexCase(Iterable<ScanResultValue> results, String columnName) {
        ScanResultValue value;
        List columns;
        Iterator<ScanResultValue> iterator = results.iterator();
        while (iterator.hasNext() && !(columns = (value = iterator.next()).getColumns()).contains(columnName)) {
            columns.add(columnName);
        }
        return results;
    }

    private Iterable<ScanResultValue> compactedListToRow(Iterable<ScanResultValue> results) {
        return Lists.newArrayList((Iterable)Iterables.transform(results, (Function)new Function<ScanResultValue, ScanResultValue>(){

            public ScanResultValue apply(ScanResultValue input) {
                ArrayList mapEvents = new ArrayList();
                List events = (List)input.getEvents();
                for (Object event : events) {
                    Iterator compactedEventIter = ((List)event).iterator();
                    LinkedHashMap mapEvent = new LinkedHashMap();
                    for (String column : input.getColumns()) {
                        mapEvent.put(column, compactedEventIter.next());
                    }
                    mapEvents.add(mapEvent);
                }
                return new ScanResultValue(input.getSegmentId(), input.getColumns(), mapEvents);
            }
        }));
    }
}

