/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.NoAsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumnsTestBase;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class SemanticTestBase {
    private final String name;
    private final Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> parameterFeed() {
        return FluentIterable.from(RowsAndColumnsTestBase.makerFeeder()).transformAndConcat(input -> {
            String name = ((Class)input[0]).getSimpleName();
            return Arrays.asList({name, input[1]}, {"NoAs-" + name, SemanticTestBase.wrapNoAs(input[1])});
        });
    }

    public SemanticTestBase(String name, Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn) {
        this.name = name;
        this.fn = fn;
    }

    public RowsAndColumns make(MapOfColumnsRowsAndColumns rac) {
        try {
            return this.fn.apply(rac);
        }
        catch (RuntimeException e) {
            throw new RE((Throwable)e, "using name[%s]", new Object[]{this.name});
        }
    }

    private static Function<MapOfColumnsRowsAndColumns, RowsAndColumns> wrapNoAs(Object obj) {
        return ((Function)obj).andThen(NoAsRowsAndColumns::new);
    }
}

