/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.function.Function;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.DoubleArrayColumn;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.FramedOnHeapAggregatable;
import org.apache.druid.query.rowsandcols.semantic.SemanticTestBase;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Test;

public class FramedOnHeapAggregatableTest
extends SemanticTestBase {
    public FramedOnHeapAggregatableTest(String name, Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn) {
        super(name, fn);
    }

    @Test
    public void testWindowedAggregationWindowSmallerThanRowsNoOffsets() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)0, (Integer)0), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}).expectColumn("maxFromInt", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowSmallerThanRows() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)-1, (Integer)2), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{3L, 6L, 10L, 14L, 18L, 22L, 26L, 30L, 24L, 17L}).expectColumn("maxFromInt", new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 9.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowSmallerThanRowsOnlyUpper() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)0, (Integer)2), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{3L, 6L, 9L, 12L, 15L, 18L, 21L, 24L, 17L, 9L}).expectColumn("maxFromInt", new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 9.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowSmallerThanRowsOnlyLower() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)-2, (Integer)0), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{0L, 1L, 3L, 6L, 9L, 12L, 15L, 18L, 21L, 24L}).expectColumn("maxFromInt", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowLargerThanRows() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)-5, (Integer)7), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{28L, 36L, 45L, 45L, 45L, 45L, 45L, 44L, 42L, 39L}).expectColumn("maxFromInt", new double[]{7.0, 8.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0}).expectColumn("longMin", new long[]{0L, 0L, 0L, 0L, 0L, 0L, 1L, 2L, 3L, 4L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationLowerLargerThanRows() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)-5, (Integer)1), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2}).expectColumn("sumFromLong", new long[]{1L, 3L, 3L}).expectColumn("maxFromInt", new double[]{1.0, 2.0, 2.0}).expectColumn("longMin", new long[]{0L, 0L, 0L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationLowerLargerThanRowsNoUpper() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)-5, (Integer)0), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2}).expectColumn("sumFromLong", new long[]{0L, 1L, 3L}).expectColumn("maxFromInt", new double[]{0.0, 1.0, 2.0}).expectColumn("longMin", new long[]{0L, 0L, 0L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationUpperLargerThanRows() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)-1, (Integer)7), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2}).expectColumn("sumFromLong", new long[]{3L, 3L, 3L}).expectColumn("maxFromInt", new double[]{2.0, 2.0, 2.0}).expectColumn("longMin", new long[]{0L, 0L, 1L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationUpperLargerThanRowsNoLower() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)0, (Integer)7), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2}).expectColumn("sumFromLong", new long[]{3L, 3L, 2L}).expectColumn("maxFromInt", new double[]{2.0, 2.0, 2.0}).expectColumn("longMin", new long[]{0L, 1L, 2L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowLargerThanRowsOnlyUpper() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)0, (Integer)7), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{28L, 36L, 44L, 42L, 39L, 35L, 30L, 24L, 17L, 9L}).expectColumn("maxFromInt", new double[]{7.0, 8.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0}).expectColumn("longMin", new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowLargerThanRowsOnlyLower() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)-5, (Integer)0), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{0L, 1L, 3L, 6L, 10L, 15L, 21L, 27L, 33L, 39L}).expectColumn("maxFromInt", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).expectColumn("longMin", new long[]{0L, 0L, 0L, 0L, 0L, 0L, 1L, 2L, 3L, 4L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testUnboundedWindowedAggregation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(WindowFrame.unbounded(), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new LongSumAggregatorFactory("sumFromDouble", "doubleCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new DoubleMaxAggregatorFactory("maxFromDouble", "doubleCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).expectColumn("objectCol", new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING).expectColumn("sumFromLong", new long[]{45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L}).expectColumn("sumFromDouble", new long[]{45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L}).expectColumn("maxFromInt", new double[]{9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0}).expectColumn("maxFromDouble", new double[]{9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testCumulativeAggregation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows(null, (Integer)0), new AggregatorFactory[]{new LongMaxAggregatorFactory("cummMax", "intCol"), new DoubleSumAggregatorFactory("cummSum", "doubleCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).expectColumn("objectCol", new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING).expectColumn("cummMax", new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}).expectColumn("cummSum", new double[]{0.0, 1.0, 3.0, 6.0, 10.0, 15.0, 21.0, 28.0, 36.0, 45.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testReverseCumulativeAggregation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll((WindowFrame)WindowFrame.rows((Integer)0, null), new AggregatorFactory[]{new LongMaxAggregatorFactory("cummMax", "intCol"), new DoubleSumAggregatorFactory("cummSum", "doubleCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).expectColumn("objectCol", new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING).expectColumn("cummMax", new long[]{9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L}).expectColumn("cummSum", new double[]{45.0, 45.0, 44.0, 42.0, 39.0, 35.0, 30.0, 24.0, 17.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testRangeOrderBy() {
        WindowFrame frame = WindowFrame.forOrderBy((String[])new String[]{"c1"});
        int[] c1Vals = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 2};
        int[] c2Vals = new int[]{1, 1, 2, 1, 1, 2, 1, 1, 1, 2};
        int[] resVals = new int[]{4, 4, 4, 8, 8, 8, 13, 13, 13, 13};
        this.simpleWindowingTest(frame, c1Vals, c2Vals, resVals);
    }

    @Test
    public void testRangeB1() {
        WindowFrame.Groups frame = WindowFrame.groups((Integer)-1, (Integer)0, Collections.singletonList("c1"));
        int[] c1Vals = new int[]{0, 1, 2, 2, 3, 4, 5};
        int[] c2Vals = new int[]{0, 1, 1, 1, 3, 4, 5};
        int[] resVals = new int[]{0, 1, 3, 3, 5, 7, 9};
        this.simpleWindowingTest((WindowFrame)frame, c1Vals, c2Vals, resVals);
    }

    @Test
    public void testRangeA1() {
        WindowFrame.Groups frame = WindowFrame.groups((Integer)0, (Integer)1, Collections.singletonList("c1"));
        int[] c1Vals = new int[]{0, 1, 2, 2, 3, 4, 5};
        int[] c2Vals = new int[]{0, 1, 1, 1, 3, 4, 5};
        int[] resVals = new int[]{1, 3, 5, 5, 7, 9, 5};
        this.simpleWindowingTest((WindowFrame)frame, c1Vals, c2Vals, resVals);
    }

    @Test
    public void testRangeB1A1() {
        WindowFrame.Groups frame = WindowFrame.groups((Integer)-1, (Integer)1, Collections.singletonList("c1"));
        int[] c1Vals = new int[]{0, 1, 2, 3, 4, 5};
        int[] c2Vals = new int[]{0, 1, 2, 3, 4, 5};
        int[] resVals = new int[]{1, 3, 6, 9, 12, 9};
        this.simpleWindowingTest((WindowFrame)frame, c1Vals, c2Vals, resVals);
    }

    @Test
    public void testRangeB1A1_2() {
        WindowFrame.Groups frame = WindowFrame.groups((Integer)-1, (Integer)1, Collections.singletonList("c1"));
        int[] c1Vals = new int[]{0, 0, 1, 2, 3, 3, 4, 4, 5};
        int[] c2Vals = new int[]{0, 0, 1, 2, 2, 1, 2, 2, 5};
        int[] resVals = new int[]{1, 1, 3, 6, 9, 9, 12, 12, 9};
        this.simpleWindowingTest((WindowFrame)frame, c1Vals, c2Vals, resVals);
    }

    @Test
    public void testRangeB1A2() {
        WindowFrame.Groups frame = WindowFrame.groups((Integer)-1, (Integer)2, Collections.singletonList("c1"));
        int[] c1Vals = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3};
        int[] c2Vals = new int[]{1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1};
        int[] resVals = new int[]{13, 13, 13, 16, 16, 16, 12, 12, 12, 12, 8, 8, 8};
        this.simpleWindowingTest((WindowFrame)frame, c1Vals, c2Vals, resVals);
    }

    private void simpleWindowingTest(WindowFrame frame, int[] c1Vals, int[] c2Vals, int[] resVals) {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("c1", new IntArrayColumn(c1Vals));
        map.put("c2", new IntArrayColumn(c2Vals));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(frame, new AggregatorFactory[]{new LongSumAggregatorFactory("res", "c2")});
        new RowsAndColumnsHelper().expectColumn("c1", c1Vals).expectColumn("c2", c2Vals).expectColumn("res", resVals).allColumnsRegistered().validate(results);
    }
}

