/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import org.apache.druid.frame.Frame;
import org.apache.druid.query.rowsandcols.ArrayListRowsAndColumnsTest;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.concrete.ColumnBasedFrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.FrameMaker;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class FrameMakerTest {
    public static RowSignature ROW_SIGNATURE = RowSignature.builder().add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("dim3", ColumnType.STRING).add("m1", ColumnType.LONG).add("m2", ColumnType.LONG).build();

    @Test
    public void testFrameMaker() {
        MapOfColumnsRowsAndColumns mapOfColumnsRowsAndColumns = MapOfColumnsRowsAndColumns.builder().add("dim1", ColumnType.STRING, new Object[]{"a", "b", "c"}).add("dim2", ColumnType.STRING, new Object[]{"m", "d", "e"}).add("dim3", ColumnType.STRING, new Object[]{"a"}).add("m1", ColumnType.LONG, new Object[]{1L, 2L, 3L}).add("m2", ColumnType.LONG, new Object[]{52L, 42L}).build();
        FrameMaker frameMaker = FrameMaker.fromRAC((RowsAndColumns)((RowsAndColumns)ArrayListRowsAndColumnsTest.MAKER.apply(mapOfColumnsRowsAndColumns)));
        Assert.assertEquals((Object)ROW_SIGNATURE, (Object)frameMaker.computeSignature());
        Frame frame = frameMaker.toColumnBasedFrame();
        ColumnBasedFrameRowsAndColumns columnBasedFrameRowsAndColumns = new ColumnBasedFrameRowsAndColumns(frame, frameMaker.computeSignature());
        for (String columnName : mapOfColumnsRowsAndColumns.getColumnNames()) {
            ColumnAccessor expectedColumn = mapOfColumnsRowsAndColumns.findColumn(columnName).toAccessor();
            ColumnAccessor actualColumn = columnBasedFrameRowsAndColumns.findColumn(columnName).toAccessor();
            for (int i = 0; i < expectedColumn.numRows(); ++i) {
                Assert.assertEquals((Object)expectedColumn.getObject(i), (Object)actualColumn.getObject(i));
            }
        }
        Assert.assertEquals((long)3L, (long)frame.numRows());
    }
}

