/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.SemanticTestBase;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Test;

public class ClusteredGroupPartitionerTest
extends SemanticTestBase {
    public ClusteredGroupPartitionerTest(String name, Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn) {
        super(name, fn);
    }

    @Test
    public void testEmpty() {
        RowsAndColumns rac = this.make(new MapOfColumnsRowsAndColumns((Map)ImmutableMap.of(), 0));
        ClusteredGroupPartitioner parter = ClusteredGroupPartitioner.fromRAC((RowsAndColumns)rac);
        List<String> cols = Collections.singletonList("notThere");
        Assert.assertArrayEquals((int[])new int[0], (int[])parter.computeBoundaries(cols));
        Assert.assertTrue((boolean)parter.partitionOnBoundaries(cols).isEmpty());
    }

    @Test
    public void testDefaultClusteredGroupPartitioner() {
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"sorted", (Object)new IntArrayColumn(new int[]{0, 0, 0, 1, 1, 2, 4, 4, 4}), (Object)"unsorted", (Object)new IntArrayColumn(new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92}))));
        ClusteredGroupPartitioner parter = ClusteredGroupPartitioner.fromRAC((RowsAndColumns)rac);
        int[] expectedBounds = new int[]{0, 3, 5, 6, 9};
        List<RowsAndColumnsHelper> expectations = Arrays.asList(new RowsAndColumnsHelper().expectColumn("sorted", new int[]{0, 0, 0}).expectColumn("unsorted", new int[]{3, 54, 21}).allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{1, 1}).expectColumn("unsorted", new int[]{1, 5}).allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{2}).expectColumn("unsorted", new int[]{54}).allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{4, 4, 4}).expectColumn("unsorted", new int[]{2, 3, 92}).allColumnsRegistered());
        List<String> partCols = Collections.singletonList("sorted");
        Assert.assertArrayEquals((int[])expectedBounds, (int[])parter.computeBoundaries(partCols));
        Iterator partedChunks = parter.partitionOnBoundaries(partCols).iterator();
        for (RowsAndColumnsHelper expectation : expectations) {
            Assert.assertTrue((boolean)partedChunks.hasNext());
            expectation.validate((RowsAndColumns)partedChunks.next());
        }
        Assert.assertFalse((boolean)partedChunks.hasNext());
        BiFunction<Integer, Integer, RowsAndColumnsHelper> singleHelperMaker = (sorted, unsorted) -> new RowsAndColumnsHelper().expectColumn("sorted", new int[]{sorted}).expectColumn("unsorted", new int[]{unsorted}).allColumnsRegistered();
        List<RowsAndColumnsHelper> unsortedExcpectations = Arrays.asList(singleHelperMaker.apply(0, 3), singleHelperMaker.apply(0, 54), singleHelperMaker.apply(0, 21), singleHelperMaker.apply(1, 1), singleHelperMaker.apply(1, 5), singleHelperMaker.apply(2, 54), singleHelperMaker.apply(4, 2), singleHelperMaker.apply(4, 3), singleHelperMaker.apply(4, 92));
        List<String> unsorted2 = Collections.singletonList("unsorted");
        Iterator unsortedChunks = parter.partitionOnBoundaries(unsorted2).iterator();
        for (RowsAndColumnsHelper expectation : unsortedExcpectations) {
            Assert.assertTrue((boolean)unsortedChunks.hasNext());
            expectation.validate((RowsAndColumns)unsortedChunks.next());
        }
        Assert.assertFalse((boolean)unsortedChunks.hasNext());
    }

    @Test
    public void testDefaultClusteredGroupPartitionerWithNulls() {
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"sorted", (Object)new ObjectArrayColumn(new Object[]{null, null, null, 1, 1, 2, 4, 4, 4}, ColumnType.LONG), (Object)"col_d", (Object)new ObjectArrayColumn(new Object[]{null, null, null, 1.0, 1.0, 2.0, 4.0, 4.0, 4.0}, ColumnType.DOUBLE), (Object)"col_f", (Object)new ObjectArrayColumn(new Object[]{null, null, null, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(4.0f), Float.valueOf(4.0f)}, ColumnType.FLOAT), (Object)"unsorted", (Object)new IntArrayColumn(new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92}))));
        ClusteredGroupPartitioner parter = ClusteredGroupPartitioner.fromRAC((RowsAndColumns)rac);
        int[] expectedBounds = new int[]{0, 3, 5, 6, 9};
        List<RowsAndColumnsHelper> expectations = Arrays.asList(new RowsAndColumnsHelper().expectColumn("sorted", new Object[]{null, null, null}, ColumnType.LONG).expectColumn("col_d", new Object[]{null, null, null}, ColumnType.DOUBLE).expectColumn("col_f", new Object[]{null, null, null}, ColumnType.FLOAT).expectColumn("unsorted", new int[]{3, 54, 21}).allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{1, 1}).expectColumn("col_d", new double[]{1.0, 1.0}).expectColumn("col_f", new float[]{1.0f, 1.0f}).expectColumn("unsorted", new int[]{1, 5}).allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{2}).expectColumn("col_d", new double[]{2.0}).expectColumn("col_f", new float[]{2.0f}).expectColumn("unsorted", new int[]{54}).allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{4, 4, 4}).expectColumn("col_d", new double[]{4.0, 4.0, 4.0}).expectColumn("col_f", new float[]{4.0f, 4.0f, 4.0f}).expectColumn("unsorted", new int[]{2, 3, 92}).allColumnsRegistered());
        List<String> partCols = Collections.singletonList("sorted");
        Assert.assertArrayEquals((int[])expectedBounds, (int[])parter.computeBoundaries(partCols));
        Iterator partedChunks = parter.partitionOnBoundaries(partCols).iterator();
        for (RowsAndColumnsHelper expectation : expectations) {
            Assert.assertTrue((boolean)partedChunks.hasNext());
            expectation.validate((RowsAndColumns)partedChunks.next());
        }
        Assert.assertFalse((boolean)partedChunks.hasNext());
    }
}

