/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.policy;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestSegmentUtils;
import org.junit.Assert;
import org.junit.Test;

public class NoopPolicyEnforcerTest {
    @Test
    public void test_serialize() throws Exception {
        NoopPolicyEnforcer policyEnforcer = NoopPolicyEnforcer.instance();
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        String expected = "{\"type\":\"none\"}";
        Assert.assertEquals((Object)expected, (Object)jsonMapper.writeValueAsString((Object)policyEnforcer));
    }

    @Test
    public void test_serde_roundTrip() throws Exception {
        NoopPolicyEnforcer policyEnforcer = NoopPolicyEnforcer.instance();
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        PolicyEnforcer deserialized = (PolicyEnforcer)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)policyEnforcer), PolicyEnforcer.class);
        Assert.assertEquals((Object)policyEnforcer, (Object)deserialized);
    }

    @Test
    public void test_validate() throws Exception {
        NoopPolicyEnforcer policyEnforcer = NoopPolicyEnforcer.instance();
        RowFilterPolicy policy = RowFilterPolicy.from((DimFilter)new NullFilter("some-col", null));
        TableDataSource table = TableDataSource.create((String)"table");
        RestrictedDataSource restricted = RestrictedDataSource.create((DataSource)table, (Policy)policy);
        Assert.assertTrue((boolean)policyEnforcer.validate(null));
        Assert.assertTrue((boolean)policyEnforcer.validate((Policy)policy));
        policyEnforcer.validateOrElseThrow(table, null);
        policyEnforcer.validateOrElseThrow(restricted.getBase(), restricted.getPolicy());
        TestSegmentUtils.SegmentForTesting segment = new TestSegmentUtils.SegmentForTesting("table", Intervals.ETERNITY, "1");
        Assert.assertTrue((boolean)policyEnforcer.validate(null));
        Assert.assertTrue((boolean)policyEnforcer.validate((Policy)policy));
        policyEnforcer.validateOrElseThrow((Segment)segment, null);
        policyEnforcer.validateOrElseThrow((Segment)segment, (Policy)policy);
    }
}

