/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.planning.ExecutionVertex;
import org.apache.druid.query.planning.JoinDataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class ExecutionVertexTest {
    private static final List<Interval> MILLENIUM_INTERVALS = ImmutableList.of((Object)Intervals.of((String)"2000/3000"));
    private static final TableDataSource TABLE_FOO = new TableDataSource("foo");
    private static final TableDataSource TABLE_BAR = new TableDataSource("bar");
    private static final RestrictedDataSource RESTRICTED_FOO = RestrictedDataSource.create((DataSource)TABLE_FOO, (Policy)NoRestrictionPolicy.instance());
    public static final LookupDataSource LOOKUP_LOOKYLOO = new LookupDataSource("lookyloo");
    public static final InlineDataSource INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[0]), (RowSignature)RowSignature.builder().add("column", ColumnType.STRING).build());

    @Test
    public void testTable() {
        ScanQuery makeScanQuery = ExecutionVertexTest.makeScanQuery((DataSource)TABLE_FOO);
        ExecutionVertex ev = ExecutionVertex.of((Query)makeScanQuery);
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
    }

    @Test
    public void testRestricted() {
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)RESTRICTED_FOO));
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
    }

    @Test
    public void testRestrictedInJoin() {
        JoinDataSource ds = ExecutionVertexTest.join((DataSource)RESTRICTED_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)ds));
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
    }

    @Test
    public void testUnion() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)unionDataSource));
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertEquals((Object)unionDataSource, (Object)ev.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
    }

    @Test
    public void testSubQueryOnTable() {
        QueryDataSource queryDataSource = ExecutionVertexTest.makeQueryDS((DataSource)TABLE_FOO);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeGroupByQuery((DataSource)queryDataSource));
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
    }

    @Test
    public void testQueryOnUnion() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        QueryDataSource queryDataSource = ExecutionVertexTest.makeQueryDS((DataSource)unionDataSource);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)queryDataSource));
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertFalse((boolean)ev.isTableBased());
        Assert.assertEquals((Object)queryDataSource, (Object)ev.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
    }

    @Test
    public void testLookup() {
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)LOOKUP_LOOKYLOO));
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertFalse((boolean)ev.isTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)ev.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
    }

    @Test
    public void testQueryOnLookup() {
        QueryDataSource queryDataSource = ExecutionVertexTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)queryDataSource));
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertFalse((boolean)ev.isTableBased());
        Assert.assertEquals((Object)queryDataSource, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
    }

    @Test
    public void testInline() {
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)INLINE));
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertFalse((boolean)ev.isTableBased());
        Assert.assertEquals((Object)INLINE, (Object)ev.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
    }

    @Test
    public void testJoinSimpleLeftLeaning() {
        JoinDataSource joinDataSource = ExecutionVertexTest.join((DataSource)ExecutionVertexTest.join((DataSource)ExecutionVertexTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER), (DataSource)INLINE, "2.", JoinType.LEFT), (DataSource)ExecutionVertexTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO), "3.", JoinType.FULL);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)joinDataSource));
        JoinDataSourceAnalysis analysis = joinDataSource.getJoinAnalysisForDataSource();
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause((JoinDataSource)((JoinDataSource)joinDataSource.getLeft()).getLeft()), (Object)new PreJoinableClause((JoinDataSource)joinDataSource.getLeft()), (Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("1.foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinSimpleLeftLeaningWithLeftFilter() {
        JoinDataSource joinDataSource = ExecutionVertexTest.join((DataSource)ExecutionVertexTest.join((DataSource)ExecutionVertexTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance()), (DataSource)INLINE, "2.", JoinType.LEFT), (DataSource)ExecutionVertexTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO), "3.", JoinType.FULL);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)joinDataSource));
        JoinDataSourceAnalysis analysis = joinDataSource.getJoinAnalysisForDataSource();
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause((JoinDataSource)((JoinDataSource)joinDataSource.getLeft()).getLeft()), (Object)new PreJoinableClause((JoinDataSource)joinDataSource.getLeft()), (Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("1.foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinSimpleRightLeaning() {
        JoinDataSource rightLeaningJoinStack = ExecutionVertexTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)ExecutionVertexTest.join((DataSource)INLINE, (DataSource)ExecutionVertexTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO), "1.", JoinType.LEFT), "2.", JoinType.FULL);
        JoinDataSource joinDataSource = ExecutionVertexTest.join((DataSource)TABLE_FOO, (DataSource)rightLeaningJoinStack, "3.", JoinType.RIGHT);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)joinDataSource));
        JoinDataSourceAnalysis analysis = joinDataSource.getJoinAnalysisForDataSource();
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertTrue((boolean)ev.isBaseColumn("1.foo"));
        Assert.assertTrue((boolean)ev.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinSimpleRightLeaningWithLeftFilter() {
        JoinDataSource rightLeaningJoinStack = ExecutionVertexTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)ExecutionVertexTest.join((DataSource)INLINE, (DataSource)ExecutionVertexTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO), "1.", JoinType.LEFT), "2.", JoinType.FULL);
        JoinDataSource joinDataSource = ExecutionVertexTest.join((DataSource)TABLE_FOO, (DataSource)rightLeaningJoinStack, "3.", JoinType.RIGHT, (DimFilter)TrueDimFilter.instance());
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)joinDataSource));
        JoinDataSourceAnalysis analysis = joinDataSource.getJoinAnalysisForDataSource();
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertTrue((boolean)ev.isBaseColumn("1.foo"));
        Assert.assertTrue((boolean)ev.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinOverTableSubquery() {
        JoinDataSource joinDataSource = ExecutionVertexTest.join((DataSource)TABLE_FOO, (DataSource)ExecutionVertexTest.makeQueryDS((DataSource)TABLE_FOO), "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance());
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)joinDataSource));
        JoinDataSourceAnalysis analysis = joinDataSource.getJoinAnalysisForDataSource();
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinTableUnionToLookup() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        JoinDataSource joinDataSource = ExecutionVertexTest.join((DataSource)unionDataSource, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)joinDataSource));
        JoinDataSourceAnalysis analysis1 = joinDataSource.getJoinAnalysisForDataSource();
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertThrows(DruidException.class, () -> ev.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis1.getJoinBaseTableFilter());
        Assert.assertEquals((Object)unionDataSource, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis1.getPreJoinableClauses());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinUnderTopLevelSubqueries() {
        QueryDataSource queryDataSource = ExecutionVertexTest.makeQueryDS((DataSource)ExecutionVertexTest.makeQueryDS((DataSource)ExecutionVertexTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance())));
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)queryDataSource));
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertFalse((boolean)ev.isTableBased());
        Assert.assertEquals((Object)queryDataSource, (Object)ev.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertTrue((boolean)ev.isBaseColumn("1.foo"));
    }

    @Test
    public void testSubqueriesAnalysis() {
        JoinDataSource joinDataSource = ExecutionVertexTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance());
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)ExecutionVertexTest.makeQueryDS((DataSource)joinDataSource)).setInterval((List)Intervals.ONLY_ETERNITY).setGranularity(Granularities.ALL).build();
        ExecutionVertex ev = ExecutionVertex.of((Query)query);
        JoinDataSourceAnalysis analysis = joinDataSource.getJoinAnalysisForDataSource();
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertTrue((boolean)ev.isTableBased());
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)ev.getBaseTableDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("1.foo"));
    }

    @Test
    public void testSubQuery3() {
        QueryDataSource queryDataSource = ExecutionVertexTest.makeQueryDS((DataSource)ExecutionVertexTest.makeQueryDS((DataSource)ExecutionVertexTest.makeQueryDS((DataSource)TABLE_FOO)));
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)queryDataSource));
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertFalse((boolean)ev.isTableBased());
        Assert.assertEquals((Object)queryDataSource, (Object)ev.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertTrue((boolean)ev.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinLookupToLookup() {
        JoinDataSource joinDataSource = ExecutionVertexTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)joinDataSource));
        JoinDataSourceAnalysis analysis = joinDataSource.getJoinAnalysisForDataSource();
        Assert.assertTrue((boolean)ev.isProcessable());
        Assert.assertFalse((boolean)ev.isTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)ev.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinLookupToTable() {
        JoinDataSource joinDataSource = ExecutionVertexTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)TABLE_FOO, "1.", JoinType.INNER);
        ExecutionVertex ev = ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)joinDataSource));
        JoinDataSourceAnalysis analysis = joinDataSource.getJoinAnalysisForDataSource();
        Assert.assertFalse((boolean)ev.isProcessable());
        Assert.assertFalse((boolean)ev.isTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)ev.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> ev.getBaseTableDataSource());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)ev.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)ev.isSegmentMapFunctionExpensive());
        Assert.assertTrue((boolean)ev.isBaseColumn("foo"));
        Assert.assertFalse((boolean)ev.isBaseColumn("1.foo"));
    }

    @Test
    public void testHashCodeIsNotSupported() {
        Assertions.assertThrows(Exception.class, () -> ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)TABLE_FOO)).hashCode());
    }

    @Test
    public void testEqualsIsNotSupported() {
        Assertions.assertThrows(Exception.class, () -> ExecutionVertex.of((Query)ExecutionVertexTest.makeScanQuery((DataSource)TABLE_FOO)).equals(null));
    }

    private static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, JoinType joinType, DimFilter dimFilter) {
        return JoinDataSource.create((DataSource)left, (DataSource)right, (String)rightPrefix, (String)ExecutionVertexTest.joinClause(rightPrefix).getOriginalExpression(), (JoinType)joinType, (DimFilter)dimFilter, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
    }

    private static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, JoinType joinType) {
        return ExecutionVertexTest.join(left, right, rightPrefix, joinType, null);
    }

    private static JoinConditionAnalysis joinClause(String rightPrefix) {
        return JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"x == \"%sx\"", (Object[])new Object[]{rightPrefix}), (String)rightPrefix, (ExprMacroTable)ExprMacroTable.nil());
    }

    private static QueryDataSource makeQueryDS(DataSource dataSource) {
        return new QueryDataSource((Query)ExecutionVertexTest.makeGroupByQuery(dataSource));
    }

    private static GroupByQuery makeGroupByQuery(DataSource dataSource) {
        return GroupByQuery.builder().setDataSource(dataSource).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)).setGranularity(Granularities.ALL).build();
    }

    public static ScanQuery makeScanQuery(DataSource dataSource) {
        return Druids.newScanQueryBuilder().dataSource(dataSource).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)).build();
    }
}

