/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.value;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import org.apache.druid.query.operator.window.ComposingProcessor;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.value.WindowLastProcessor;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.DoubleArrayColumn;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Test;

public class WindowLastProcessorTest {
    @Test
    public void testLastProcessing() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{88, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.4728, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.84}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        map.put("nullLastCol", new ObjectArrayColumn((Object[])new String[]{null, "b", "c", "d", "e", "f", "g", "h", "i", null}, ColumnType.STRING));
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap(map);
        ComposingProcessor processor = new ComposingProcessor(new Processor[]{new WindowLastProcessor("intCol", "LastIntCol"), new WindowLastProcessor("doubleCol", "LastDoubleCol"), new WindowLastProcessor("objectCol", "LastObjectCol"), new WindowLastProcessor("nullLastCol", "NullLastCol")});
        Assert.assertEquals((Object)ImmutableList.of((Object)"LastIntCol", (Object)"LastDoubleCol", (Object)"LastObjectCol", (Object)"NullLastCol"), (Object)processor.getOutputColumnNames());
        RowsAndColumnsHelper expectations = new RowsAndColumnsHelper().expectColumn("intCol", new int[]{88, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.4728, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.84}).expectColumn("LastIntCol", new int[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}).expectColumn("LastDoubleCol", new double[]{9.84, 9.84, 9.84, 9.84, 9.84, 9.84, 9.84, 9.84, 9.84, 9.84});
        expectations.columnHelper("LastObjectCol", 10, ColumnType.STRING).setExpectation(new String[]{"j", "j", "j", "j", "j", "j", "j", "j", "j", "j"});
        expectations.columnHelper("NullLastCol", 10, ColumnType.STRING).setNulls(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        RowsAndColumns results = processor.process((RowsAndColumns)rac);
        expectations.validate(results);
    }
}

