/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.ResultSerializationMode;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.operator.WindowOperatorQueryQueryToolChest;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.WindowOperatorFactory;
import org.apache.druid.query.operator.window.ranking.WindowRowNumberProcessor;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WindowOperatorQueryQueryToolChestTest
extends InitializedNullHandlingTest {
    private final WindowOperatorQueryQueryToolChest toolchest = new WindowOperatorQueryQueryToolChest(DefaultGenericQueryMetricsFactory.instance());

    @Test
    public void mergeResultsWithRowResultSerializationMode() {
        RowSignature inputSignature = RowSignature.builder().add("length", ColumnType.LONG).build();
        RowSignature outputSignature = RowSignature.builder().addAll(inputSignature).add("w0", ColumnType.LONG).build();
        WindowOperatorQuery query = new WindowOperatorQuery((DataSource)new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("test")).intervals((QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.ETERNITY)).columns(new String[]{"length"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(new HashMap()).build()), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.ETERNITY), new HashMap(), outputSignature, (List)ImmutableList.of((Object)new WindowOperatorFactory((Processor)new WindowRowNumberProcessor("w0"))), (List)ImmutableList.of());
        List results = this.toolchest.mergeResults((queryPlus, responseContext) -> Sequences.simple(Collections.singletonList(MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"length", (Object)new IntArrayColumn(new int[]{1, 5, 10})))))).run(QueryPlus.wrap((Query)query)).toList();
        Assert.assertTrue((boolean)(results.get(0) instanceof Object[]));
        Assert.assertEquals((long)3L, (long)results.size());
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{1, 1}, (Object)new Object[]{5, 2}, (Object)new Object[]{10, 3});
        for (int i = 0; i < 3; ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
    }

    @Test
    public void mergeResultsWithFrameResultSerializationMode() {
        RowSignature inputSignature = RowSignature.builder().add("length", ColumnType.LONG).build();
        RowSignature outputSignature = RowSignature.builder().addAll(inputSignature).add("w0", ColumnType.LONG).build();
        WindowOperatorQuery query = new WindowOperatorQuery((DataSource)new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("test")).intervals((QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.ETERNITY)).columns(new String[]{"length"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(new HashMap()).build()), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.ETERNITY), Collections.singletonMap("serialization", ResultSerializationMode.FRAMES.toString()), outputSignature, (List)ImmutableList.of((Object)new WindowOperatorFactory((Processor)new WindowRowNumberProcessor("w0"))), (List)ImmutableList.of());
        List results = this.toolchest.mergeResults((queryPlus, responseContext) -> Sequences.simple(Collections.singletonList(MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"length", (Object)new IntArrayColumn(new int[]{1, 5, 10})))))).run(QueryPlus.wrap((Query)query)).toList();
        Assert.assertTrue((boolean)(results.get(0) instanceof FrameSignaturePair));
        Assert.assertEquals((long)1L, (long)results.size());
        FrameReader reader = FrameReader.create((RowSignature)((FrameSignaturePair)results.get(0)).getRowSignature());
        List resultRows = FrameTestUtil.readRowsFromCursorFactory(reader.makeCursorFactory(((FrameSignaturePair)results.get(0)).getFrame())).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)1L), (Object)ImmutableList.of((Object)5L, (Object)2L), (Object)ImmutableList.of((Object)10L, (Object)3L));
        Assertions.assertEquals((Object)expectedResults, (Object)resultRows);
    }
}

