/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilters;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.ScanOperator;
import org.apache.druid.query.operator.ScanOperatorFactory;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.TestRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.RowsAndColumnsDecorator;
import org.apache.druid.query.rowsandcols.semantic.TestRowsAndColumnsDecorator;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class ScanOperatorFactoryTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(ScanOperatorFactory.class).usingGetClass().verify();
    }

    @Test
    public void testWrappedOperatorCarriesThroughValues() throws JsonProcessingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class, (Object)TestExprMacroTable.INSTANCE));
        Interval[] intervals = new Interval[]{Intervals.utc((long)0L, (long)6L), Intervals.utc((long)6L, (long)13L), Intervals.utc((long)4L, (long)8L)};
        DimFilter[] filters = new DimFilter[]{new InDimFilter("dim", (Set)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"e", (Object)"g")), DimFilters.and((DimFilter[])new DimFilter[]{new InDimFilter("dim", (Set)ImmutableSet.of((Object)"a", (Object)"b", (Object)"g")), DimFilters.dimEquals((String)"val", (String)"789")}), DimFilters.or((DimFilter[])new DimFilter[]{DimFilters.dimEquals((String)"dim", (String)"b"), DimFilters.dimEquals((String)"val", (String)"789")}), DimFilters.dimEquals((String)"dim", (String)"f")};
        int[] limits = new int[]{100, 1000};
        List[] orderings = new List[]{Arrays.asList(ColumnWithDirection.descending((String)"__time"), ColumnWithDirection.ascending((String)"dim")), Collections.singletonList(ColumnWithDirection.ascending((String)"val")), Collections.emptyList()};
        List[] projections = new List[]{Arrays.asList("dim", "val"), Collections.singletonList("dim"), Collections.emptyList()};
        VirtualColumns[] virtualCols = new VirtualColumns[]{VirtualColumns.create(Collections.singletonList(new ExpressionVirtualColumn("test", "2", null, TestExprMacroTable.INSTANCE)))};
        for (int i = 0; i <= intervals.length; ++i) {
            Interval interval = i == 0 ? null : intervals[i - 1];
            for (int j = 0; j <= filters.length; ++j) {
                DimFilter filter = j == 0 ? null : filters[j - 1];
                for (int k = 0; k <= limits.length; ++k) {
                    int limit = k == 0 ? -1 : limits[k - 1];
                    for (int l = 0; l <= orderings.length; ++l) {
                        List ordering = l == 0 ? null : orderings[l - 1];
                        for (int m = 0; m <= projections.length; ++m) {
                            List projection = m == 0 ? null : projections[m - 1];
                            for (int n = 0; n <= virtualCols.length; ++n) {
                                VirtualColumns virtual = n == 0 ? VirtualColumns.EMPTY : virtualCols[n - 1];
                                final String msg = StringUtils.format((String)"interval[%s], filter[%s], limit[%s], ordering[%s], projection[%s], virtual[%s]", (Object[])new Object[]{interval, filter, OffsetLimit.limit((int)limit), ordering, projection, virtual});
                                final ScanOperatorFactory factory = new ScanOperatorFactory(interval, filter, OffsetLimit.limit((int)limit), projection, virtual, ordering);
                                String asString = mapper.writeValueAsString((Object)factory);
                                ScanOperatorFactory deserialized = (ScanOperatorFactory)mapper.readValue(asString, ScanOperatorFactory.class);
                                Assert.assertEquals((String)msg, (Object)factory, (Object)deserialized);
                                Assert.assertEquals((String)msg, (long)factory.hashCode(), (long)deserialized.hashCode());
                                ScanOperator wrapped = (ScanOperator)factory.wrap(new Operator(){

                                    @Nullable
                                    public Closeable goOrContinue(Closeable continuationObject, Operator.Receiver receiver) {
                                        receiver.push((RowsAndColumns)new TestRowsAndColumns().withAsImpl(RowsAndColumnsDecorator.class, TestRowsAndColumnsDecorator::new));
                                        receiver.completed();
                                        return null;
                                    }
                                });
                                Operator.go((Operator)wrapped, (Operator.Receiver)new Operator.Receiver(){

                                    public Operator.Signal push(RowsAndColumns inRac) {
                                        TestRowsAndColumnsDecorator.DecoratedRowsAndColumns rac = (TestRowsAndColumnsDecorator.DecoratedRowsAndColumns)inRac;
                                        Assert.assertEquals((String)msg, (Object)factory.getTimeRange(), (Object)rac.getTimeRange());
                                        Assert.assertEquals((String)msg, (Object)factory.getOffsetLimit(), (Object)rac.getOffsetLimit());
                                        Assert.assertEquals((String)msg, (Object)factory.getVirtualColumns(), (Object)rac.getVirtualColumns());
                                        ScanOperatorFactoryTest.validateList(msg, factory.getOrdering(), rac.getOrdering());
                                        ScanOperatorFactoryTest.validateList(msg, factory.getProjectedColumns(), rac.getProjectedColumns());
                                        Assert.assertEquals((String)msg, (Object)(factory.getFilter() == null ? null : factory.getFilter().toFilter()), (Object)rac.getFilter());
                                        return Operator.Signal.GO;
                                    }

                                    public void completed() {
                                    }
                                });
                            }
                        }
                    }
                }
            }
        }
    }

    private static <T> void validateList(String msg, List<T> expectedList, List<T> actualList) {
        if (expectedList != null && expectedList.isEmpty()) {
            Assert.assertNull((String)msg, actualList);
        } else {
            Assert.assertEquals((String)msg, expectedList, actualList);
        }
    }

    private static class Builder {
        private Interval timeRange;
        private DimFilter filter;
        private OffsetLimit offsetLimit;
        private List<String> projectedColumns;
        private VirtualColumns virtualColumns;
        private List<ColumnWithDirection> ordering;

        private Builder() {
        }

        public Builder setTimeRange(Interval timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public Builder setFilter(DimFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setOffsetLimit(OffsetLimit offsetLimit) {
            this.offsetLimit = offsetLimit;
            return this;
        }

        public Builder setProjectedColumns(List<String> projectedColumns) {
            this.projectedColumns = projectedColumns;
            return this;
        }

        public Builder setVirtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public Builder setOrdering(List<ColumnWithDirection> ordering) {
            this.ordering = ordering;
            return this;
        }

        private Builder copy() {
            Builder retVal = new Builder();
            retVal.timeRange = this.timeRange;
            retVal.filter = this.filter;
            retVal.offsetLimit = this.offsetLimit;
            retVal.projectedColumns = this.projectedColumns;
            retVal.virtualColumns = this.virtualColumns;
            retVal.ordering = this.ordering;
            return retVal;
        }

        private ScanOperatorFactory build() {
            return new ScanOperatorFactory(this.timeRange, this.filter, this.offsetLimit, this.projectedColumns, this.virtualColumns, this.ordering);
        }
    }
}

