/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class LookupExtractorTest
extends InitializedNullHandlingTest {
    static final Map<String, String> EXPECTED_MAP = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2", (Object)"key-1", (Object)"value1", (Object)"", (Object)"emptyString");
    static final Set<String> EXPECTED_REVERSE_SET = ImmutableSet.of((Object)"key1", (Object)"key-1", (Object)"key2", (Object)"");
    LookupExtractor lookupExtractor = new MapLookupExtractor(EXPECTED_MAP, false);

    @Test
    public void testSerDes() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)this.lookupExtractor, (Object)mapper.readerFor(LookupExtractor.class).readValue(mapper.writeValueAsBytes((Object)this.lookupExtractor)));
    }

    @Test
    public void testApplyAll() {
        Assert.assertEquals(EXPECTED_MAP, (Object)this.lookupExtractor.applyAll(EXPECTED_MAP.keySet()));
    }

    @Test
    public void testApplyAllWithNull() {
        Assert.assertEquals(Collections.emptyMap(), (Object)this.lookupExtractor.applyAll(null));
    }

    @Test
    public void testApplyAllWithEmptySet() {
        Assert.assertEquals(Collections.emptyMap(), (Object)this.lookupExtractor.applyAll(Collections.emptySet()));
    }

    @Test
    public void testApplyAllWithNotExisting() {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("not there", null);
        Assert.assertEquals(expected, (Object)this.lookupExtractor.applyAll(Collections.singletonList("not there")));
    }

    @Test
    public void testUnapplyAllWithEmptySet() {
        Assert.assertEquals(Collections.emptySet(), LookupExtractorTest.toSet(this.lookupExtractor.unapplyAll(Collections.emptySet())));
    }

    @Test
    public void testUnapplyAll() {
        Assert.assertEquals(EXPECTED_REVERSE_SET, LookupExtractorTest.toSet(this.lookupExtractor.unapplyAll(new HashSet<String>(EXPECTED_MAP.values()))));
    }

    @Nullable
    private static <T> Set<T> toSet(@Nullable Iterator<T> iterator) {
        if (iterator == null) {
            return null;
        }
        return Sets.newHashSet(iterator);
    }
}

