/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class ResultRowTest {
    @Test
    public void testSerde() throws Exception {
        ResultRow row = ResultRow.of((Object[])new Object[]{1, 2, 3});
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Assert.assertEquals((Object)row, (Object)objectMapper.readValue("[1, 2, 3]", ResultRow.class));
        Assert.assertEquals((Object)row, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)row), ResultRow.class));
    }

    @Test
    public void testMapBasedRowWithNullValues() {
        GroupByQuery query = new GroupByQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2011/2012"))), null, null, Granularities.ALL, (List)ImmutableList.of((Object)new DefaultDimensionSpec("dim1", "dim1"), (Object)new DefaultDimensionSpec("dim2", "dim2"), (Object)new DefaultDimensionSpec("dim3", "dim3")), (List)ImmutableList.of((Object)new CountAggregatorFactory("count")), null, null, null, null, null);
        ResultRow row = ResultRow.of((Object[])new Object[]{"1", "2", null});
        MapBasedRow mapBasedRow = row.toMapBasedRow(query);
        Assert.assertEquals((Object)"1", (Object)mapBasedRow.getRaw("dim1"));
        Assert.assertEquals((Object)"2", (Object)mapBasedRow.getRaw("dim2"));
        Assert.assertNull((Object)mapBasedRow.getRaw("dim3"));
        Assert.assertTrue((boolean)mapBasedRow.getEvent().containsKey("dim3"));
    }
}

