/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import org.apache.druid.query.QueryResourceId;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.junit.Assert;
import org.junit.Test;

public class GroupByStatsProviderTest {
    @Test
    public void testMetricCollection() {
        GroupByStatsProvider statsProvider = new GroupByStatsProvider();
        QueryResourceId id1 = new QueryResourceId("q1");
        GroupByStatsProvider.PerQueryStats stats1 = statsProvider.getPerQueryStatsContainer(id1);
        stats1.mergeBufferAcquisitionTime(300L);
        stats1.mergeBufferAcquisitionTime(400L);
        stats1.spilledBytes(200L);
        stats1.spilledBytes(400L);
        stats1.dictionarySize(100L);
        stats1.dictionarySize(200L);
        QueryResourceId id2 = new QueryResourceId("q2");
        GroupByStatsProvider.PerQueryStats stats2 = statsProvider.getPerQueryStatsContainer(id2);
        stats2.mergeBufferAcquisitionTime(500L);
        stats2.mergeBufferAcquisitionTime(600L);
        stats2.spilledBytes(400L);
        stats2.spilledBytes(600L);
        stats2.dictionarySize(300L);
        stats2.dictionarySize(400L);
        GroupByStatsProvider.AggregateStats aggregateStats = statsProvider.getStatsSince();
        Assert.assertEquals((long)0L, (long)aggregateStats.getMergeBufferQueries());
        Assert.assertEquals((long)0L, (long)aggregateStats.getMergeBufferAcquisitionTimeNs());
        Assert.assertEquals((long)0L, (long)aggregateStats.getSpilledQueries());
        Assert.assertEquals((long)0L, (long)aggregateStats.getSpilledBytes());
        Assert.assertEquals((long)0L, (long)aggregateStats.getMergeDictionarySize());
        statsProvider.closeQuery(id1);
        statsProvider.closeQuery(id2);
        aggregateStats = statsProvider.getStatsSince();
        Assert.assertEquals((long)2L, (long)aggregateStats.getMergeBufferQueries());
        Assert.assertEquals((long)1800L, (long)aggregateStats.getMergeBufferAcquisitionTimeNs());
        Assert.assertEquals((long)2L, (long)aggregateStats.getSpilledQueries());
        Assert.assertEquals((long)1600L, (long)aggregateStats.getSpilledBytes());
        Assert.assertEquals((long)1000L, (long)aggregateStats.getMergeDictionarySize());
    }
}

