/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DefaultBlockingPool;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.data.input.Row;
import org.apache.druid.jackson.AggregatorsModule;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryToolChestTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongDouble;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.firstlast.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.having.AndHavingSpec;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.groupby.having.EqualToHavingSpec;
import org.apache.druid.query.groupby.having.GreaterThanHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.having.LessThanHavingSpec;
import org.apache.druid.query.groupby.having.NotHavingSpec;
import org.apache.druid.query.groupby.having.OrHavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GroupByQueryQueryToolChestTest
extends InitializedNullHandlingTest {
    @BeforeClass
    public static void setUpClass() {
        AggregatorsModule.registerComplexMetricsAndSerde();
    }

    @Test
    public void testResultLevelCacheKeyWithPostAggregate() {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias - 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query2, mapper);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithLimitSpec() {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias - 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query2, mapper);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithHavingSpec() {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("uniques", (Number)8)).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("uniques", (Number)10)).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query2, mapper);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithAndHavingSpec() {
        List<HavingSpec> havings = Arrays.asList(new GreaterThanHavingSpec("agg", (Number)1.3), new OrHavingSpec(Arrays.asList(new LessThanHavingSpec("lessAgg", (Number)1L), new NotHavingSpec((HavingSpec)new EqualToHavingSpec("equalAgg", (Number)2.0)))));
        AndHavingSpec andHavingSpec = new AndHavingSpec(havings);
        List<HavingSpec> havings2 = Arrays.asList(new GreaterThanHavingSpec("agg", (Number)13.0), new OrHavingSpec(Arrays.asList(new LessThanHavingSpec("lessAgg", (Number)1L), new NotHavingSpec((HavingSpec)new EqualToHavingSpec("equalAgg", (Number)22.0)))));
        AndHavingSpec andHavingSpec2 = new AndHavingSpec(havings2);
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)andHavingSpec).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)andHavingSpec2).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query2, mapper);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithHavingDimFilterHavingSpec() {
        DimFilterHavingSpec havingSpec1 = new DimFilterHavingSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new OrDimFilter((List)ImmutableList.of((Object)new BoundDimFilter("rows", "2", null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (Object)new SelectorDimFilter("idx", "217", null))), (Object)new SelectorDimFilter("__time", String.valueOf(DateTimes.of((String)"2011-04-01").getMillis()), null))), null);
        DimFilterHavingSpec havingSpec2 = new DimFilterHavingSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new OrDimFilter((List)ImmutableList.of((Object)new BoundDimFilter("rows", "2", null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (Object)new SelectorDimFilter("idx", "317", null))), (Object)new SelectorDimFilter("__time", String.valueOf(DateTimes.of((String)"2011-04-01").getMillis()), null))), null);
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)havingSpec1).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setHavingSpec((HavingSpec)havingSpec2).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query2, mapper);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithSubTotalsSpec() {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new FloatSumAggregatorFactory("idxFloat", "indexFloat"), new DoubleSumAggregatorFactory("idxDouble", "index"))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"alias"), (Object)ImmutableList.of((Object)"market"), (Object)ImmutableList.of())).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), new FloatSumAggregatorFactory("idxFloat", "indexFloat"), new DoubleSumAggregatorFactory("idxDouble", "index"))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"alias"), (Object)ImmutableList.of())).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query2, mapper);
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testCacheStrategy() throws Exception {
        this.doTestCacheStrategy(ColumnType.STRING, "val1");
        this.doTestCacheStrategy(ColumnType.FLOAT, Float.valueOf(2.1f));
        this.doTestCacheStrategy(ColumnType.DOUBLE, 2.1);
        this.doTestCacheStrategy(ColumnType.LONG, 2L);
    }

    @Test
    public void testComplexDimensionCacheStrategy() throws IOException {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)ImmutableList.of((Object)new DefaultDimensionSpec("test", "test", ColumnType.ofComplex((String)"serializablePairLongString")))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, objectMapper);
        ResultRow result1 = ResultRow.of((Object[])new Object[]{123L, new SerializablePairLongString(Long.valueOf(123L), "abc"), 1});
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result1);
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        ResultRow fromCacheResult = (ResultRow)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result1, (Object)fromCacheResult);
    }

    @Test
    public void testMultiColumnCacheStrategy() throws Exception {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)ImmutableList.of((Object)new DefaultDimensionSpec("test", "test", ColumnType.STRING), (Object)new DefaultDimensionSpec("v0", "v0", ColumnType.STRING))).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat('foo', test)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, this.getComplexAggregatorFactoryForValueType(ValueType.STRING))).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ConstantPostAggregator("post", (Number)10))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        ResultRow result1 = ResultRow.of((Object[])new Object[]{123L, "val1", "fooval1", 1, this.getIntermediateComplexValue(ValueType.STRING, "val1")});
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result1);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        ResultRow fromCacheResult = (ResultRow)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result1, (Object)fromCacheResult);
    }

    @Test
    public void testResultSerde() throws Exception {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(Collections.singletonList(DefaultDimensionSpec.of((String)"test"))).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).setPostAggregatorSpecs(Collections.singletonList(new ConstantPostAggregator("post", (Number)10))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(null, null);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        ObjectMapper arraysObjectMapper = toolChest.decorateObjectMapper(objectMapper, query.withOverriddenContext((Map)ImmutableMap.of((Object)"resultAsArray", (Object)true)));
        ObjectMapper mapsObjectMapper = toolChest.decorateObjectMapper(objectMapper, query.withOverriddenContext((Map)ImmutableMap.of((Object)"resultAsArray", (Object)false)));
        Object[] rowObjects = new Object[]{DateTimes.of((String)"2000").getMillis(), "foo", 100, 10.0};
        ResultRow resultRow = ResultRow.of((Object[])rowObjects);
        Assert.assertArrayEquals((String)"standard mapper reads ResultRows", (Object[])rowObjects, (Object[])((Object[])objectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), Object[].class)));
        Assert.assertEquals((String)"standard mapper reads MapBasedRows", (Object)resultRow.toMapBasedRow(query), (Object)objectMapper.readValue(mapsObjectMapper.writeValueAsBytes((Object)resultRow), Row.class));
        Assert.assertEquals((String)"array mapper reads arrays", (Object)resultRow, (Object)arraysObjectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        Assert.assertEquals((String)"array mapper reads arrays (2)", (Object)resultRow, (Object)arraysObjectMapper.readValue(StringUtils.format((String)"[%s, \"foo\", 100, 10.0]", (Object[])new Object[]{DateTimes.of((String)"2000").getMillis()}), ResultRow.class));
        Assert.assertEquals((String)"map mapper reads arrays", (Object)resultRow, (Object)mapsObjectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        Assert.assertEquals((String)"map mapper reads maps", (Object)resultRow, (Object)mapsObjectMapper.readValue(mapsObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
    }

    @Test
    public void testResultSerdeWithComplexDimension() throws Exception {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"test"), (Object)new DefaultDimensionSpec("test2", "test2", ColumnType.ofComplex((String)"serializablePairLongString")))).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).setPostAggregatorSpecs(Collections.singletonList(new ConstantPostAggregator("post", (Number)10))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(null, null);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        ObjectMapper arraysObjectMapper = toolChest.decorateObjectMapper(objectMapper, query.withOverriddenContext((Map)ImmutableMap.of((Object)"resultAsArray", (Object)true)));
        ObjectMapper mapsObjectMapper = toolChest.decorateObjectMapper(objectMapper, query.withOverriddenContext((Map)ImmutableMap.of((Object)"resultAsArray", (Object)false)));
        Object[] rowObjects = new Object[]{DateTimes.of((String)"2000").getMillis(), "foo", new SerializablePairLongString(Long.valueOf(1L), "test"), 100, 10.0};
        ResultRow resultRow = ResultRow.of((Object[])rowObjects);
        Assert.assertEquals((String)"array mapper reads arrays", (Object)resultRow, (Object)arraysObjectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        Assert.assertEquals((String)"array mapper reads arrays (2)", (Object)resultRow, (Object)arraysObjectMapper.readValue(StringUtils.format((String)"[%s, \"foo\", {\"lhs\":1,\"rhs\":\"test\"}, 100, 10.0]", (Object[])new Object[]{DateTimes.of((String)"2000").getMillis()}), ResultRow.class));
        Assert.assertEquals((String)"map mapper reads arrays", (Object)resultRow, (Object)mapsObjectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        Assert.assertEquals((String)"map mapper reads maps", (Object)resultRow, (Object)mapsObjectMapper.readValue(mapsObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
    }

    @Test
    public void testResultSerdeIntermediateResultAsMapCompat() throws Exception {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(Collections.singletonList(DefaultDimensionSpec.of((String)"test"))).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).setPostAggregatorSpecs(Collections.singletonList(new ConstantPostAggregator("post", (Number)10))).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(null, () -> new GroupByQueryConfig(){

            public boolean isIntermediateResultAsMapCompat() {
                return true;
            }
        }, null, null, null);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        ObjectMapper arraysObjectMapper = toolChest.decorateObjectMapper(objectMapper, query.withOverriddenContext((Map)ImmutableMap.of((Object)"resultAsArray", (Object)true)));
        ObjectMapper mapsObjectMapper = toolChest.decorateObjectMapper(objectMapper, query.withOverriddenContext((Map)ImmutableMap.of((Object)"resultAsArray", (Object)false)));
        Object[] rowObjects = new Object[]{DateTimes.of((String)"2000").getMillis(), "foo", 100, 10.0};
        ResultRow resultRow = ResultRow.of((Object[])rowObjects);
        Assert.assertEquals((Object)resultRow, (Object)arraysObjectMapper.readValue(StringUtils.format((String)"[%s, \"foo\", 100, 10.0]", (Object[])new Object[]{DateTimes.of((String)"2000").getMillis()}), ResultRow.class));
        Assert.assertArrayEquals((String)"standard mapper reads ResultRows", (Object[])rowObjects, (Object[])((Object[])objectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), Object[].class)));
        Assert.assertEquals((String)"standard mapper reads MapBasedRows", (Object)resultRow.toMapBasedRow(query), (Object)objectMapper.readValue(mapsObjectMapper.writeValueAsBytes((Object)resultRow), Row.class));
        Assert.assertEquals((String)"array mapper reads arrays", (Object)resultRow, (Object)arraysObjectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        Assert.assertEquals((String)"array mapper reads maps", (Object)resultRow, (Object)arraysObjectMapper.readValue(mapsObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        TestHelper.assertRow("array mapper reads maps (2)", resultRow, (ResultRow)arraysObjectMapper.readValue(StringUtils.format((String)"{\"version\":\"v1\",\"timestamp\":\"%s\",\"event\":  {\"test\":\"foo\", \"rows\":100, \"post\":10.0}}", (Object[])new Object[]{DateTimes.of((String)"2000")}), ResultRow.class));
        Assert.assertEquals((String)"map mapper reads arrays", (Object)resultRow, (Object)mapsObjectMapper.readValue(arraysObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
        Assert.assertEquals((String)"map mapper reads maps", (Object)resultRow, (Object)mapsObjectMapper.readValue(mapsObjectMapper.writeValueAsBytes((Object)resultRow), ResultRow.class));
    }

    @Test
    public void testResultArraySignatureAllGran() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("col", "dim")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setAggregatorSpecs(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.CONSTANT)).build();
        Assert.assertEquals((Object)RowSignature.builder().add("dim", ColumnType.STRING).add("rows", ColumnType.LONG).add("index", ColumnType.DOUBLE).add("uniques", null).add("const", ColumnType.LONG).build(), (Object)new GroupByQueryQueryToolChest(null, null).resultArraySignature(query));
    }

    @Test
    public void testResultArraySignatureDayGran() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.DAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("col", "dim")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setAggregatorSpecs(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.CONSTANT)).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("dim", ColumnType.STRING).add("rows", ColumnType.LONG).add("index", ColumnType.DOUBLE).add("uniques", null).add("const", ColumnType.LONG).build(), (Object)new GroupByQueryQueryToolChest(null, null).resultArraySignature(query));
    }

    @Test
    public void testResultsAsArraysAllGran() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("col", "dim")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setAggregatorSpecs(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.CONSTANT)).build();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{"foo", 1L, 2L, 3L, 1L}, (Object)new Object[]{"bar", 4L, 5L, 6L, 1L}), (Sequence<Object[]>)new GroupByQueryQueryToolChest(null, null).resultsAsArrays(query, Sequences.simple((Iterable)ImmutableList.of((Object)GroupByQueryQueryToolChestTest.makeRow(query, "2000", "dim", "foo", "rows", 1L, "index", 2L, "uniques", 3L, "const", 1L), (Object)GroupByQueryQueryToolChestTest.makeRow(query, "2000", "dim", "bar", "rows", 4L, "index", 5L, "uniques", 6L, "const", 1L)))));
    }

    @Test
    public void testResultsAsArraysDayGran() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.DAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("col", "dim")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setAggregatorSpecs(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.CONSTANT)).build();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000-01-01").getMillis(), "foo", 1L, 2L, 3L, 1L}, (Object)new Object[]{DateTimes.of((String)"2000-01-02").getMillis(), "bar", 4L, 5L, 6L, 1L}), (Sequence<Object[]>)new GroupByQueryQueryToolChest(null, null).resultsAsArrays(query, Sequences.simple((Iterable)ImmutableList.of((Object)GroupByQueryQueryToolChestTest.makeRow(query, "2000-01-01", "dim", "foo", "rows", 1L, "index", 2L, "uniques", 3L, "const", 1L), (Object)GroupByQueryQueryToolChestTest.makeRow(query, "2000-01-02", "dim", "bar", "rows", 4L, "index", 5L, "uniques", 6L, "const", 1L)))));
    }

    @Test
    public void testCanPerformSubqueryOnGroupBys() {
        Assert.assertTrue((boolean)new GroupByQueryQueryToolChest(null, null).canPerformSubquery((Query)new GroupByQuery.Builder().setDataSource((DataSource)new QueryDataSource((Query)new GroupByQuery.Builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setGranularity(Granularities.ALL).build())).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setGranularity(Granularities.ALL).build()));
    }

    @Test
    public void testCanPerformSubqueryOnTimeseries() {
        Assert.assertFalse((boolean)new GroupByQueryQueryToolChest(null, null).canPerformSubquery((Query)Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).granularity(Granularities.ALL).build()));
    }

    @Test
    public void testCanPerformSubqueryOnGroupByOfTimeseries() {
        Assert.assertFalse((boolean)new GroupByQueryQueryToolChest(null, null).canPerformSubquery((Query)new GroupByQuery.Builder().setDataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).granularity(Granularities.ALL).build())).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setGranularity(Granularities.ALL).build()));
    }

    private AggregatorFactory getComplexAggregatorFactoryForValueType(ValueType valueType) {
        switch (valueType) {
            case LONG: {
                return new LongLastAggregatorFactory("complexMetric", "test", null);
            }
            case DOUBLE: {
                return new DoubleLastAggregatorFactory("complexMetric", "test", null);
            }
            case FLOAT: {
                return new FloatLastAggregatorFactory("complexMetric", "test", null);
            }
            case STRING: {
                return new StringLastAggregatorFactory("complexMetric", "test", null, null);
            }
        }
        throw new IllegalArgumentException("bad valueType: " + String.valueOf(valueType));
    }

    private SerializablePair getIntermediateComplexValue(ValueType valueType, Object dimValue) {
        switch (valueType) {
            case LONG: {
                return new SerializablePairLongLong(Long.valueOf(123L), Long.valueOf((Long)dimValue));
            }
            case DOUBLE: {
                return new SerializablePairLongDouble(Long.valueOf(123L), Double.valueOf((Double)dimValue));
            }
            case FLOAT: {
                return new SerializablePairLongFloat(Long.valueOf(123L), Float.valueOf(((Float)dimValue).floatValue()));
            }
            case STRING: {
                return new SerializablePairLongString(Long.valueOf(123L), (String)dimValue);
            }
        }
        throw new IllegalArgumentException("bad valueType: " + String.valueOf(valueType));
    }

    private void doTestCacheStrategy(ColumnType valueType, Object dimValue) throws IOException {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(Collections.singletonList(new DefaultDimensionSpec("test", "test", valueType))).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, this.getComplexAggregatorFactoryForValueType((ValueType)valueType.getType()))).setPostAggregatorSpecs(new PostAggregator[]{new ConstantPostAggregator("post", (Number)10), new ConstantPostAggregator("post2", (Number)20)}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        ResultRow result1 = ResultRow.of((Object[])new Object[]{123L, dimValue, 1, this.getIntermediateComplexValue((ValueType)valueType.getType(), dimValue)});
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result1);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        ResultRow fromCacheResult = (ResultRow)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result1, (Object)fromCacheResult);
        ResultRow result2 = ResultRow.of((Object[])new Object[]{123L, dimValue, 1, dimValue, 10, 20});
        ResultRow typeAdjustedResult2 = valueType.is((TypeDescriptor)ValueType.FLOAT) ? ResultRow.of((Object[])new Object[]{123L, dimValue, 1, 2.1, 10, 20}) : (valueType.is((TypeDescriptor)ValueType.LONG) ? ResultRow.of((Object[])new Object[]{123L, dimValue, 1, 2, 10, 20}) : result2);
        Object preparedResultCacheValue = strategy.prepareForCache(true).apply((Object)result2);
        Object fromResultCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedResultCacheValue), strategy.getCacheObjectClazz());
        ResultRow fromResultCacheResult = (ResultRow)strategy.pullFromCache(true).apply(fromResultCacheValue);
        Assert.assertEquals((Object)typeAdjustedResult2, (Object)fromResultCacheResult);
    }

    @Test
    public void testQueryCacheKeyWithLimitSpec() {
        GroupByQuery query1 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec(null, Integer.valueOf(100))).overrideContext((Map)ImmutableMap.of((Object)"applyLimitPushDown", (Object)"true")).build();
        GroupByQuery query2 = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec(null, Integer.valueOf(1000))).build();
        GroupByQuery queryNoLimit = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query2, mapper);
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)queryNoLimit)));
    }

    @Test
    public void testQueryCacheKeyWithLimitSpecPushDownUsingContext() {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).setLimitSpec((LimitSpec)new DefaultLimitSpec(null, Integer.valueOf(100)));
        GroupByQuery query1 = builder.overrideContext((Map)ImmutableMap.of((Object)"applyLimitPushDown", (Object)"true")).build();
        GroupByQuery query2 = builder.overrideContext((Map)ImmutableMap.of((Object)"applyLimitPushDown", (Object)"false")).build();
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy strategy1 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query1, mapper);
        CacheStrategy strategy2 = new GroupByQueryQueryToolChest(null, null).getCacheStrategy(query2, mapper);
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
        Assert.assertTrue((boolean)Arrays.equals(strategy1.computeResultLevelCacheKey((Query)query1), strategy2.computeResultLevelCacheKey((Query)query2)));
    }

    private static ResultRow makeRow(GroupByQuery query, String timestamp, Object ... vals) {
        return GroupByQueryRunnerTestHelper.createExpectedRow(query, timestamp, vals);
    }

    @Test
    public void testIsQueryCacheableOnGroupByStrategyV2() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.DAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("col", "dim")}).setInterval(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).setAggregatorSpecs(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).build();
        DruidProcessingConfig processingConfig = new DruidProcessingConfig(){

            public String getFormatString() {
                return "processing-%s";
            }
        };
        GroupByQueryConfig queryConfig = new GroupByQueryConfig();
        Supplier queryConfigSupplier = Suppliers.ofInstance((Object)queryConfig);
        Supplier bufferSupplier = () -> ByteBuffer.allocateDirect(processingConfig.intermediateComputeSizeBytes());
        DefaultBlockingPool mergeBufferPool = new DefaultBlockingPool(bufferSupplier, processingConfig.getNumMergeBuffers());
        GroupByStatsProvider groupByStatsProvider = new GroupByStatsProvider();
        GroupByResourcesReservationPool groupByResourcesReservationPool = new GroupByResourcesReservationPool((BlockingPool)mergeBufferPool, queryConfig);
        GroupingEngine groupingEngine = new GroupingEngine(processingConfig, queryConfigSupplier, groupByResourcesReservationPool, TestHelper.makeJsonMapper(), new ObjectMapper((JsonFactory)new SmileFactory()), QueryRunnerTestHelper.NOOP_QUERYWATCHER, groupByStatsProvider);
        GroupByQueryQueryToolChest queryToolChest = new GroupByQueryQueryToolChest(groupingEngine, groupByResourcesReservationPool);
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        CacheStrategy cacheStrategy = queryToolChest.getCacheStrategy(query, mapper);
        Assert.assertTrue((String)"result level cache on broker server for GroupByStrategyV2 should be enabled", (boolean)cacheStrategy.isCacheable((Query)query, false, false));
        Assert.assertFalse((String)"segment level cache on broker server for GroupByStrategyV2 should be disabled", (boolean)cacheStrategy.isCacheable((Query)query, false, true));
        Assert.assertTrue((String)"segment level cache on data server for GroupByStrategyV2 should be enabled", (boolean)cacheStrategy.isCacheable((Query)query, true, true));
    }
}

