/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.expression.TimestampExtractExprMacro;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimestampExtractExprMacroTest {
    private TimestampExtractExprMacro target;

    @Before
    public void setUp() {
        this.target = new TimestampExtractExprMacro();
    }

    @Test
    public void testApplyExtractDecadeShouldExtractTheCorrectDecade() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2001-02-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.DECADE.toString()).toExpr()));
        Assert.assertEquals((long)200L, (long)expression.eval(InputBindings.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractCenturyShouldExtractTheCorrectCentury() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2000-12-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.CENTURY.toString()).toExpr()));
        Assert.assertEquals((long)20L, (long)expression.eval(InputBindings.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractCenturyShouldBeTwentyFirstCenturyIn2001() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2001-02-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.CENTURY.toString()).toExpr()));
        Assert.assertEquals((long)21L, (long)expression.eval(InputBindings.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractMilleniumShouldExtractTheCorrectMillenium() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2000-12-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.MILLENNIUM.toString()).toExpr()));
        Assert.assertEquals((long)2L, (long)expression.eval(InputBindings.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractMilleniumShouldBeThirdMilleniumIn2001() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2001-02-16").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.MILLENNIUM.toString()).toExpr()));
        Assert.assertEquals((long)3L, (long)expression.eval(InputBindings.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractDowWithTimeZoneShouldBeFriday() {
        Expr expression = this.target.apply((List)ImmutableList.of((Object)ExprEval.of((String)"2023-12-15").toExpr(), (Object)ExprEval.of((String)TimestampExtractExprMacro.Unit.DOW.toString()).toExpr(), (Object)ExprEval.of((String)"UTC").toExpr()));
        Assert.assertEquals((long)5L, (long)expression.eval(InputBindings.nilBindings()).asInt());
    }

    @Test
    public void testApplyExtractDowWithDynamicTimeZoneShouldBeFriday() {
        Expr expression = Parser.parse((String)"timestamp_extract(time, 'DOW', timezone)", (ExprMacroTable)TestExprMacroTable.INSTANCE);
        Expr.ObjectBinding bindings = InputBindings.forInputSuppliers((Map)ImmutableMap.of((Object)"time", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "2023-12-15"), (Object)"timezone", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "UTC")));
        Assert.assertEquals((long)5L, (long)expression.eval(bindings).asInt());
    }
}

