/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.JavaScriptPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaScriptPostAggregatorTest {
    private static final String ABS_PERCENT_FUNCTION = "function(delta, total) { return 100 * Math.abs(delta) / total; }";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testCompute() {
        HashMap<String, Double> metricValues = new HashMap<String, Double>();
        metricValues.put("delta", -10.0);
        metricValues.put("total", 100.0);
        JavaScriptPostAggregator javaScriptPostAggregator = new JavaScriptPostAggregator("absPercent", (List)Lists.newArrayList((Object[])new String[]{"delta", "total"}), ABS_PERCENT_FUNCTION, JavaScriptConfig.getEnabledInstance());
        Assert.assertEquals((Object)10.0, (Object)javaScriptPostAggregator.compute(metricValues));
    }

    @Test
    public void testComputeJavaScriptNotAllowed() {
        JavaScriptPostAggregator aggregator = new JavaScriptPostAggregator("absPercent", (List)Lists.newArrayList((Object[])new String[]{"delta", "total"}), ABS_PERCENT_FUNCTION, new JavaScriptConfig(false));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("JavaScript is disabled");
        aggregator.compute(new HashMap());
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("total", "total"), new LongSumAggregatorFactory("delta", "delta")}).postAggregators(new PostAggregator[]{new JavaScriptPostAggregator("a", (List)Lists.newArrayList((Object[])new String[]{"delta", "total"}), ABS_PERCENT_FUNCTION, JavaScriptConfig.getEnabledInstance())}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("total", ColumnType.LONG).add("delta", ColumnType.LONG).add("a", ColumnType.DOUBLE).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

