/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.query.aggregation.any.FloatAnyVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FloatAnyVectorAggregatorTest
extends InitializedNullHandlingTest {
    private static final int NULL_POSITION = 32;
    private static final int POSITION = 2;
    private static final double EPSILON = 1.0E-15;
    private static final float[] VALUES = new float[]{7.8f, 11.0f, 23.67f, 60.0f, 123.0f};
    private ByteBuffer buf;
    @Mock
    private VectorValueSelector selector;
    private FloatAnyVectorAggregator target;

    @Before
    public void setUp() {
        byte[] randomBytes = new byte[128];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.buf = ByteBuffer.wrap(randomBytes);
        ((VectorValueSelector)Mockito.doReturn((Object)VALUES).when((Object)this.selector)).getFloatVector();
        this.target = (FloatAnyVectorAggregator)Mockito.spy((Object)new FloatAnyVectorAggregator(this.selector));
        Mockito.when((Object)this.target.isValueNull(this.buf, 32)).thenReturn((Object)true);
        Mockito.when((Object)this.target.isValueNull(this.buf, 2)).thenReturn((Object)false);
    }

    @Test
    public void initValueShouldInitZero() {
        this.target.initValue(this.buf, 2);
        Assert.assertEquals((double)0.0, (double)this.buf.getFloat(2), (double)1.0E-15);
    }

    @Test
    public void getAtPositionIsNullShouldReturnNull() {
        Assert.assertNull((Object)this.target.get(this.buf, 32));
    }

    @Test
    public void getAtPositionShouldReturnValue() {
        this.buf.putFloat(3, VALUES[3]);
        Assert.assertEquals((double)VALUES[3], (double)((Float)this.target.get(this.buf, 2)).floatValue(), (double)1.0E-15);
    }

    @Test
    public void putValueShouldAddToBuffer() {
        Assert.assertTrue((boolean)this.target.putAnyValueFromRow(this.buf, 2, 2, 3));
        Assert.assertEquals((double)VALUES[2], (double)this.buf.getFloat(2), (double)1.0E-15);
    }

    @Test
    public void putValueStartAfterEndShouldNotAddToBuffer() {
        Assert.assertFalse((boolean)this.target.putAnyValueFromRow(this.buf, 2, 2, 2));
        Assert.assertNotEquals((double)VALUES[2], (double)this.buf.getFloat(2), (double)1.0E-15);
    }

    @Test
    public void putValueStartOutsideRangeShouldNotAddToBuffer() {
        Assert.assertFalse((boolean)this.target.putAnyValueFromRow(this.buf, 2, 5, 6));
        Assert.assertNotEquals((double)VALUES[2], (double)this.buf.getFloat(2), (double)1.0E-15);
    }
}

