/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.query.aggregation.any.DoubleAnyVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DoubleAnyVectorAggregatorTest
extends InitializedNullHandlingTest {
    private static final int NULL_POSITION = 32;
    private static final int POSITION = 2;
    private static final double EPSILON = 1.0E-15;
    private static final double[] VALUES = new double[]{7.8, 11.0, 23.67, 60.0, 123.0};
    private ByteBuffer buf;
    @Mock
    private VectorValueSelector selector;
    private DoubleAnyVectorAggregator target;

    @Before
    public void setUp() {
        byte[] randomBytes = new byte[128];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.buf = ByteBuffer.wrap(randomBytes);
        ((VectorValueSelector)Mockito.doReturn((Object)VALUES).when((Object)this.selector)).getDoubleVector();
        this.target = (DoubleAnyVectorAggregator)Mockito.spy((Object)new DoubleAnyVectorAggregator(this.selector));
        Mockito.when((Object)this.target.isValueNull(this.buf, 32)).thenReturn((Object)true);
        Mockito.when((Object)this.target.isValueNull(this.buf, 2)).thenReturn((Object)false);
    }

    @Test
    public void initValueShouldInitZero() {
        this.target.initValue(this.buf, 2);
        Assert.assertEquals((double)0.0, (double)this.buf.getDouble(2), (double)1.0E-15);
    }

    @Test
    public void getAtPositionIsNullShouldReturnNull() {
        Assert.assertNull((Object)this.target.get(this.buf, 32));
    }

    @Test
    public void getAtPositionShouldReturnValue() {
        this.buf.putDouble(3, VALUES[3]);
        Assert.assertEquals((double)VALUES[3], (double)((Double)this.target.get(this.buf, 2)), (double)1.0E-15);
    }

    @Test
    public void putValueShouldAddToBuffer() {
        Assert.assertTrue((boolean)this.target.putAnyValueFromRow(this.buf, 2, 2, 3));
        Assert.assertEquals((double)VALUES[2], (double)this.buf.getDouble(2), (double)1.0E-15);
    }

    @Test
    public void putValueStartAfterEndShouldNotAddToBuffer() {
        Assert.assertFalse((boolean)this.target.putAnyValueFromRow(this.buf, 2, 2, 2));
        Assert.assertNotEquals((double)VALUES[2], (double)this.buf.getDouble(2), (double)1.0E-15);
    }

    @Test
    public void putValueStartOutsideRangeShouldNotAddToBuffer() {
        Assert.assertFalse((boolean)this.target.putAnyValueFromRow(this.buf, 2, 5, 6));
        Assert.assertNotEquals((double)VALUES[2], (double)this.buf.getDouble(2), (double)1.0E-15);
    }
}

