/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.Random;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongDouble;
import org.apache.druid.query.aggregation.SerializablePairLongDoubleDeltaEncodedStagedSerde;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongDoubleDeltaEncodedStagedSerdeTest {
    private static final SerializablePairLongDoubleDeltaEncodedStagedSerde INTEGER_SERDE = new SerializablePairLongDoubleDeltaEncodedStagedSerde(0L, true);
    private static final SerializablePairLongDoubleDeltaEncodedStagedSerde LONG_SERDE = new SerializablePairLongDoubleDeltaEncodedStagedSerde(0L, false);
    private final Random random = new Random(0L);

    @Test
    public void testNull() {
        SerializablePairLongDoubleDeltaEncodedStagedSerdeTest.assertValueEquals(null, 0, INTEGER_SERDE);
    }

    @Test
    public void testSimpleInteger() {
        SerializablePairLongDoubleDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongDouble(Long.valueOf(100L), Double.valueOf(1.0000000000001232E12)), 13, INTEGER_SERDE);
    }

    @Test
    public void testNullRHSInteger() {
        SerializablePairLongDoubleDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongDouble(Long.valueOf(100L), null), 5, INTEGER_SERDE);
    }

    @Test
    public void testLargeRHSInteger() {
        SerializablePairLongDoubleDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongDouble(Long.valueOf(100L), Double.valueOf(this.random.nextDouble())), 13, INTEGER_SERDE);
    }

    @Test
    public void testSimpleLong() {
        SerializablePairLongDoubleDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongDouble(Long.valueOf(100L), Double.valueOf(1.0000000000001232E12)), 17, LONG_SERDE);
    }

    @Test
    public void testNullRHSLong() {
        SerializablePairLongDoubleDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongDouble(Long.valueOf(100L), null), 9, LONG_SERDE);
    }

    @Test
    public void testLargeRHSLong() {
        SerializablePairLongDoubleDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongDouble(Long.valueOf(100L), Double.valueOf(this.random.nextDouble())), 17, LONG_SERDE);
    }

    private static void assertValueEquals(@Nullable SerializablePairLongDouble value, int size, SerializablePairLongDoubleDeltaEncodedStagedSerde serde) {
        byte[] bytes = serde.serialize((Object)value);
        Assert.assertEquals((long)size, (long)bytes.length);
        SerializablePairLongDouble deserialized = (SerializablePairLongDouble)serde.deserialize(bytes);
        Assert.assertEquals((Object)value, (Object)deserialized);
    }
}

