/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.Comparator;
import org.apache.druid.query.aggregation.LongSumAggregator;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.junit.Assert;
import org.junit.Test;

public class LongSumAggregatorTest {
    private void aggregate(TestLongColumnSelector selector, LongSumAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testAggregate() {
        TestLongColumnSelector selector = new TestLongColumnSelector(new long[]{24L, 20L});
        LongSumAggregator agg = new LongSumAggregator((BaseLongColumnValueSelector)selector);
        Assert.assertEquals((Object)0L, (Object)agg.get());
        Assert.assertEquals((Object)0L, (Object)agg.get());
        Assert.assertEquals((Object)0L, (Object)agg.get());
        this.aggregate(selector, agg);
        Assert.assertEquals((Object)24L, (Object)agg.get());
        Assert.assertEquals((Object)24L, (Object)agg.get());
        Assert.assertEquals((Object)24L, (Object)agg.get());
        this.aggregate(selector, agg);
        Assert.assertEquals((Object)44L, (Object)agg.get());
        Assert.assertEquals((Object)44L, (Object)agg.get());
        Assert.assertEquals((Object)44L, (Object)agg.get());
    }

    @Test
    public void testComparator() {
        TestLongColumnSelector selector = new TestLongColumnSelector(new long[]{18293L});
        LongSumAggregator agg = new LongSumAggregator((BaseLongColumnValueSelector)selector);
        Object first = agg.get();
        agg.aggregate();
        Comparator comp = new LongSumAggregatorFactory("null", "null").getComparator();
        Assert.assertEquals((long)-1L, (long)comp.compare(first, agg.get()));
        Assert.assertEquals((long)0L, (long)comp.compare(first, first));
        Assert.assertEquals((long)0L, (long)comp.compare(agg.get(), agg.get()));
        Assert.assertEquals((long)1L, (long)comp.compare(agg.get(), first));
    }
}

