/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregator;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.TestNullableFloatColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class FilteredAggregatorTest
extends InitializedNullHandlingTest {
    @Test
    public void testAggregate() {
        Float[] values = new Float[]{Float.valueOf(0.15f), Float.valueOf(0.27f)};
        TestNullableFloatColumnSelector selector = new TestNullableFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new FloatSumAggregatorFactory("billy", "value"), (DimFilter)new SelectorDimFilter("dim", "a", null));
        Float[] expectedVals = new Float[]{values[0], Float.valueOf(values[0].floatValue() + values[1].floatValue())};
        this.validateFilteredAggs(factory, selector, expectedVals);
    }

    @Test
    public void testAggregateWithNullVals() {
        Float[] values = new Float[]{Float.valueOf(0.15f), null, Float.valueOf(0.27f)};
        TestNullableFloatColumnSelector selector = new TestNullableFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new FloatSumAggregatorFactory("billy", "value"), (DimFilter)new SelectorDimFilter("dim", "a", null));
        Float[] expectedValues = new Float[]{values[0], values[0], Float.valueOf(values[0].floatValue() + values[2].floatValue())};
        this.validateFilteredAggs(factory, selector, expectedValues);
    }

    @Test
    public void testAggregateOnlyWithNulls() {
        Float[] values = new Float[]{null, null};
        TestNullableFloatColumnSelector selector = new TestNullableFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new FloatSumAggregatorFactory("billy", "value"), (DimFilter)new SelectorDimFilter("dim", "a", null));
        Float[] expectedValues = new Float[]{null, null};
        this.validateFilteredAggs(factory, selector, expectedValues);
    }

    @Test
    public void testAggregateWithNotFilter() {
        Float[] values = new Float[]{Float.valueOf(0.15f), Float.valueOf(0.27f)};
        TestNullableFloatColumnSelector selector = new TestNullableFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("dim", "b", null)));
        Float[] expectedValues = new Float[]{values[0], Float.valueOf(values[0].floatValue() + values[1].floatValue())};
        this.validateFilteredAggs(factory, selector, expectedValues);
    }

    @Test
    public void testAggregateWithOrFilter() {
        Float[] values = new Float[]{Float.valueOf(0.15f), Float.valueOf(0.27f), Float.valueOf(0.14f)};
        TestNullableFloatColumnSelector selector = new TestNullableFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new OrDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("dim", "a", null), new SelectorDimFilter("dim", "b", null)})));
        Float[] expectedValues = new Float[]{values[0], Float.valueOf(values[0].floatValue() + values[1].floatValue()), Float.valueOf(values[0].floatValue() + values[1].floatValue() + values[2].floatValue())};
        this.validateFilteredAggs(factory, selector, expectedValues);
    }

    @Test
    public void testAggregateWithAndFilter() {
        Float[] values = new Float[]{Float.valueOf(0.15f), Float.valueOf(0.27f)};
        TestNullableFloatColumnSelector selector = new TestNullableFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new AndDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new NotDimFilter((DimFilter)new SelectorDimFilter("dim", "b", null)), new SelectorDimFilter("dim", "a", null)})));
        Float[] expectedValues = new Float[]{values[0], Float.valueOf(values[0].floatValue() + values[1].floatValue())};
        this.validateFilteredAggs(factory, selector, expectedValues);
    }

    @Test
    public void testAggregateWithPredicateFilters2() {
        Float[] values = new Float[]{Float.valueOf(0.15f), Float.valueOf(0.27f), null};
        Float[] expectedValues = new Float[]{values[0], Float.valueOf(values[0].floatValue() + values[1].floatValue()), Float.valueOf(values[0].floatValue() + values[1].floatValue())};
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new BoundDimFilter("dim", "a", "a", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC));
        TestNullableFloatColumnSelector selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new RegexDimFilter("dim", "a", null));
        selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SearchQueryDimFilter("dim", (SearchQuerySpec)new ContainsSearchQuerySpec("a", true), null));
        selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
        String jsFn = "function(x) { return(x === 'a') }";
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new JavaScriptDimFilter("dim", jsFn, null, JavaScriptConfig.getEnabledInstance()));
        selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
    }

    @Test
    public void testAggregateWithExtractionFns() {
        Float[] values = new Float[]{Float.valueOf(0.15f), null, Float.valueOf(0.27f), null, Float.valueOf(0.13f)};
        Float[] expectedValues = new Float[]{values[0], values[0], Float.valueOf(values[0].floatValue() + values[2].floatValue()), Float.valueOf(values[0].floatValue() + values[2].floatValue()), Float.valueOf(values[0].floatValue() + values[2].floatValue() + values[4].floatValue())};
        String extractionJsFn = "function(str) { return str + 'AARDVARK'; }";
        JavaScriptExtractionFn extractionFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SelectorDimFilter("dim", "aAARDVARK", (ExtractionFn)extractionFn));
        TestNullableFloatColumnSelector selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new InDimFilter("dim", Arrays.asList("NOT-aAARDVARK", "FOOBAR", "aAARDVARK"), (ExtractionFn)extractionFn));
        selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new BoundDimFilter("dim", "aAARDVARK", "aAARDVARK", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), (ExtractionFn)extractionFn, StringComparators.ALPHANUMERIC));
        selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new RegexDimFilter("dim", "aAARDVARK", (ExtractionFn)extractionFn));
        selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SearchQueryDimFilter("dim", (SearchQuerySpec)new ContainsSearchQuerySpec("aAARDVARK", true), (ExtractionFn)extractionFn));
        selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
        String jsFn = "function(x) { return(x === 'aAARDVARK') }";
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new JavaScriptDimFilter("dim", jsFn, (ExtractionFn)extractionFn, JavaScriptConfig.getEnabledInstance()));
        selector = new TestNullableFloatColumnSelector(values);
        this.validateFilteredAggs(factory, selector, expectedValues);
    }

    private ColumnSelectorFactory makeColumnSelector(final TestNullableFloatColumnSelector selector) {
        return new ColumnSelectorFactory(){

            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                String dimensionName = dimensionSpec.getDimension();
                if ("dim".equals(dimensionName)) {
                    return dimensionSpec.decorate((DimensionSelector)new AbstractDimensionSelector(){

                        public IndexedInts getRow() {
                            SingleIndexedInt row = new SingleIndexedInt();
                            row.setValue(0);
                            return row;
                        }

                        public ValueMatcher makeValueMatcher(String value) {
                            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (String)value);
                        }

                        public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (DruidPredicateFactory)predicateFactory);
                        }

                        public int getValueCardinality() {
                            return 2;
                        }

                        public String lookupName(int id) {
                            switch (id) {
                                case 0: {
                                    return "a";
                                }
                                case 1: {
                                    return "b";
                                }
                            }
                            throw new IllegalArgumentException();
                        }

                        public boolean nameLookupPossibleInAdvance() {
                            return true;
                        }

                        @Nullable
                        public IdLookup idLookup() {
                            return new IdLookup(){

                                public int lookupId(String name) {
                                    switch (name) {
                                        case "a": {
                                            return 0;
                                        }
                                        case "b": {
                                            return 1;
                                        }
                                    }
                                    throw new IllegalArgumentException();
                                }
                            };
                        }

                        public Class classOfObject() {
                            return Object.class;
                        }

                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        }
                    });
                }
                throw new UnsupportedOperationException();
            }

            public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
                if ("value".equals(columnName)) {
                    return selector;
                }
                throw new UnsupportedOperationException();
            }

            public ColumnCapabilities getColumnCapabilities(String columnName) {
                ColumnCapabilitiesImpl caps;
                if ("value".equals(columnName)) {
                    caps = new ColumnCapabilitiesImpl();
                    caps.setType(ColumnType.FLOAT);
                    caps.setDictionaryEncoded(false);
                    caps.setHasBitmapIndexes(false);
                } else {
                    caps = new ColumnCapabilitiesImpl();
                    caps.setType(ColumnType.STRING);
                    caps.setDictionaryEncoded(true);
                    caps.setHasBitmapIndexes(true);
                }
                return caps;
            }
        };
    }

    private void aggregate(TestNullableFloatColumnSelector selector, FilteredAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void validateFilteredAggs(FilteredAggregatorFactory factory, TestNullableFloatColumnSelector selector, Float[] expectedValues) {
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        Assert.assertTrue((boolean)agg.isNull());
        Assert.assertNull((Object)agg.get());
        for (Float expectedValue : expectedValues) {
            this.aggregate(selector, agg);
            if (expectedValue == null) {
                Assert.assertTrue((boolean)agg.isNull());
                Assert.assertNull((Object)agg.get());
                continue;
            }
            Assert.assertFalse((boolean)agg.isNull());
            Assert.assertEquals((double)expectedValue.floatValue(), (double)agg.getFloat(), (double)0.001);
        }
    }
}

