/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.ArrayList;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.allocation.SingleMemoryAllocatorFactory;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class FrameBasedInlineDataSourceSerializerTest {
    private static final Interval INTERVAL = Intervals.of((String)"2000/P1Y");
    private static final RowSignature FOO_INLINE_SIGNATURE = RowSignature.builder().addTimeColumn().add("s", ColumnType.STRING).add("n", ColumnType.LONG).build();
    private static final InlineDataSource FOO_INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.builder().add((Object)new Object[]{INTERVAL.getStartMillis(), "x", 1}).add((Object)new Object[]{INTERVAL.getStartMillis(), "x", 2}).add((Object)new Object[]{INTERVAL.getStartMillis(), "y", 3}).add((Object)new Object[]{INTERVAL.getStartMillis(), "z", 4}).build(), (RowSignature)FOO_INLINE_SIGNATURE);
    private static final RowSignature BAR_INLINE_SIGNATURE = RowSignature.builder().addTimeColumn().add("s", ColumnType.STRING).add("n", ColumnType.LONG).build();
    private static final InlineDataSource BAR_INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.builder().add((Object)new Object[]{INTERVAL.getStartMillis(), "a", 1}).add((Object)new Object[]{INTERVAL.getStartMillis(), "a", 2}).add((Object)new Object[]{INTERVAL.getStartMillis(), "b", 3}).add((Object)new Object[]{INTERVAL.getStartMillis(), "c", 4}).build(), (RowSignature)BAR_INLINE_SIGNATURE);
    private static final RowSignature MULTI_VALUE_INLINE_SIGNATURE = RowSignature.builder().addTimeColumn().add("s", ColumnType.STRING_ARRAY).add("n", ColumnType.LONG).build();
    private static final InlineDataSource MULTI_VALUE_INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.builder().add((Object)new Object[]{INTERVAL.getStartMillis(), ImmutableList.of((Object)"a", (Object)"b"), 1}).add((Object)new Object[]{INTERVAL.getStartMillis(), ImmutableList.of((Object)"a", (Object)"c"), 2}).add((Object)new Object[]{INTERVAL.getStartMillis(), ImmutableList.of((Object)"b"), 3}).add((Object)new Object[]{INTERVAL.getStartMillis(), ImmutableList.of((Object)"c"), 4}).build(), (RowSignature)MULTI_VALUE_INLINE_SIGNATURE);
    ObjectMapper objectMapper = new DefaultObjectMapper();

    @Test
    public void serialize() throws JsonProcessingException {
        this.assertConversionBetweenFrameBasedAndIterableBasedInlineDataSource(this.convertToFrameBasedInlineDataSource(FOO_INLINE, FOO_INLINE_SIGNATURE), FOO_INLINE);
        this.assertConversionBetweenFrameBasedAndIterableBasedInlineDataSource(this.convertToFrameBasedInlineDataSource(BAR_INLINE, BAR_INLINE_SIGNATURE), BAR_INLINE);
        this.assertConversionBetweenFrameBasedAndIterableBasedInlineDataSource(this.convertToFrameBasedInlineDataSource(MULTI_VALUE_INLINE, MULTI_VALUE_INLINE_SIGNATURE), MULTI_VALUE_INLINE);
    }

    private FrameBasedInlineDataSource convertToFrameBasedInlineDataSource(InlineDataSource inlineDataSource, RowSignature rowSignature) {
        Pair cursorAndCloseable = IterableRowsCursorHelper.getCursorFromIterable((Iterable)inlineDataSource.getRows(), (RowSignature)rowSignature);
        Cursor cursor = (Cursor)cursorAndCloseable.lhs;
        RowSignature modifiedRowSignature = FrameWriterUtils.replaceUnknownTypesWithNestedColumns((RowSignature)rowSignature);
        Sequence frames = FrameCursorUtils.cursorToFramesSequence((Cursor)cursor, (FrameWriterFactory)FrameWriters.makeFrameWriterFactory((FrameType)FrameType.latestColumnar(), (MemoryAllocatorFactory)new SingleMemoryAllocatorFactory((MemoryAllocator)HeapMemoryAllocator.unlimited()), (RowSignature)modifiedRowSignature, new ArrayList(), (boolean)false));
        return new FrameBasedInlineDataSource(frames.map(frame -> new FrameSignaturePair(frame, rowSignature)).withBaggage((Closeable)cursorAndCloseable.rhs).toList(), modifiedRowSignature);
    }

    private void assertConversionBetweenFrameBasedAndIterableBasedInlineDataSource(FrameBasedInlineDataSource frameBasedInlineDataSource, InlineDataSource inlineDataSource) throws JsonProcessingException {
        String s = this.objectMapper.writeValueAsString((Object)frameBasedInlineDataSource);
        DataSource back = (DataSource)this.objectMapper.readValue(s, DataSource.class);
        Assert.assertEquals((Object)inlineDataSource, (Object)back);
    }
}

