/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import java.util.Properties;
import org.apache.druid.error.ExceptionMatcher;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.utils.RuntimeInfo;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DruidProcessingConfigTest {
    private static final long BUFFER_SIZE = 0x40000000L;
    private static final int NUM_PROCESSORS = 4;
    private static final long DIRECT_SIZE = 0x180000000L;
    private static final long HEAP_SIZE = 0x80000000L;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testDefaultsMultiProcessor() {
        Injector injector = DruidProcessingConfigTest.makeInjector(4, 0x180000000L, 0x80000000L);
        DruidProcessingConfig config = (DruidProcessingConfig)injector.getInstance(DruidProcessingConfig.class);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)config.poolCacheMaxCount());
        Assert.assertEquals((long)3L, (long)config.getNumThreads());
        Assert.assertEquals((long)Math.max(2, config.getNumThreads() / 4), (long)config.getNumMergeBuffers());
        Assert.assertTrue((boolean)config.isFifo());
        Assert.assertEquals((Object)System.getProperty("java.io.tmpdir"), (Object)config.getTmpDir());
        Assert.assertEquals((long)0x40000000L, (long)config.intermediateComputeSizeBytes());
    }

    @Test
    public void testDefaultsSingleProcessor() {
        Injector injector = DruidProcessingConfigTest.makeInjector(1, 0x100000000L, 0x80000000L);
        DruidProcessingConfig config = (DruidProcessingConfig)injector.getInstance(DruidProcessingConfig.class);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)config.poolCacheMaxCount());
        Assert.assertTrue((config.getNumThreads() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)Math.max(2, config.getNumThreads() / 4), (long)config.getNumMergeBuffers());
        Assert.assertTrue((boolean)config.isFifo());
        Assert.assertEquals((Object)System.getProperty("java.io.tmpdir"), (Object)config.getTmpDir());
        Assert.assertEquals((long)0x40000000L, (long)config.intermediateComputeSizeBytes());
    }

    @Test
    public void testDefaultsLargeDirect() {
        Injector injector = DruidProcessingConfigTest.makeInjector(1, 0x1900000000L, 0x80000000L);
        DruidProcessingConfig config = (DruidProcessingConfig)injector.getInstance(DruidProcessingConfig.class);
        Assert.assertEquals((long)0x40000000L, (long)config.intermediateComputeSizeBytes());
    }

    @Test
    public void testReplacements() {
        Properties props = new Properties();
        props.setProperty("druid.processing.buffer.sizeBytes", "1");
        props.setProperty("druid.processing.buffer.poolCacheMaxCount", "1");
        props.setProperty("druid.processing.numThreads", "256");
        props.setProperty("druid.processing.fifo", "false");
        props.setProperty("druid.processing.tmpDir", "/test/path");
        Injector injector = DruidProcessingConfigTest.makeInjector(4, 0x180000000L, 0x80000000L, props);
        DruidProcessingConfig config = (DruidProcessingConfig)injector.getInstance(DruidProcessingConfig.class);
        Assert.assertEquals((long)1L, (long)config.intermediateComputeSizeBytes());
        Assert.assertEquals((long)1L, (long)config.poolCacheMaxCount());
        Assert.assertEquals((long)256L, (long)config.getNumThreads());
        Assert.assertEquals((long)64L, (long)config.getNumMergeBuffers());
        Assert.assertFalse((boolean)config.isFifo());
        Assert.assertEquals((Object)"/test/path", (Object)config.getTmpDir());
        Assert.assertEquals((long)0L, (long)config.getNumInitalBuffersForIntermediatePool());
    }

    @Test
    public void testInvalidSizeBytes() {
        Properties props = new Properties();
        props.setProperty("druid.processing.buffer.sizeBytes", "-1");
        Injector injector = DruidProcessingConfigTest.makeInjector(4, 0x180000000L, 0x80000000L, props);
        ExceptionMatcher.of(ProvisionException.class).expectMessageContains("Cannot construct instance of `HumanReadableBytes`, problem: Invalid format of number: -1. Negative value is not allowed.").assertThrowsAndMatches(() -> injector.getInstance(DruidProcessingConfig.class));
    }

    @Test
    public void testSizeBytesUpperLimit() {
        Properties props = new Properties();
        props.setProperty("druid.processing.buffer.sizeBytes", "2GiB");
        Injector injector = DruidProcessingConfigTest.makeInjector(4, 0x180000000L, 0x80000000L, props);
        Throwable t = Assert.assertThrows(ProvisionException.class, () -> injector.getInstance(DruidProcessingConfig.class));
        Assert.assertTrue((boolean)t.getMessage().contains("druid.processing.buffer.sizeBytes must be less than 2GiB"));
    }

    private static Injector makeInjector(int numProcessors, long directMemorySize, long heapSize) {
        return DruidProcessingConfigTest.makeInjector(numProcessors, directMemorySize, heapSize, new Properties());
    }

    private static Injector makeInjector(int numProcessors, long directMemorySize, long heapSize, Properties props) {
        Injector startupInjector = new StartupInjectorBuilder().withProperties(props).build();
        return Guice.createInjector((Module[])new Module[]{(Module)startupInjector.getInstance(DruidSecondaryModule.class), binder -> {
            binder.bind(RuntimeInfo.class).toInstance((Object)new MockRuntimeInfo(numProcessors, directMemorySize, heapSize));
            JsonConfigProvider.bind((Binder)binder, (String)"druid.processing", DruidProcessingConfig.class);
        }});
    }

    public static class MockRuntimeInfo
    extends RuntimeInfo {
        private final int availableProcessors;
        private final long maxHeapSize;
        private final long directSize;

        public MockRuntimeInfo(int availableProcessors, long directSize, long maxHeapSize) {
            this.availableProcessors = availableProcessors;
            this.directSize = directSize;
            this.maxHeapSize = maxHeapSize;
        }

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }

        public long getTotalHeapSizeBytes() {
            return this.maxHeapSize;
        }

        public long getMaxHeapSizeBytes() {
            return this.maxHeapSize;
        }

        public long getDirectMemorySizeBytes() {
            return this.directSize;
        }
    }
}

