/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.DefaultQueryMetrics;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.joda.time.base.AbstractInterval;
import org.junit.Assert;
import org.junit.Test;

public class DefaultQueryMetricsTest
extends InitializedNullHandlingTest {
    @Test
    public void testDefaultQueryMetricsQuery() {
        StubServiceEmitter serviceEmitter = new StubServiceEmitter("", "");
        DefaultQueryMetrics queryMetrics = new DefaultQueryMetrics();
        TopNQuery query = new TopNQueryBuilder().dataSource("xx").granularity(Granularities.ALL).dimension((DimensionSpec)new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("tags", "tags"), (Set)ImmutableSet.of((Object)"t3"), null)).metric("count").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).threshold(5).filters((DimFilter)new SelectorDimFilter("tags", "t3", null)).context((Map)ImmutableMap.of((Object)"testKey", (Object)"testValue")).build();
        queryMetrics.query((Query)query);
        queryMetrics.reportQueryTime(0L).emit((ServiceEmitter)serviceEmitter);
        queryMetrics.sqlQueryId("dummy");
        queryMetrics.queryId("dummy");
        EventMap actualEvent = serviceEmitter.getEvents().get(0).toMap();
        Assert.assertEquals((long)13L, (long)actualEvent.size());
        Assert.assertTrue((boolean)actualEvent.containsKey("feed"));
        Assert.assertTrue((boolean)actualEvent.containsKey("timestamp"));
        Assert.assertEquals((Object)"", actualEvent.get("host"));
        Assert.assertEquals((Object)"", actualEvent.get("service"));
        Assert.assertEquals((Object)"xx", actualEvent.get("dataSource"));
        Assert.assertEquals((Object)query.getType(), actualEvent.get("type"));
        List expectedIntervals = QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC.getIntervals();
        List expectedStringIntervals = expectedIntervals.stream().map(AbstractInterval::toString).collect(Collectors.toList());
        Assert.assertEquals(expectedStringIntervals, actualEvent.get("interval"));
        Assert.assertEquals((Object)"true", actualEvent.get("hasFilters"));
        Assert.assertEquals((Object)((Interval)expectedIntervals.get(0)).toDuration().toString(), actualEvent.get("duration"));
        Assert.assertEquals((Object)"dummy", actualEvent.get("id"));
        Assert.assertEquals((Object)"query/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)0L, actualEvent.get("value"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"testKey", (Object)"testValue"), actualEvent.get("context"));
    }

    @Test
    public void testDefaultQueryMetricsMetricNamesAndUnits() {
        DefaultQueryMetrics queryMetrics = new DefaultQueryMetrics();
        DefaultQueryMetricsTest.testQueryMetricsDefaultMetricNamesAndUnits(queryMetrics);
    }

    public static void testQueryMetricsDefaultMetricNamesAndUnits(QueryMetrics<? extends Query<?>> queryMetrics) {
        StubServiceEmitter serviceEmitter = new StubServiceEmitter();
        queryMetrics.reportQueryTime(1000001L).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/time", 1L);
        queryMetrics.reportWaitTime(2000001L).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/wait/time", 2L);
        queryMetrics.reportSegmentTime(3000001L).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/segment/time", 3L);
        queryMetrics.reportSegmentAndCacheTime(4000001L).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/segmentAndCache/time", 4L);
        queryMetrics.reportCpuTime(6000001L).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/cpu/time", 6000L);
        queryMetrics.reportNodeTimeToFirstByte(7000001L).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/node/ttfb", 7L);
        queryMetrics.reportNodeTime(8000001L).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/node/time", 8L);
        queryMetrics.reportQueryBytes(9L).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/bytes", 9L);
        queryMetrics.reportNodeBytes(10L).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/node/bytes", 10L);
        queryMetrics.reportResultCachePoll(true).emit((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("query/resultCache/hit", 1);
        queryMetrics.reportQueriedSegmentCount(25L).emit((ServiceEmitter)serviceEmitter);
        Assert.assertEquals((long)10L, (long)serviceEmitter.getEvents().size());
    }

    @Test
    public void testVectorizedDimensionInMetrics() {
        StubServiceEmitter serviceEmitter = new StubServiceEmitter("", "");
        DefaultQueryMetrics queryMetrics = new DefaultQueryMetrics();
        queryMetrics.vectorized(true);
        queryMetrics.reportSegmentTime(0L).emit((ServiceEmitter)serviceEmitter);
        EventMap actualEvent = serviceEmitter.getEvents().get(0).toMap();
        Assert.assertEquals((long)7L, (long)actualEvent.size());
        Assert.assertTrue((boolean)actualEvent.containsKey("feed"));
        Assert.assertTrue((boolean)actualEvent.containsKey("timestamp"));
        Assert.assertEquals((Object)"", actualEvent.get("host"));
        Assert.assertEquals((Object)"", actualEvent.get("service"));
        Assert.assertEquals((Object)"query/segment/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)0L, actualEvent.get("value"));
        Assert.assertEquals((Object)true, actualEvent.get("vectorized"));
    }
}

