/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.Properties;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.query.DefaultQueryConfig;
import org.junit.Assert;
import org.junit.Test;

public class DefaultQueryConfigTest {
    @Test
    public void testSerdeContextMap() {
        Injector injector = this.createInjector();
        String propertyPrefix = "druid.query.default";
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.query.default", DefaultQueryConfig.class);
        Properties properties = new Properties();
        properties.put("druid.query.default.context.joinFilterRewriteMaxSize", "10");
        properties.put("druid.query.default.context.vectorize", "true");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        DefaultQueryConfig defaultQueryConfig = (DefaultQueryConfig)provider.get();
        Assert.assertNotNull((Object)defaultQueryConfig.getContext());
        Assert.assertEquals((long)2L, (long)defaultQueryConfig.getContext().size());
        Assert.assertEquals((Object)"10", defaultQueryConfig.getContext().get("joinFilterRewriteMaxSize"));
        Assert.assertEquals((Object)"true", defaultQueryConfig.getContext().get("vectorize"));
    }

    @Test
    public void testSerdeEmptyContextMap() {
        Injector injector = this.createInjector();
        String propertyPrefix = "druid.query.default";
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.query.default", DefaultQueryConfig.class);
        Properties properties = new Properties();
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        DefaultQueryConfig defaultQueryConfig = (DefaultQueryConfig)provider.get();
        Assert.assertNotNull((Object)defaultQueryConfig.getContext());
        Assert.assertEquals((long)0L, (long)defaultQueryConfig.getContext().size());
    }

    private Injector createInjector() {
        Injector injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> JsonConfigProvider.bind((Binder)binder, (String)"druid.query.default", DefaultQueryConfig.class, Global.class)));
        return injector;
    }
}

