/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.CursorGranularizer;
import org.apache.druid.query.Order;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexTimeBoundaryInspector;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CursorGranularizerTest
extends InitializedNullHandlingTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private CursorFactory cursorFactory;
    private TimeBoundaryInspector timeBoundaryInspector;
    private Interval interval;

    @Before
    public void setup() throws IOException {
        RowSignature signature = RowSignature.builder().add("x", ColumnType.STRING).add("y", ColumnType.STRING).build();
        ImmutableList dims = ImmutableList.of((Object)"x", (Object)"y");
        IncrementalIndexSchema schema = IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().useSchemaDiscovery(true).build()).withQueryGranularity(Granularities.MINUTE).build();
        IndexBuilder bob = IndexBuilder.create().schema(schema).rows((Iterable<InputRow>)ImmutableList.of((Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T00:00Z"), (List)dims, (List)ImmutableList.of((Object)"a", (Object)"1")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T00:01Z"), (List)dims, (List)ImmutableList.of((Object)"b", (Object)"2")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T00:02Z"), (List)dims, (List)ImmutableList.of((Object)"c", (Object)"1")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T00:03Z"), (List)dims, (List)ImmutableList.of((Object)"d", (Object)"2")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T01:00Z"), (List)dims, (List)ImmutableList.of((Object)"e", (Object)"1")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T01:01Z"), (List)dims, (List)ImmutableList.of((Object)"f", (Object)"2")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T03:04Z"), (List)dims, (List)ImmutableList.of((Object)"g", (Object)"1")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T03:05Z"), (List)dims, (List)ImmutableList.of((Object)"h", (Object)"2")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T03:15Z"), (List)dims, (List)ImmutableList.of((Object)"i", (Object)"1")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T05:03Z"), (List)dims, (List)ImmutableList.of((Object)"j", (Object)"2")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T06:00Z"), (List)dims, (List)ImmutableList.of((Object)"k", (Object)"1")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2024-01-01T09:01Z"), (List)dims, (List)ImmutableList.of((Object)"l", (Object)"2")), (Object[])new InputRow[0])).tmpDir(this.temporaryFolder.newFolder());
        QueryableIndex index = bob.buildMMappedIndex(Intervals.of((String)"2024-01-01T00:00Z/2024-01-02T00:00Z"));
        this.interval = index.getDataInterval();
        this.cursorFactory = new QueryableIndexCursorFactory(index);
        this.timeBoundaryInspector = QueryableIndexTimeBoundaryInspector.create((QueryableIndex)index);
    }

    @Test
    public void testGranularizeFullScan() {
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            CursorGranularizer granularizer = CursorGranularizer.create((Cursor)cursor, (TimeBoundaryInspector)this.timeBoundaryInspector, (Order)Order.ASCENDING, (Granularity)Granularities.HOUR, (Interval)this.interval);
            ColumnSelectorFactory selectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector xSelector = selectorFactory.makeColumnValueSelector("x");
            Sequence theSequence = Sequences.simple((Iterable)granularizer.getBucketIterable()).map(bucketInterval -> {
                ArrayList<String> bucket = new ArrayList<String>();
                if (!granularizer.advanceToBucket(bucketInterval)) {
                    return bucket;
                }
                while (!cursor.isDone()) {
                    bucket.add((String)xSelector.getObject());
                    if (granularizer.advanceCursorWithinBucket()) continue;
                    break;
                }
                return bucket;
            });
            List granularized = theSequence.toList();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"g", (Object)"h", (Object)"i"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"j"), (Object)ImmutableList.of((Object)"k"), (Object)ImmutableList.of(), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"l")), (Object)granularized);
        }
    }

    @Test
    public void testGranularizeFullScanDescending() {
        CursorBuildSpec descending = CursorBuildSpec.builder().setPreferredOrdering(Cursors.descendingTimeOrder()).build();
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(descending);){
            Cursor cursor = cursorHolder.asCursor();
            CursorGranularizer granularizer = CursorGranularizer.create((Cursor)cursor, (TimeBoundaryInspector)this.timeBoundaryInspector, (Order)Order.DESCENDING, (Granularity)Granularities.HOUR, (Interval)this.interval);
            ColumnSelectorFactory selectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector xSelector = selectorFactory.makeColumnValueSelector("x");
            Sequence theSequence = Sequences.simple((Iterable)granularizer.getBucketIterable()).map(bucketInterval -> {
                ArrayList<String> bucket = new ArrayList<String>();
                if (!granularizer.advanceToBucket(bucketInterval)) {
                    return bucket;
                }
                while (!cursor.isDone()) {
                    bucket.add((String)xSelector.getObject());
                    if (granularizer.advanceCursorWithinBucket()) continue;
                    break;
                }
                return bucket;
            });
            List granularized = theSequence.toList();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"l"), (Object)ImmutableList.of(), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"k"), (Object)ImmutableList.of((Object)"j"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"i", (Object)"h", (Object)"g"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"f", (Object)"e"), (Object)ImmutableList.of((Object)"d", (Object)"c", (Object)"b", (Object)"a")), (Object)granularized);
        }
    }

    @Test
    public void testGranularizeFiltered() {
        CursorBuildSpec filtered = CursorBuildSpec.builder().setFilter((Filter)new EqualityFilter("y", ColumnType.STRING, (Object)"1", null)).build();
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(filtered);){
            Cursor cursor = cursorHolder.asCursor();
            CursorGranularizer granularizer = CursorGranularizer.create((Cursor)cursor, (TimeBoundaryInspector)this.timeBoundaryInspector, (Order)Order.ASCENDING, (Granularity)Granularities.HOUR, (Interval)this.interval);
            ColumnSelectorFactory selectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector xSelector = selectorFactory.makeColumnValueSelector("x");
            Sequence theSequence = Sequences.simple((Iterable)granularizer.getBucketIterable()).map(bucketInterval -> {
                ArrayList<String> bucket = new ArrayList<String>();
                if (!granularizer.advanceToBucket(bucketInterval)) {
                    return bucket;
                }
                while (!cursor.isDone()) {
                    bucket.add((String)xSelector.getObject());
                    if (granularizer.advanceCursorWithinBucket()) continue;
                    break;
                }
                return bucket;
            });
            List granularized = theSequence.toList();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"c"), (Object)ImmutableList.of((Object)"e"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"g", (Object)"i"), (Object)ImmutableList.of(), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"k"), (Object)ImmutableList.of(), (Object)ImmutableList.of(), (Object)ImmutableList.of()), (Object)granularized);
        }
    }

    @Test
    public void testGranularizeFilteredClippedAndPartialOverlap() {
        CursorBuildSpec filtered = CursorBuildSpec.builder().setFilter((Filter)new EqualityFilter("y", ColumnType.STRING, (Object)"1", null)).build();
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(filtered);){
            Cursor cursor = cursorHolder.asCursor();
            CursorGranularizer granularizer = CursorGranularizer.create((Cursor)cursor, (TimeBoundaryInspector)this.timeBoundaryInspector, (Order)Order.ASCENDING, (Granularity)Granularities.HOUR, (Interval)Intervals.of((String)"2024-01-01T08:00Z/2024-01-03T00:00Z"));
            ColumnSelectorFactory selectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector xSelector = selectorFactory.makeColumnValueSelector("x");
            Sequence theSequence = Sequences.simple((Iterable)granularizer.getBucketIterable()).map(bucketInterval -> {
                ArrayList<String> bucket = new ArrayList<String>();
                if (!granularizer.advanceToBucket(bucketInterval)) {
                    return bucket;
                }
                while (!cursor.isDone()) {
                    bucket.add((String)xSelector.getObject());
                    if (granularizer.advanceCursorWithinBucket()) continue;
                    break;
                }
                return bucket;
            });
            List granularized = theSequence.toList();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of()), (Object)granularized);
        }
    }
}

