/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.SettableVectorInputBinding;
import org.apache.druid.math.expr.vector.FilteredVectorInputBinding;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilteredVectorInputBindingTest
extends InitializedNullHandlingTest {
    private static final int VECTOR_SIZE = 8;
    private static final Object[] STRINGS = new Object[]{"0", "1", "2", "3", "4", "5", "6", "7"};
    private static final long[] LONGS = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L};
    private static final double[] DOUBLES = new double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7};
    private static final boolean[] NULLS = new boolean[]{false, false, false, true, false, false, true, false};
    private SettableVectorInputBinding baseBinding;

    @Before
    public void setup() {
        this.baseBinding = new SettableVectorInputBinding(8);
        this.baseBinding.addString("string", STRINGS);
        this.baseBinding.addLong("long", LONGS, NULLS);
        this.baseBinding.addDouble("double", DOUBLES);
    }

    @Test
    public void testFilterString() {
        FilteredVectorInputBinding filteredVectorInputBinding = new FilteredVectorInputBinding(8);
        filteredVectorInputBinding.setBindings((Expr.VectorInputBinding)this.baseBinding);
        VectorMatch matchMaker = filteredVectorInputBinding.getVectorMatch();
        int[] selection = matchMaker.getSelection();
        selection[0] = 1;
        selection[1] = 3;
        selection[2] = 4;
        matchMaker.setSelectionSize(3);
        Object[] strings = filteredVectorInputBinding.getObjectVector("string");
        Assert.assertEquals((long)3L, (long)filteredVectorInputBinding.getCurrentVectorSize());
        Assert.assertEquals((Object)"1", (Object)strings[0]);
        Assert.assertEquals((Object)"3", (Object)strings[1]);
        Assert.assertEquals((Object)"4", (Object)strings[2]);
    }

    @Test
    public void testFilterLongWithNull() {
        FilteredVectorInputBinding filteredVectorInputBinding = new FilteredVectorInputBinding(8);
        filteredVectorInputBinding.setBindings((Expr.VectorInputBinding)this.baseBinding);
        VectorMatch matchMaker = filteredVectorInputBinding.getVectorMatch();
        int[] selection = matchMaker.getSelection();
        selection[0] = 1;
        selection[1] = 3;
        selection[2] = 4;
        matchMaker.setSelectionSize(3);
        long[] longs = filteredVectorInputBinding.getLongVector("long");
        boolean[] nulls = filteredVectorInputBinding.getNullVector("long");
        Assert.assertEquals((long)3L, (long)filteredVectorInputBinding.getCurrentVectorSize());
        Assert.assertNotNull((Object)nulls);
        Assert.assertEquals((long)1L, (long)longs[0]);
        Assert.assertEquals((long)3L, (long)longs[1]);
        Assert.assertEquals((long)4L, (long)longs[2]);
        Assert.assertFalse((boolean)nulls[0]);
        Assert.assertTrue((boolean)nulls[1]);
        Assert.assertFalse((boolean)nulls[2]);
        selection[0] = 0;
        selection[1] = 2;
        selection[2] = 5;
        selection[3] = 6;
        selection[4] = 7;
        matchMaker.setSelectionSize(5);
        longs = filteredVectorInputBinding.getLongVector("long");
        nulls = filteredVectorInputBinding.getNullVector("long");
        Assert.assertEquals((long)5L, (long)filteredVectorInputBinding.getCurrentVectorSize());
        Assert.assertNotNull((Object)nulls);
        Assert.assertEquals((long)0L, (long)longs[0]);
        Assert.assertEquals((long)2L, (long)longs[1]);
        Assert.assertEquals((long)5L, (long)longs[2]);
        Assert.assertEquals((long)6L, (long)longs[3]);
        Assert.assertEquals((long)7L, (long)longs[4]);
        Assert.assertFalse((boolean)nulls[0]);
        Assert.assertFalse((boolean)nulls[1]);
        Assert.assertFalse((boolean)nulls[2]);
        Assert.assertTrue((boolean)nulls[3]);
        Assert.assertFalse((boolean)nulls[4]);
        selection[0] = 1;
        selection[1] = 3;
        selection[2] = 4;
        matchMaker.setSelectionSize(3);
        longs = filteredVectorInputBinding.getLongVector("long");
        nulls = filteredVectorInputBinding.getNullVector("long");
        Assert.assertEquals((long)3L, (long)filteredVectorInputBinding.getCurrentVectorSize());
        Assert.assertNotNull((Object)nulls);
        Assert.assertEquals((long)1L, (long)longs[0]);
        Assert.assertEquals((long)3L, (long)longs[1]);
        Assert.assertEquals((long)4L, (long)longs[2]);
        Assert.assertFalse((boolean)nulls[0]);
        Assert.assertTrue((boolean)nulls[1]);
        Assert.assertFalse((boolean)nulls[2]);
    }

    @Test
    public void testDoubles() {
        FilteredVectorInputBinding filteredVectorInputBinding = new FilteredVectorInputBinding(8);
        filteredVectorInputBinding.setBindings((Expr.VectorInputBinding)this.baseBinding);
        VectorMatch matchMaker = filteredVectorInputBinding.getVectorMatch();
        int[] selection = matchMaker.getSelection();
        selection[0] = 1;
        selection[1] = 3;
        selection[2] = 4;
        matchMaker.setSelectionSize(3);
        double[] doubles = filteredVectorInputBinding.getDoubleVector("double");
        boolean[] nulls = filteredVectorInputBinding.getNullVector("double");
        Assert.assertEquals((long)3L, (long)filteredVectorInputBinding.getCurrentVectorSize());
        Assert.assertEquals((double)1.1, (double)doubles[0], (double)0.0);
        Assert.assertEquals((double)3.3, (double)doubles[1], (double)0.0);
        Assert.assertEquals((double)4.4, (double)doubles[2], (double)0.0);
        selection[0] = 0;
        selection[1] = 2;
        selection[2] = 5;
        selection[3] = 6;
        selection[4] = 7;
        matchMaker.setSelectionSize(5);
        doubles = filteredVectorInputBinding.getDoubleVector("double");
        nulls = filteredVectorInputBinding.getNullVector("double");
        Assert.assertEquals((long)5L, (long)filteredVectorInputBinding.getCurrentVectorSize());
        Assert.assertEquals((double)0.0, (double)doubles[0], (double)0.0);
        Assert.assertEquals((double)2.2, (double)doubles[1], (double)0.0);
        Assert.assertEquals((double)5.5, (double)doubles[2], (double)0.0);
        Assert.assertEquals((double)6.6, (double)doubles[3], (double)0.0);
        Assert.assertEquals((double)7.7, (double)doubles[4], (double)0.0);
        selection[0] = 1;
        selection[1] = 3;
        selection[2] = 4;
        matchMaker.setSelectionSize(3);
        doubles = filteredVectorInputBinding.getDoubleVector("double");
        nulls = filteredVectorInputBinding.getNullVector("double");
        Assert.assertEquals((long)3L, (long)filteredVectorInputBinding.getCurrentVectorSize());
        Assert.assertEquals((double)1.1, (double)doubles[0], (double)0.0);
        Assert.assertEquals((double)3.3, (double)doubles[1], (double)0.0);
        Assert.assertEquals((double)4.4, (double)doubles[2], (double)0.0);
    }
}

