/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.FallbackVectorProcessor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FallbackVectorProcessorTest
extends InitializedNullHandlingTest {
    private static final int VECTOR_ID = 0;
    private static final int VECTOR_SIZE = 3;
    private static final RowSignature SIGNATURE = RowSignature.builder().add("long", ColumnType.LONG).add("double", ColumnType.DOUBLE).add("doubleNoNulls", ColumnType.DOUBLE).add("str", ColumnType.STRING).add("arr", ColumnType.LONG_ARRAY).build();
    private static final Map<String, List<Object>> DATA = ImmutableMap.builder().put((Object)"long", Arrays.asList(101L, null, 103L)).put((Object)"double", Arrays.asList(1.1, null, 1.3)).put((Object)"doubleNoNulls", Arrays.asList(1.1, 1.2, 1.3)).put((Object)"str", Arrays.asList("foo", null, "baz")).put((Object)"arr", Arrays.asList(new Object[]{201L, null, 203L}, null, new Object[]{301L, null, 303L})).build();
    private Expr.VectorInputBinding binding;

    @Before
    public void setUp() {
        this.binding = new Expr.VectorInputBinding(){

            public Object[] getObjectVector(String name) {
                if (this.getType(name).isNumeric()) {
                    throw new ISE("Incorrect call for field[%s] of type[%s]", new Object[]{name, this.getType(name)});
                }
                return DATA.get(name).toArray();
            }

            public long[] getLongVector(String name) {
                if (!this.getType(name).equals((Object)ExpressionType.LONG)) {
                    throw new ISE("Incorrect call for field[%s] of type[%s]", new Object[]{name, this.getType(name)});
                }
                List<Object> longs = DATA.get(name);
                long[] longArray = new long[3];
                for (int i = 0; i < longs.size(); ++i) {
                    Object o = longs.get(i);
                    longArray[i] = o == null ? 0L : (Long)o;
                }
                return longArray;
            }

            public double[] getDoubleVector(String name) {
                if (!this.getType(name).equals((Object)ExpressionType.DOUBLE)) {
                    throw new ISE("Incorrect call for field[%s] of type[%s]", new Object[]{name, this.getType(name)});
                }
                List<Object> doubles = DATA.get(name);
                double[] doubleArray = new double[3];
                for (int i = 0; i < doubles.size(); ++i) {
                    Object o = doubles.get(i);
                    doubleArray[i] = o == null ? 0.0 : (Double)o;
                }
                return doubleArray;
            }

            @Nullable
            public boolean[] getNullVector(String name) {
                List<Object> objects = DATA.get(name);
                boolean[] nullArray = new boolean[3];
                boolean anyNulls = false;
                for (int i = 0; i < objects.size(); ++i) {
                    Object o = objects.get(i);
                    nullArray[i] = o == null;
                    anyNulls = anyNulls || o == null;
                }
                return (boolean[])(anyNulls ? nullArray : null);
            }

            public int getCurrentVectorSize() {
                return 3;
            }

            public int getCurrentVectorId() {
                return 0;
            }

            public int getMaxVectorSize() {
                return 3;
            }

            @Nullable
            public ExpressionType getType(String name) {
                return SIGNATURE.getColumnType(name).map(ExpressionType::fromColumnType).orElse(null);
            }
        };
    }

    @Test
    public void test_case_long_double() {
        FallbackVectorProcessor processor = FallbackVectorProcessor.create((Function)new Function.CaseSimpleFunc(), (List)ImmutableList.of((Object)Parser.parse((String)"long + double", (ExprMacroTable)ExprMacroTable.nil()), (Object)Parser.parse((String)"102.1", (ExprMacroTable)ExprMacroTable.nil()), (Object)Parser.parse((String)"long", (ExprMacroTable)ExprMacroTable.nil()), (Object)Parser.parse((String)"double", (ExprMacroTable)ExprMacroTable.nil())), (Expr.VectorInputBindingInspector)this.binding);
        ExprEvalVector eval = processor.evalVector(this.binding);
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)eval.getType());
        Assert.assertArrayEquals((Object[])new Object[]{101.0, null, 1.3}, (Object[])eval.getObjectVector());
        Assert.assertArrayEquals((double[])new double[]{101.0, 0.0, 1.3}, (double[])eval.getDoubleVector(), (double)0.0);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true, false}, (boolean[])eval.getNullVector());
    }

    @Test
    public void test_upper_string() {
        FallbackVectorProcessor processor = FallbackVectorProcessor.create((Function)new Function.UpperFunc(), (List)ImmutableList.of((Object)Parser.parse((String)"str", (ExprMacroTable)ExprMacroTable.nil())), (Expr.VectorInputBindingInspector)this.binding);
        ExprEvalVector eval = processor.evalVector(this.binding);
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.getType());
        Assert.assertArrayEquals((Object[])new Object[]{"FOO", null, "BAZ"}, (Object[])eval.getObjectVector());
    }

    @Test
    public void test_concat_string_doubleNoNulls() {
        FallbackVectorProcessor processor = FallbackVectorProcessor.create((Function)new Function.ConcatFunc(), (List)ImmutableList.of((Object)Parser.parse((String)"str", (ExprMacroTable)ExprMacroTable.nil()), (Object)Parser.parse((String)"doubleNoNulls + 2", (ExprMacroTable)ExprMacroTable.nil())), (Expr.VectorInputBindingInspector)this.binding);
        ExprEvalVector eval = processor.evalVector(this.binding);
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)eval.getType());
        Assert.assertArrayEquals((Object[])new Object[]{"foo3.1", null, "baz3.3"}, (Object[])eval.getObjectVector());
    }

    @Test
    public void test_array_length() {
        FallbackVectorProcessor processor = FallbackVectorProcessor.create((Function)new Function.ArrayLengthFunction(), (List)ImmutableList.of((Object)Parser.parse((String)"arr", (ExprMacroTable)ExprMacroTable.nil())), (Expr.VectorInputBindingInspector)this.binding);
        ExprEvalVector eval = processor.evalVector(this.binding);
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)eval.getType());
        Assert.assertArrayEquals((Object[])new Object[]{3L, null, 3L}, (Object[])eval.getObjectVector());
        Assert.assertArrayEquals((long[])new long[]{3L, 0L, 3L}, (long[])eval.getLongVector());
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true, false}, (boolean[])eval.getNullVector());
    }

    @Test
    public void test_array_concat() {
        FallbackVectorProcessor processor = FallbackVectorProcessor.create((Function)new Function.ArrayConcatFunction(), (List)ImmutableList.of((Object)Parser.parse((String)"arr", (ExprMacroTable)ExprMacroTable.nil()), (Object)Parser.parse((String)"long", (ExprMacroTable)ExprMacroTable.nil())), (Expr.VectorInputBindingInspector)this.binding);
        ExprEvalVector eval = processor.evalVector(this.binding);
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)eval.getType());
        Assert.assertArrayEquals((Object[])new Object[]{201L, null, 203L, 101L}, (Object[])((Object[])eval.getObjectVector()[0]));
        Assert.assertNull((Object)eval.getObjectVector()[1]);
        Assert.assertArrayEquals((Object[])new Object[]{301L, null, 303L, 103L}, (Object[])((Object[])eval.getObjectVector()[2]));
    }
}

