/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;

public class SettableVectorInputBinding
implements Expr.VectorInputBinding {
    private final Map<String, boolean[]> nulls = new HashMap<String, boolean[]>();
    private final Map<String, long[]> longs = new HashMap<String, long[]>();
    private final Map<String, double[]> doubles = new HashMap<String, double[]>();
    private final Map<String, Object[]> objects = new HashMap<String, Object[]>();
    private final Map<String, ExpressionType> types = new HashMap<String, ExpressionType>();
    private final int vectorSize;
    private int id = 0;

    public SettableVectorInputBinding(int vectorSize) {
        this.vectorSize = vectorSize;
    }

    public SettableVectorInputBinding addBinding(String name, ExpressionType type, boolean[] nulls) {
        this.nulls.put(name, nulls);
        this.types.put(name, type);
        return this;
    }

    public SettableVectorInputBinding addLong(String name, long[] longs) {
        return this.addLong(name, longs, new boolean[longs.length]);
    }

    public SettableVectorInputBinding addLong(String name, long[] longs, boolean[] nulls) {
        assert (longs.length == this.vectorSize);
        this.longs.put(name, longs);
        this.doubles.put(name, Arrays.stream(longs).asDoubleStream().toArray());
        return this.addBinding(name, ExpressionType.LONG, nulls);
    }

    public SettableVectorInputBinding addDouble(String name, double[] doubles) {
        return this.addDouble(name, doubles, new boolean[doubles.length]);
    }

    public SettableVectorInputBinding addDouble(String name, double[] doubles, boolean[] nulls) {
        assert (doubles.length == this.vectorSize);
        this.doubles.put(name, doubles);
        this.longs.put(name, Arrays.stream(doubles).mapToLong(x -> (long)x).toArray());
        return this.addBinding(name, ExpressionType.DOUBLE, nulls);
    }

    public SettableVectorInputBinding addString(String name, Object[] strings) {
        assert (strings.length == this.vectorSize);
        this.objects.put(name, strings);
        return this.addBinding(name, ExpressionType.STRING, new boolean[strings.length]);
    }

    public Object[] getObjectVector(String name) {
        return this.objects.getOrDefault(name, new Object[this.getCurrentVectorSize()]);
    }

    public ExpressionType getType(String name) {
        return this.types.get(name);
    }

    public long[] getLongVector(String name) {
        return this.longs.getOrDefault(name, new long[this.getCurrentVectorSize()]);
    }

    public double[] getDoubleVector(String name) {
        return this.doubles.getOrDefault(name, new double[this.getCurrentVectorSize()]);
    }

    @Nullable
    public boolean[] getNullVector(String name) {
        boolean[] defaultVector = new boolean[this.getCurrentVectorSize()];
        Arrays.fill(defaultVector, true);
        return this.nulls.getOrDefault(name, defaultVector);
    }

    public int getMaxVectorSize() {
        return this.vectorSize;
    }

    public int getCurrentVectorSize() {
        return this.vectorSize;
    }

    public int getCurrentVectorId() {
        return this.id++;
    }
}

