/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.druid.math.expr.BinAndExpr;
import org.apache.druid.math.expr.BinEqExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.FunctionExpr;
import org.apache.druid.math.expr.IdentifierExpr;
import org.apache.druid.segment.join.Equality;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ExprsTest {
    @Test
    public void test_decomposeAnd_notAnAnd() {
        List decomposed = Exprs.decomposeAnd((Expr)new IdentifierExpr("foo"));
        Assert.assertEquals((long)1L, (long)decomposed.size());
        Assert.assertThat((Object)((Expr)decomposed.get(0)), (Matcher)CoreMatchers.instanceOf(IdentifierExpr.class));
        Assert.assertEquals((Object)"foo", (Object)((IdentifierExpr)decomposed.get(0)).getIdentifier());
    }

    @Test
    public void test_decomposeAnd_basic() {
        List decomposed = Exprs.decomposeAnd((Expr)new BinAndExpr("&&", (Expr)new BinAndExpr("&&", (Expr)new IdentifierExpr("foo"), (Expr)new IdentifierExpr("bar")), (Expr)new BinAndExpr("&&", (Expr)new IdentifierExpr("baz"), (Expr)new IdentifierExpr("qux"))));
        Assert.assertEquals((long)4L, (long)decomposed.size());
        for (Expr expr2 : decomposed) {
            Assert.assertThat((Object)expr2, (Matcher)CoreMatchers.instanceOf(IdentifierExpr.class));
        }
        List identifiers = decomposed.stream().map(expr -> ((IdentifierExpr)expr).getIdentifier()).collect(Collectors.toList());
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux"), identifiers);
    }

    @Test
    public void test_decomposeEquals_notAnEquals() {
        Optional result = Exprs.decomposeEquals((Expr)new IdentifierExpr("foo"), (String)"j.");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void test_decomposeEquals_basic() {
        Optional result = Exprs.decomposeEquals((Expr)new BinEqExpr("==", (Expr)new IdentifierExpr("foo"), (Expr)new IdentifierExpr("j.bar")), (String)"j.");
        Assert.assertTrue((boolean)result.isPresent());
        Equality equality = (Equality)result.get();
        MatcherAssert.assertThat((Object)equality.getLeftExpr(), (Matcher)CoreMatchers.instanceOf(IdentifierExpr.class));
        Assert.assertEquals((Object)"foo", (Object)((IdentifierExpr)equality.getLeftExpr()).getIdentifier());
        Assert.assertEquals((Object)"bar", (Object)equality.getRightColumn());
        Assert.assertFalse((boolean)equality.isIncludeNull());
    }

    @Test
    public void test_decomposeEquals_notDistinctFrom() {
        Optional result = Exprs.decomposeEquals((Expr)new FunctionExpr((Function)new Function.IsNotDistinctFromFunc(), "notdistinctfrom", (List)ImmutableList.of((Object)new IdentifierExpr("foo"), (Object)new IdentifierExpr("j.bar"))), (String)"j.");
        Assert.assertTrue((boolean)result.isPresent());
        Equality equality = (Equality)result.get();
        MatcherAssert.assertThat((Object)equality.getLeftExpr(), (Matcher)CoreMatchers.instanceOf(IdentifierExpr.class));
        Assert.assertEquals((Object)"foo", (Object)((IdentifierExpr)equality.getLeftExpr()).getIdentifier());
        Assert.assertEquals((Object)"bar", (Object)equality.getRightColumn());
        Assert.assertTrue((boolean)equality.isIncludeNull());
    }
}

