/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.CgroupV2MemoryMonitor;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupV2Discoverer;
import org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class CgroupV2MemoryMonitorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;
    private File cgroupDir;
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws IOException {
        this.cgroupDir = this.temporaryFolder.newFolder();
        this.procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupV2Discoverer(this.procDir.toPath());
        TestUtils.setUpCgroupsV2(this.procDir, this.cgroupDir);
        TestUtils.copyResource("/memory.stat", new File(this.cgroupDir, "memory.stat"));
        TestUtils.copyResource("/memory.numa_stat", new File(this.cgroupDir, "memory.numa_stat"));
        TestUtils.copyResource("/memory.usage_in_bytes", new File(this.cgroupDir, "memory.current"));
        TestUtils.copyResource("/memory.limit_in_bytes", new File(this.cgroupDir, "memory.max"));
    }

    @Test
    public void testMonitor() {
        CgroupV2MemoryMonitor monitor = new CgroupV2MemoryMonitor(this.discoverer);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        Assert.assertTrue((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        List<Event> actualEvents = emitter.getEvents();
        Assert.assertEquals((long)46L, (long)actualEvents.size());
    }
}

