/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.io.AppendableByteArrayInputStream;
import org.junit.Assert;
import org.junit.Test;

public class AppendableByteArrayInputStreamTest {
    @Test
    public void testSingleByteArray() throws Exception {
        byte[][] bytesToWrite = new byte[][]{{0, 1, 2, 3, 4, 5, 6}};
        this.testAll(bytesToWrite, bytesToWrite[0]);
    }

    @Test
    public void testMultiByteArray() throws Exception {
        byte[] expectedBytes = new byte[]{0, 1, 2, 3, 4, 5, 6};
        this.testAll(new byte[][]{{0, 1, 2, 3}, {4, 5, 6}}, expectedBytes);
        this.testAll(new byte[][]{{0, 1}, {2, 3}, {4, 5, 6}}, expectedBytes);
        this.testAll(new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}}, expectedBytes);
    }

    public void testAll(byte[][] writtenBytes, byte[] expectedBytes) throws Exception {
        this.testFullRead(writtenBytes, expectedBytes);
        this.testIndividualRead(writtenBytes, expectedBytes);
    }

    public void testIndividualRead(byte[][] writtenBytes, byte[] expectedBytes) throws IOException {
        AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        for (byte[] writtenByte : writtenBytes) {
            in.add(writtenByte);
        }
        for (int i = 0; i < expectedBytes.length; ++i) {
            int readByte = in.read();
            if (expectedBytes[i] == (byte)readByte) continue;
            Assert.assertEquals((String)StringUtils.format((String)"%s[%d]", (Object[])new Object[]{Arrays.toString(expectedBytes), i}), (long)expectedBytes[i], (long)readByte);
        }
    }

    public void testFullRead(byte[][] writtenBytes, byte[] expectedBytes) throws IOException {
        AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        byte[] readBytes = new byte[expectedBytes.length];
        for (byte[] writtenByte : writtenBytes) {
            in.add(writtenByte);
        }
        Assert.assertEquals((long)readBytes.length, (long)in.read(readBytes));
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])readBytes);
    }

    @Test
    public void testReadsAndWritesInterspersed() throws Exception {
        AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        in.add(new byte[]{0, 1, 2});
        byte[] readBytes = new byte[3];
        Assert.assertEquals((long)3L, (long)in.read(readBytes));
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2}, (byte[])readBytes);
        in.add(new byte[]{3, 4});
        in.add(new byte[]{5, 6, 7});
        readBytes = new byte[5];
        Assert.assertEquals((long)5L, (long)in.read(readBytes));
        Assert.assertArrayEquals((byte[])new byte[]{3, 4, 5, 6, 7}, (byte[])readBytes);
    }

    @Test
    public void testReadLessThanWritten() throws Exception {
        AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        in.add(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        byte[] readBytes = new byte[4];
        Assert.assertEquals((long)4L, (long)in.read(readBytes));
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3}, (byte[])readBytes);
        Assert.assertEquals((long)4L, (long)in.read(readBytes));
        Assert.assertArrayEquals((byte[])new byte[]{4, 5, 6, 7}, (byte[])readBytes);
        Assert.assertEquals((long)2L, (long)in.read(readBytes, 0, 2));
        Assert.assertArrayEquals((byte[])new byte[]{8, 9, 6, 7}, (byte[])readBytes);
    }

    @Test
    public void testReadLessThanWrittenMultiple() throws Exception {
        AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        in.add(new byte[]{0, 1, 2});
        in.add(new byte[]{3, 4, 5});
        in.add(new byte[]{6, 7});
        in.add(new byte[]{8, 9});
        byte[] readBytes = new byte[4];
        Assert.assertEquals((long)4L, (long)in.read(readBytes));
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3}, (byte[])readBytes);
        Assert.assertEquals((long)4L, (long)in.read(readBytes));
        Assert.assertArrayEquals((byte[])new byte[]{4, 5, 6, 7}, (byte[])readBytes);
        Assert.assertEquals((long)2L, (long)in.read(readBytes, 0, 2));
        Assert.assertArrayEquals((byte[])new byte[]{8, 9, 6, 7}, (byte[])readBytes);
    }

    @Test
    public void testBlockingRead() throws Exception {
        final AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        in.add(new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((long)5L, (long)in.available());
        Future<byte[]> bytesFuture = Executors.newSingleThreadExecutor().submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                byte[] readBytes = new byte[10];
                in.read(readBytes);
                return readBytes;
            }
        });
        int count = 0;
        while (in.available() != 0) {
            if (count >= 100) {
                Assert.fail((String)"available didn't become 0 fast enough.");
            }
            ++count;
            Thread.sleep(10L);
        }
        in.add(new byte[]{5, 6, 7, 8, 9, 10});
        count = 0;
        while (in.available() != 1) {
            if (count >= 100) {
                Assert.fail((String)"available didn't become 1 fast enough.");
            }
            ++count;
            Thread.sleep(10L);
        }
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, (byte[])bytesFuture.get());
        Assert.assertEquals((long)10L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.available());
    }

    @Test
    public void testAddEmptyByteArray() throws Exception {
        AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        in.add(new byte[0]);
        in.add(new byte[]{1});
        in.add(new byte[0]);
        in.done();
        Assert.assertEquals((long)1L, (long)in.available());
        Assert.assertEquals((long)1L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.available());
        Assert.assertEquals((long)-1L, (long)in.read());
    }

    @Test
    public void testExceptionUnblocks() throws InterruptedException {
        final AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        in.add(new byte[0]);
        in.add(new byte[]{1});
        in.add(new byte[0]);
        final AtomicReference exceptionThrown = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().submit(new Callable(){

            public byte[] call() {
                try {
                    byte[] readBytes = new byte[10];
                    while (in.read(readBytes) != -1) {
                    }
                    return readBytes;
                }
                catch (IOException e) {
                    exceptionThrown.set(e);
                    latch.countDown();
                    return null;
                }
            }
        });
        Exception expected = new Exception();
        in.exceptionCaught((Throwable)expected);
        latch.await();
        Assert.assertEquals((Object)expected, (Object)((IOException)exceptionThrown.get()).getCause());
        try {
            in.read();
            Assert.fail();
        }
        catch (IOException thrown) {
            Assert.assertEquals((Object)expected, (Object)thrown.getCause());
        }
    }
}

