/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.HttpClientInit;
import org.apache.druid.java.util.http.client.HttpClientProxyConfig;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.KeyStoreScanner;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class FriendlyServersTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFriendlyHttpServer() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final ServerSocket serverSocket = new ServerSocket(0);
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = serverSocket.accept();
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));){
                            OutputStream out = clientSocket.getOutputStream();
                            try {
                                while (!in.readLine().equals("")) {
                                }
                                out.write("HTTP/1.1 200 OK\r\nContent-Length: 6\r\n\r\nhello!".getBytes(StandardCharsets.UTF_8));
                            }
                            finally {
                                if (out == null) continue;
                                out.close();
                            }
                        }
                        finally {
                            if (clientSocket == null) continue;
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            StatusResponseHolder response = (StatusResponseHolder)client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{serverSocket.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            Assert.assertEquals((long)200L, (long)response.getStatus().getCode());
            Assert.assertEquals((Object)"hello!", (Object)response.getContent());
        }
        finally {
            exec.shutdownNow();
            serverSocket.close();
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFriendlyProxyHttpServer() throws Exception {
        final AtomicReference requestContent = new AtomicReference();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final ServerSocket serverSocket = new ServerSocket(0);
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = serverSocket.accept();
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));){
                            OutputStream out = clientSocket.getOutputStream();
                            try {
                                String line;
                                StringBuilder request = new StringBuilder();
                                while (!"".equals(line = in.readLine())) {
                                    request.append(line).append("\r\n");
                                }
                                requestContent.set(request.toString());
                                out.write("HTTP/1.1 200 OK\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                                while (!in.readLine().equals("")) {
                                }
                                out.write("HTTP/1.1 200 OK\r\nContent-Length: 6\r\n\r\nhello!".getBytes(StandardCharsets.UTF_8));
                            }
                            finally {
                                if (out == null) continue;
                                out.close();
                            }
                        }
                        finally {
                            if (clientSocket == null) continue;
                            clientSocket.close();
                        }
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.toString());
                    }
                }
            }
        });
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withHttpProxyConfig(new HttpClientProxyConfig("localhost", serverSocket.getLocalPort(), "bob", "sally")).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            StatusResponseHolder response = (StatusResponseHolder)client.go(new Request(HttpMethod.GET, new URL("http://anotherHost:8080/")), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            Assert.assertEquals((long)200L, (long)response.getStatus().getCode());
            Assert.assertEquals((Object)"hello!", (Object)response.getContent());
            Assert.assertEquals((Object)"CONNECT anotherHost:8080 HTTP/1.1\r\nProxy-Authorization: Basic Ym9iOnNhbGx5\r\n", requestContent.get());
        }
        finally {
            exec.shutdownNow();
            serverSocket.close();
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressionCodecConfig() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final ServerSocket serverSocket = new ServerSocket(0);
        final AtomicBoolean foundAcceptEncoding = new AtomicBoolean();
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = serverSocket.accept();
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));){
                            OutputStream out = clientSocket.getOutputStream();
                            try {
                                String header;
                                while (!(header = in.readLine()).equals("")) {
                                    if (!"Accept-Encoding: identity".equals(header)) continue;
                                    foundAcceptEncoding.set(true);
                                }
                                out.write("HTTP/1.1 200 OK\r\nContent-Length: 6\r\n\r\nhello!".getBytes(StandardCharsets.UTF_8));
                            }
                            finally {
                                if (out == null) continue;
                                out.close();
                            }
                        }
                        finally {
                            if (clientSocket == null) continue;
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withCompressionCodec(HttpClientConfig.CompressionCodec.IDENTITY).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            StatusResponseHolder response = (StatusResponseHolder)client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{serverSocket.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
            Assert.assertEquals((long)200L, (long)response.getStatus().getCode());
            Assert.assertEquals((Object)"hello!", (Object)response.getContent());
            Assert.assertTrue((boolean)foundAcceptEncoding.get());
        }
        finally {
            exec.shutdownNow();
            serverSocket.close();
            lifecycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFriendlySelfSignedHttpsServer() throws Exception {
        Lifecycle lifecycle = new Lifecycle();
        String keyStorePath = this.getClass().getClassLoader().getResource("keystore.jks").getFile();
        Server server = new Server();
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyStorePassword("abc123");
        sslContextFactory.setKeyManagerPassword("abc123");
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
        sslConnector.setPort(0);
        server.setConnectors(new Connector[]{sslConnector});
        KeyStoreScanner keyStoreScanner = new KeyStoreScanner((SslContextFactory)sslContextFactory);
        server.addBean((Object)keyStoreScanner);
        server.start();
        try {
            SSLContext mySsl = HttpClientInit.sslContextWithTrustedKeyStore((String)keyStorePath, (String)"abc123");
            HttpClientConfig trustingConfig = HttpClientConfig.builder().withSslContext(mySsl).build();
            HttpClient trustingClient = HttpClientInit.createClient((HttpClientConfig)trustingConfig, (Lifecycle)lifecycle);
            HttpClientConfig skepticalConfig = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient skepticalClient = HttpClientInit.createClient((HttpClientConfig)skepticalConfig, (Lifecycle)lifecycle);
            HttpResponseStatus status = ((StatusResponseHolder)trustingClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://localhost:%d/", (Object[])new Object[]{sslConnector.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get()).getStatus();
            Assert.assertEquals((long)404L, (long)status.getCode());
            ListenableFuture response1 = trustingClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://127.0.0.1:%d/", (Object[])new Object[]{sslConnector.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            Throwable ea = null;
            try {
                response1.get();
            }
            catch (ExecutionException e) {
                ea = e.getCause();
            }
            Assert.assertTrue((String)"ChannelException thrown by 'get'", (boolean)(ea instanceof ChannelException));
            Assert.assertTrue((String)"Expected error message", (boolean)ea.getCause().getMessage().contains("Failed to handshake"));
            ListenableFuture response2 = skepticalClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"https://localhost:%d/", (Object[])new Object[]{sslConnector.getLocalPort()}))), (HttpResponseHandler)StatusResponseHandler.getInstance());
            Throwable eb = null;
            try {
                response2.get();
            }
            catch (ExecutionException e) {
                eb = e.getCause();
            }
            Assert.assertNotNull((String)"ChannelException thrown by 'get'", (Object)eb);
            Assert.assertTrue((String)"Root cause is SSLHandshakeException", (boolean)(eb.getCause().getCause() instanceof SSLHandshakeException));
        }
        finally {
            lifecycle.stop();
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testHttpBin() throws Throwable {
        Lifecycle lifecycle = new Lifecycle();
        try {
            HttpClientConfig config = HttpClientConfig.builder().withSslContext(SSLContext.getDefault()).build();
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)config, (Lifecycle)lifecycle);
            HttpResponseStatus status = ((StatusResponseHolder)client.go(new Request(HttpMethod.GET, new URL("https://httpbin.org/get")), (HttpResponseHandler)StatusResponseHandler.getInstance()).get()).getStatus();
            Assert.assertEquals((long)200L, (long)status.getCode());
            status = ((StatusResponseHolder)client.go(new Request(HttpMethod.POST, new URL("https://httpbin.org/post")).setContent(new byte[]{97, 98, 99, 1, 2, 3}), (HttpResponseHandler)StatusResponseHandler.getInstance()).get()).getStatus();
            Assert.assertEquals((long)200L, (long)status.getCode());
        }
        finally {
            lifecycle.stop();
        }
    }
}

