/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.primitives.Ints;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.java.util.emitter.core.BaseHttpEmittingConfig;
import org.apache.druid.java.util.emitter.core.Batch;
import org.apache.druid.java.util.emitter.core.BatchingStrategy;
import org.apache.druid.java.util.emitter.core.EmitterTest;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.GoHandler;
import org.apache.druid.java.util.emitter.core.GoHandlers;
import org.apache.druid.java.util.emitter.core.HttpEmitterConfig;
import org.apache.druid.java.util.emitter.core.HttpPostEmitter;
import org.apache.druid.java.util.emitter.core.IntEvent;
import org.apache.druid.java.util.emitter.core.MockHttpClient;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class HttpEmitterTest {
    private final MockHttpClient httpClient = new MockHttpClient();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(){

        public byte[] writeValueAsBytes(Object value) {
            return Ints.toByteArray((int)((IntEvent)value).index);
        }
    };
    private final AtomicLong timeoutUsed = new AtomicLong();

    @Before
    public void setup() {
        this.timeoutUsed.set(-1L);
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) {
                Duration timeout = request.getRequestTimeout();
                HttpEmitterTest.this.timeoutUsed.set(timeout.toMillis());
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        });
    }

    @Test
    public void timeoutEmptyQueue() throws Exception {
        double timeoutAllowanceFactor = 2.0;
        HttpEmitterConfig config = new HttpEmitterConfig.Builder("http://foo.bar").setBatchingStrategy(BatchingStrategy.ONLY_EVENTS).setHttpTimeoutAllowanceFactor((float)timeoutAllowanceFactor).setFlushTimeout(BaseHttpEmittingConfig.TEST_FLUSH_TIMEOUT_MILLIS).build();
        Field lastBatchFillTimeMillis = HttpPostEmitter.class.getDeclaredField("lastBatchFillTimeMillis");
        lastBatchFillTimeMillis.setAccessible(true);
        HttpPostEmitter emitter = new HttpPostEmitter(config, (AsyncHttpClient)this.httpClient, OBJECT_MAPPER);
        long startMs = System.currentTimeMillis();
        emitter.start();
        emitter.emitAndReturnBatch((Event)new IntEvent());
        emitter.flush();
        long fillTimeMs = Math.max(1L, System.currentTimeMillis() - startMs);
        Assume.assumeTrue((fillTimeMs >= (Long)lastBatchFillTimeMillis.get(emitter) ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)this.timeoutUsed.get(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf((double)fillTimeMs * timeoutAllowanceFactor)));
        startMs = System.currentTimeMillis();
        Batch batch = emitter.emitAndReturnBatch((Event)new IntEvent());
        Thread.sleep(1000L);
        batch.seal();
        emitter.flush();
        fillTimeMs = Math.max(1L, System.currentTimeMillis() - startMs);
        Assume.assumeTrue((fillTimeMs >= (Long)lastBatchFillTimeMillis.get(emitter) ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)this.timeoutUsed.get(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf((double)fillTimeMs * timeoutAllowanceFactor)));
    }
}

