/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Properties;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.core.BaseHttpEmittingConfig;
import org.apache.druid.java.util.emitter.core.BatchingStrategy;
import org.apache.druid.java.util.emitter.core.Emitters;
import org.apache.druid.java.util.emitter.core.HttpEmitterConfig;
import org.junit.Assert;
import org.junit.Test;

public class HttpEmitterConfigTest {
    @Test
    public void testDefaults() {
        Properties props = new Properties();
        props.put("org.apache.druid.java.util.emitter.recipientBaseUrl", "http://example.com/");
        ObjectMapper objectMapper = new ObjectMapper();
        HttpEmitterConfig config = (HttpEmitterConfig)objectMapper.convertValue((Object)Emitters.makeCustomFactoryMap((Properties)props), HttpEmitterConfig.class);
        Assert.assertEquals((long)60000L, (long)config.getFlushMillis());
        Assert.assertEquals((long)500L, (long)config.getFlushCount());
        Assert.assertEquals((Object)"http://example.com/", (Object)config.getRecipientBaseUrl());
        Assert.assertNull((Object)config.getBasicAuthentication());
        Assert.assertEquals((Object)BatchingStrategy.ARRAY, (Object)config.getBatchingStrategy());
        Assert.assertEquals((long)BaseHttpEmittingConfig.DEFAULT_MAX_BATCH_SIZE, (long)config.getMaxBatchSize());
        Assert.assertEquals((long)BaseHttpEmittingConfig.DEFAULT_BATCH_QUEUE_SIZE_LIMIT, (long)config.getBatchQueueSizeLimit());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)config.getFlushTimeOut());
        Assert.assertEquals((float)2.0f, (float)config.getHttpTimeoutAllowanceFactor(), (float)0.0f);
        Assert.assertEquals((long)0L, (long)config.getMinHttpTimeoutMillis());
    }

    @Test
    public void testDefaultsLegacy() {
        Properties props = new Properties();
        props.put("org.apache.druid.java.util.emitter.http.url", "http://example.com/");
        ObjectMapper objectMapper = new ObjectMapper();
        HttpEmitterConfig config = (HttpEmitterConfig)objectMapper.convertValue((Object)Emitters.makeHttpMap((Properties)props), HttpEmitterConfig.class);
        Assert.assertEquals((long)60000L, (long)config.getFlushMillis());
        Assert.assertEquals((long)300L, (long)config.getFlushCount());
        Assert.assertEquals((Object)"http://example.com/", (Object)config.getRecipientBaseUrl());
        Assert.assertNull((Object)config.getBasicAuthentication());
        Assert.assertEquals((Object)BatchingStrategy.ARRAY, (Object)config.getBatchingStrategy());
        Assert.assertEquals((long)BaseHttpEmittingConfig.DEFAULT_MAX_BATCH_SIZE, (long)config.getMaxBatchSize());
        Assert.assertEquals((long)BaseHttpEmittingConfig.DEFAULT_BATCH_QUEUE_SIZE_LIMIT, (long)config.getBatchQueueSizeLimit());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)config.getFlushTimeOut());
        Assert.assertEquals((float)2.0f, (float)config.getHttpTimeoutAllowanceFactor(), (float)0.0f);
        Assert.assertEquals((long)0L, (long)config.getMinHttpTimeoutMillis());
    }

    @Test
    public void testSettingEverything() {
        Properties props = new Properties();
        props.setProperty("org.apache.druid.java.util.emitter.flushMillis", "1");
        props.setProperty("org.apache.druid.java.util.emitter.flushCount", "2");
        props.setProperty("org.apache.druid.java.util.emitter.recipientBaseUrl", "http://example.com/");
        props.setProperty("org.apache.druid.java.util.emitter.basicAuthentication", "a:b");
        props.setProperty("org.apache.druid.java.util.emitter.batchingStrategy", "NEWLINES");
        props.setProperty("org.apache.druid.java.util.emitter.maxBatchSize", "4");
        props.setProperty("org.apache.druid.java.util.emitter.flushTimeOut", "1000");
        props.setProperty("org.apache.druid.java.util.emitter.batchQueueSizeLimit", "2500");
        props.setProperty("org.apache.druid.java.util.emitter.httpTimeoutAllowanceFactor", "3.0");
        props.setProperty("org.apache.druid.java.util.emitter.minHttpTimeoutMillis", "100");
        ObjectMapper objectMapper = new ObjectMapper();
        HttpEmitterConfig config = (HttpEmitterConfig)objectMapper.convertValue((Object)Emitters.makeCustomFactoryMap((Properties)props), HttpEmitterConfig.class);
        Assert.assertEquals((long)1L, (long)config.getFlushMillis());
        Assert.assertEquals((long)2L, (long)config.getFlushCount());
        Assert.assertEquals((Object)"http://example.com/", (Object)config.getRecipientBaseUrl());
        Assert.assertEquals((Object)"a:b", (Object)config.getBasicAuthentication().getPassword());
        Assert.assertEquals((Object)BatchingStrategy.NEWLINES, (Object)config.getBatchingStrategy());
        Assert.assertEquals((long)4L, (long)config.getMaxBatchSize());
        Assert.assertEquals((long)1000L, (long)config.getFlushTimeOut());
        Assert.assertEquals((long)2500L, (long)config.getBatchQueueSizeLimit());
        Assert.assertEquals((float)3.0f, (float)config.getHttpTimeoutAllowanceFactor(), (float)0.0f);
        Assert.assertEquals((long)100L, (long)config.getMinHttpTimeoutMillis());
    }

    @Test
    public void testSettingEverythingLegacy() {
        Properties props = new Properties();
        props.setProperty("org.apache.druid.java.util.emitter.flushMillis", "1");
        props.setProperty("org.apache.druid.java.util.emitter.flushCount", "2");
        props.setProperty("org.apache.druid.java.util.emitter.http.url", "http://example.com/");
        props.setProperty("org.apache.druid.java.util.emitter.http.basicAuthentication", "a:b");
        props.setProperty("org.apache.druid.java.util.emitter.http.batchingStrategy", "newlines");
        props.setProperty("org.apache.druid.java.util.emitter.http.maxBatchSize", "4");
        props.setProperty("org.apache.druid.java.util.emitter.http.flushTimeOut", "1000");
        props.setProperty("org.apache.druid.java.util.emitter.http.batchQueueSizeLimit", "2500");
        props.setProperty("org.apache.druid.java.util.emitter.http.httpTimeoutAllowanceFactor", "3.0");
        props.setProperty("org.apache.druid.java.util.emitter.http.minHttpTimeoutMillis", "100");
        ObjectMapper objectMapper = new ObjectMapper();
        HttpEmitterConfig config = (HttpEmitterConfig)objectMapper.convertValue((Object)Emitters.makeHttpMap((Properties)props), HttpEmitterConfig.class);
        Assert.assertEquals((long)1L, (long)config.getFlushMillis());
        Assert.assertEquals((long)2L, (long)config.getFlushCount());
        Assert.assertEquals((Object)"http://example.com/", (Object)config.getRecipientBaseUrl());
        Assert.assertEquals((Object)"a:b", (Object)config.getBasicAuthentication().getPassword());
        Assert.assertEquals((Object)BatchingStrategy.NEWLINES, (Object)config.getBatchingStrategy());
        Assert.assertEquals((long)4L, (long)config.getMaxBatchSize());
        Assert.assertEquals((long)1000L, (long)config.getFlushTimeOut());
        Assert.assertEquals((long)2500L, (long)config.getBatchQueueSizeLimit());
        Assert.assertEquals((float)3.0f, (float)config.getHttpTimeoutAllowanceFactor(), (float)0.0f);
        Assert.assertEquals((long)100L, (long)config.getMinHttpTimeoutMillis());
    }

    @Test
    public void testMemoryLimits() {
        Pair batchConfigPair = BaseHttpEmittingConfig.getDefaultBatchSizeAndLimit((long)0x4000000L);
        Assert.assertEquals((long)0x333333L, (long)((Integer)batchConfigPair.lhs).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)batchConfigPair.rhs).intValue());
        Pair batchConfigPair2 = BaseHttpEmittingConfig.getDefaultBatchSizeAndLimit((long)0x8000000L);
        Assert.assertEquals((long)0x500000L, (long)((Integer)batchConfigPair2.lhs).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)batchConfigPair2.rhs).intValue());
        Pair batchConfigPair3 = BaseHttpEmittingConfig.getDefaultBatchSizeAndLimit((long)0x10000000L);
        Assert.assertEquals((long)0x500000L, (long)((Integer)batchConfigPair3.lhs).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)batchConfigPair3.rhs).intValue());
        Pair batchConfigPair4 = BaseHttpEmittingConfig.getDefaultBatchSizeAndLimit((long)Long.MAX_VALUE);
        Assert.assertEquals((long)0x500000L, (long)((Integer)batchConfigPair4.lhs).intValue());
        Assert.assertEquals((long)50L, (long)((Integer)batchConfigPair4.rhs).intValue());
    }
}

