/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.junit.Assert;
import org.junit.Test;

public class ObjectFlattenersTest {
    private static final String SOME_JSON = "{\"foo\": null, \"bar\": 1}";
    private static final ObjectFlatteners.FlattenerMaker FLATTENER_MAKER = new JSONFlattenerMaker(true, false);
    private static final ObjectFlattener FLATTENER = ObjectFlatteners.create((JSONPathSpec)new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "extract", "$.bar"))), (ObjectFlatteners.FlattenerMaker)FLATTENER_MAKER);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void testFlatten() throws JsonProcessingException {
        JsonNode node = OBJECT_MAPPER.readTree(SOME_JSON);
        Map flat = FLATTENER.flatten((Object)node);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"extract", (Object)"foo", (Object)"bar"), flat.keySet());
        Assert.assertFalse((boolean)flat.isEmpty());
        Assert.assertNull(flat.get("foo"));
        Assert.assertEquals((Object)1L, flat.get("bar"));
        Assert.assertEquals((Object)1L, flat.get("extract"));
        Assert.assertEquals((Object)"{\"extract\":1,\"foo\":null,\"bar\":1}", (Object)OBJECT_MAPPER.writeValueAsString((Object)flat));
    }

    @Test
    public void testToMap() throws JsonProcessingException {
        JsonNode node = OBJECT_MAPPER.readTree(SOME_JSON);
        Map flat = FLATTENER.toMap((Object)node);
        Assert.assertNull(flat.get("foo"));
        Assert.assertEquals((Object)1, flat.get("bar"));
    }

    @Test
    public void testToMapNull() throws JsonProcessingException {
        JsonNode node = OBJECT_MAPPER.readTree("null");
        Map flat = FLATTENER.toMap((Object)node);
        Assert.assertNull((Object)FLATTENER_MAKER.toPlainJavaType((Object)node));
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)flat);
    }
}

