/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceTestHelper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.SimpleSequence;
import org.junit.Assert;
import org.junit.Test;

public class SimpleSequenceTest {
    @Test
    public void testSanity() throws Exception {
        List<Integer> vals = Arrays.asList(1, 2, 3, 4, 5);
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.simple(vals), vals);
    }

    @Test
    public void testNothing() throws Exception {
        List<Integer> vals = Collections.emptyList();
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.simple(vals), vals);
    }

    @Test
    public void testGetIterable() {
        List<Integer> vals = Collections.singletonList(1);
        Assert.assertSame(vals, (Object)((SimpleSequence)Sequences.simple(vals)).getIterable());
    }

    @Test
    public void testToList() {
        List<Integer> vals = Arrays.asList(1, 2);
        Assert.assertEquals(vals, (Object)Sequences.simple(vals).toList());
    }
}

