/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.java.util.common.guava.ExplodingSequence;
import org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceTestHelper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.TestSequence;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class MergeSequenceTest {
    @Test
    public void testSanity() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(2, 8), TestSequence.create(4, 6, 8)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testWorksWhenBeginningOutOfOrder() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(2, 8), TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(4, 6, 8)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testMergeEmpties() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(new Integer[0]), TestSequence.create(2, 8), TestSequence.create(4, 6, 8)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testMergeEmpties1() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(new Integer[0]), TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(2, 8), TestSequence.create(4, 6, 8)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testMergeEmpties2() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 7, 9), TestSequence.create(2, 8), TestSequence.create(new Integer[0]), TestSequence.create(4, 6, 8), TestSequence.create(new Integer[0])});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testScrewsUpOnOutOfOrder() throws Exception {
        ArrayList testSeqs = Lists.newArrayList((Object[])new TestSequence[]{TestSequence.create(1, 3, 5, 4, 7, 9), TestSequence.create(2, 8), TestSequence.create(4, 6)});
        MergeSequence seq = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)testSeqs));
        SequenceTestHelper.testAll((Sequence<Integer>)seq, Arrays.asList(1, 2, 3, 4, 5, 4, 6, 7, 8, 9));
        for (TestSequence sequence : testSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }

    @Test
    public void testHierarchicalMerge() throws Exception {
        MergeSequence seq1 = new MergeSequence(Ordering.natural(), Sequences.simple(Collections.singletonList(TestSequence.create(1))));
        MergeSequence finalMerged = new MergeSequence(Ordering.natural(), Sequences.simple(Collections.singletonList(seq1)));
        SequenceTestHelper.testAll((Sequence<Integer>)finalMerged, Collections.singletonList(1));
    }

    @Test
    public void testMergeOne() throws Exception {
        MergeSequence mergeOne = new MergeSequence(Ordering.natural(), Sequences.simple(Collections.singletonList(TestSequence.create(1))));
        SequenceTestHelper.testAll((Sequence<Integer>)mergeOne, Collections.singletonList(1));
    }

    @Test
    public void testTwoExplodingOnGetSequences() {
        ExplodingSequence bomb1 = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)2)), true, false);
        ExplodingSequence bomb2 = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)2)), true, false);
        MergeSequence mergeSequence = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)ImmutableList.of((Object)bomb1, (Object)bomb2)));
        try {
            mergeSequence.toYielder(null, (YieldingAccumulator)new YieldingAccumulator<Integer, Integer>(){

                public Integer accumulate(Integer accumulated, Integer in) {
                    return in;
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"get")));
        }
        Assert.assertEquals((String)"Closes resources (1)", (long)1L, (long)bomb1.getCloseCount());
        Assert.assertEquals((String)"Closes resources (2)", (long)1L, (long)bomb2.getCloseCount());
    }

    @Test
    public void testTwoExplodingOnCloseSequences() {
        ExplodingSequence bomb1 = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)2)), false, true);
        ExplodingSequence bomb2 = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)2)), false, true);
        MergeSequence mergeSequence = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)ImmutableList.of((Object)bomb1, (Object)bomb2)));
        try {
            mergeSequence.toYielder(null, (YieldingAccumulator)new YieldingAccumulator<Integer, Integer>(){

                public Integer accumulate(Integer accumulated, Integer in) {
                    if (in > 1) {
                        throw new RuntimeException("boom");
                    }
                    return in;
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"boom")));
        }
        Assert.assertEquals((String)"Closes resources (1)", (long)1L, (long)bomb1.getCloseCount());
        Assert.assertEquals((String)"Closes resources (2)", (long)1L, (long)bomb2.getCloseCount());
    }

    @Test
    public void testOneEmptyOneExplodingSequence() {
        ExplodingSequence bomb = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)2)), false, true);
        MergeSequence mergeSequence = new MergeSequence(Ordering.natural(), Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.empty(), (Object)bomb)));
        try {
            mergeSequence.toYielder(null, (YieldingAccumulator)new YieldingAccumulator<Integer, Integer>(){

                public Integer accumulate(Integer accumulated, Integer in) {
                    if (in > 1) {
                        throw new RuntimeException("boom");
                    }
                    return in;
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"boom")));
        }
        Assert.assertEquals((String)"Closes resources", (long)1L, (long)bomb.getCloseCount());
    }
}

