/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Comparators;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class ComparatorsTest {
    @Test
    public void testIntervalsByStartThenEnd() {
        Comparator comp = Comparators.intervalsByStartThenEnd();
        Assert.assertEquals((long)0L, (long)comp.compare(Intervals.of((String)"P1d/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-03-31/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-03-31/2011-04-02")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04")));
        Object[] intervals = new Interval[]{Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-02/2011-04-04"), Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06")};
        Arrays.sort(intervals, comp);
        Assert.assertArrayEquals((Object[])new Interval[]{Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06"), Intervals.of((String)"2011-04-02/2011-04-04")}, (Object[])intervals);
    }

    @Test
    public void testIntervalsByEndThenStart() {
        Comparator comp = Comparators.intervalsByEndThenStart();
        Assert.assertEquals((long)0L, (long)comp.compare(Intervals.of((String)"P1d/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-01")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-03-31/2011-04-03")));
        Object[] intervals = new Interval[]{Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-02/2011-04-04"), Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06")};
        Arrays.sort(intervals, comp);
        Assert.assertArrayEquals((Object[])new Interval[]{Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-02/2011-04-04")}, (Object[])intervals);
    }

    @Test
    public void testAlwaysFirst() {
        Ordering comparator = Comparators.alwaysFirst((Object)25);
        Assert.assertEquals((long)0L, (long)comparator.compare(25, 25));
        Assert.assertEquals((long)-1L, (long)comparator.compare(25, 1000));
        Assert.assertEquals((long)1L, (long)comparator.compare(1000, 25));
        Assert.assertEquals((long)-1L, (long)comparator.compare(25, 1));
        Assert.assertEquals((long)1L, (long)comparator.compare(1, 25));
        Assert.assertEquals((long)0L, (long)comparator.compare(10, 12));
        Object[] array = new Integer[]{25, 0, 1, 25, -10, 100, 31, 77, 89, 25};
        Arrays.sort(array, comparator);
        Assert.assertArrayEquals((Object[])new Integer[]{25, 25, 25, 0, 1, -10, 100, 31, 77, 89}, (Object[])array);
    }
}

