/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class JacksonExtremeDoubleValuesSerdeTest {
    @Test
    public void testExtremeDoubleValuesSerde() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        for (double value : new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}) {
            String serialized = objectMapper.writeValueAsString((Object)value);
            Assert.assertEquals((Object)new Double(value), (Object)objectMapper.readValue(serialized, Double.class));
        }
        String negativeInfinityString = objectMapper.writeValueAsString((Object)Double.NaN);
        Assert.assertTrue((boolean)((Double)objectMapper.readValue(negativeInfinityString, Double.class)).isNaN());
    }
}

