/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.junit.Assert;
import org.junit.Test;

public class DruidSecondaryModuleTest {
    private static final String PROPERTY_NAME = "druid.injected.val";
    private static final String PROPERTY_VALUE = "this is the legit val";

    private static Injector makeInjectorWithProperties(Properties props) {
        return Guice.createInjector((Iterable)ImmutableList.of((Object)new DruidGuiceExtensions(), binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bind(JsonConfigurator.class).in(LazySingleton.class);
            binder.bind(Properties.class).toInstance((Object)props);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.injected", InjectedParameter.class);
        }));
    }

    private static ObjectMapper makeObjectMapper(Injector injector) {
        ObjectMapper mapper = new ObjectMapper();
        DruidSecondaryModule.setupJackson((Injector)injector, (ObjectMapper)mapper);
        return mapper;
    }

    private static class InjectedParameter {
        @JsonProperty
        private String val;

        private InjectedParameter() {
        }
    }

    public static class ClassOfMultipleJsonCreatorsTest {
        @Test
        public void testDeserializeUsingMultiArgumentsConstructor() throws JsonProcessingException {
            Properties props = new Properties();
            props.setProperty(DruidSecondaryModuleTest.PROPERTY_NAME, DruidSecondaryModuleTest.PROPERTY_VALUE);
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "{\"val\": \"this is an injection test\", \"valLen\": 5, \"\": \"nice try\" }";
            ClassOfMultipleJsonCreators object = (ClassOfMultipleJsonCreators)mapper.readValue("{\"val\": \"this is an injection test\", \"valLen\": 5, \"\": \"nice try\" }", ClassOfMultipleJsonCreators.class);
            Assert.assertEquals((Object)"this is an injection test", (Object)object.val);
            Assert.assertEquals((long)5L, (long)object.valLen);
            Assert.assertNotNull((Object)object.injected);
            Assert.assertEquals((Object)DruidSecondaryModuleTest.PROPERTY_VALUE, (Object)object.injected.val);
        }

        @Test
        public void testDeserializeUsingDelegateConstructor() throws JsonProcessingException {
            Properties props = new Properties();
            props.setProperty(DruidSecondaryModuleTest.PROPERTY_NAME, DruidSecondaryModuleTest.PROPERTY_VALUE);
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "\"this is an injection test\"";
            ClassOfMultipleJsonCreators object = (ClassOfMultipleJsonCreators)mapper.readValue("\"this is an injection test\"", ClassOfMultipleJsonCreators.class);
            Assert.assertEquals((Object)"this is an injection test", (Object)object.val);
            Assert.assertEquals((long)object.val.length(), (long)object.valLen);
            Assert.assertNull((Object)object.injected);
        }

        private static class ClassOfMultipleJsonCreators {
            private final String val;
            private final int valLen;
            @Nullable
            private final InjectedParameter injected;

            @JsonCreator
            public ClassOfMultipleJsonCreators(@JsonProperty(value="val") String val, @JsonProperty(value="valLen") int valLen, @JacksonInject @Nullable InjectedParameter injected) {
                this.val = val;
                this.valLen = valLen;
                this.injected = injected;
            }

            @JsonCreator
            public static ClassOfMultipleJsonCreators create(String val) {
                return new ClassOfMultipleJsonCreators(val, val.length(), null);
            }

            @JsonProperty
            public String getVal() {
                return this.val;
            }

            @JsonProperty
            public int getValLen() {
                return this.valLen;
            }
        }
    }

    public static class ConstructorWithoutJacksonInjectTest {
        @Test
        public void testInjectionWithEmptyPropertyName() throws JsonProcessingException {
            Properties props = new Properties();
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "[\"this is\", \"an injection test\"]";
            ClassWithConstructorOfEmptyName object = (ClassWithConstructorOfEmptyName)mapper.readValue("[\"this is\", \"an injection test\"]", ClassWithConstructorOfEmptyName.class);
            Assert.assertEquals((Object)ImmutableList.of((Object)"this is", (Object)"an injection test"), object.getTest());
        }

        @Test
        public void testInjectEmptyListWithEmptyPropertyName() throws JsonProcessingException {
            Properties props = new Properties();
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "[]";
            ClassWithConstructorOfEmptyName object = (ClassWithConstructorOfEmptyName)mapper.readValue("[]", ClassWithConstructorOfEmptyName.class);
            Assert.assertEquals((Object)ImmutableList.of(), object.getTest());
        }

        @Test
        public void testInjectClassWithFactoryMethodOfEmptyPropertyName() throws JsonProcessingException {
            Properties props = new Properties();
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "[\"this is\", \"an injection test\"]";
            ClassWithFactoryMethodOfEmptyName object = (ClassWithFactoryMethodOfEmptyName)mapper.readValue("[\"this is\", \"an injection test\"]", ClassWithFactoryMethodOfEmptyName.class);
            Assert.assertEquals((Object)ImmutableList.of((Object)"this is", (Object)"an injection test"), object.getTest());
        }

        @Test
        public void testInjectEmptyListToClassWithFactoryMethodOfEmptyPropertyName() throws JsonProcessingException {
            Properties props = new Properties();
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "[]";
            ClassWithFactoryMethodOfEmptyName object = (ClassWithFactoryMethodOfEmptyName)mapper.readValue("[]", ClassWithFactoryMethodOfEmptyName.class);
            Assert.assertEquals((Object)ImmutableList.of(), object.getTest());
        }

        @Test
        public void testInjectClassOfEmptyConstructor() throws JsonProcessingException {
            Properties props = new Properties();
            props.setProperty(DruidSecondaryModuleTest.PROPERTY_NAME, DruidSecondaryModuleTest.PROPERTY_VALUE);
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "{}";
            ClassOfEmptyConstructor object = (ClassOfEmptyConstructor)mapper.readValue("{}", ClassOfEmptyConstructor.class);
            Assert.assertEquals((Object)"empty constructor", (Object)object.val);
        }

        private static class ClassWithConstructorOfEmptyName {
            private final List<String> test;

            @JsonCreator
            public ClassWithConstructorOfEmptyName(List<String> test) {
                this.test = test;
            }

            @JsonValue
            public List<String> getTest() {
                return this.test;
            }
        }

        private static class ClassWithFactoryMethodOfEmptyName {
            private final List<String> test;

            @JsonCreator
            public static ClassWithFactoryMethodOfEmptyName create(List<String> test) {
                return new ClassWithFactoryMethodOfEmptyName(test);
            }

            private ClassWithFactoryMethodOfEmptyName(List<String> test) {
                this.test = test;
            }

            @JsonValue
            public List<String> getTest() {
                return this.test;
            }
        }

        private static class ClassOfEmptyConstructor {
            private final String val;

            @JsonCreator
            public ClassOfEmptyConstructor() {
                this.val = "empty constructor";
            }
        }
    }

    public static class ConstructorWithJacksonInjectTest {
        @Test
        public void testInjectWithAnEmptyPropertyNotOverrideInjection() throws JsonProcessingException {
            Properties props = new Properties();
            props.setProperty(DruidSecondaryModuleTest.PROPERTY_NAME, DruidSecondaryModuleTest.PROPERTY_VALUE);
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "{\"test\": \"this is an injection test\", \"\": \"nice try\" }";
            ClassWithJacksonInject object = (ClassWithJacksonInject)mapper.readValue("{\"test\": \"this is an injection test\", \"\": \"nice try\" }", ClassWithJacksonInject.class);
            Assert.assertEquals((Object)"this is an injection test", (Object)object.test);
            Assert.assertEquals((Object)DruidSecondaryModuleTest.PROPERTY_VALUE, (Object)object.injected.val);
        }

        @Test
        public void testInjectNormal() throws JsonProcessingException {
            Properties props = new Properties();
            props.setProperty(DruidSecondaryModuleTest.PROPERTY_NAME, DruidSecondaryModuleTest.PROPERTY_VALUE);
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "{\"test\": \"this is an injection test\" }";
            ClassWithJacksonInject object = (ClassWithJacksonInject)mapper.readValue("{\"test\": \"this is an injection test\" }", ClassWithJacksonInject.class);
            Assert.assertEquals((Object)"this is an injection test", (Object)object.test);
            Assert.assertEquals((Object)DruidSecondaryModuleTest.PROPERTY_VALUE, (Object)object.injected.val);
        }

        @Test
        public void testInjectClassWithEmptyProperty() throws JsonProcessingException {
            Properties props = new Properties();
            props.setProperty(DruidSecondaryModuleTest.PROPERTY_NAME, DruidSecondaryModuleTest.PROPERTY_VALUE);
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "{\"test\": \"this is an injection test\", \"\": \"nice try\" }";
            ClassWithEmptyProperty object = (ClassWithEmptyProperty)mapper.readValue("{\"test\": \"this is an injection test\", \"\": \"nice try\" }", ClassWithEmptyProperty.class);
            Assert.assertEquals((Object)"this is an injection test", (Object)object.test);
            Assert.assertEquals((Object)DruidSecondaryModuleTest.PROPERTY_VALUE, (Object)object.injected.val);
        }

        @Test
        public void testInjectNormalWithEmptyKeysInMap() throws JsonProcessingException {
            Properties props = new Properties();
            props.setProperty(DruidSecondaryModuleTest.PROPERTY_NAME, DruidSecondaryModuleTest.PROPERTY_VALUE);
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "{\n  \"map1\" : {\n    \"foo\" : \"bar\",\n    \"\" : \"empty\"\n  },\n  \"map2\" : {\n    \"foo\" : {\n      \"test\" : \"value1\"\n    },\n    \"\" : {\n      \"test\" : \"value2\"\n    }\n  }\n}";
            ClassWithMapAndJacksonInject object = new ClassWithMapAndJacksonInject((Map<String, String>)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"", (Object)"empty"), (Map<String, ClassWithJacksonInject>)ImmutableMap.of((Object)"foo", (Object)new ClassWithJacksonInject("value1", (InjectedParameter)injector.getInstance(InjectedParameter.class)), (Object)"", (Object)new ClassWithJacksonInject("value2", (InjectedParameter)injector.getInstance(InjectedParameter.class))));
            String jsonWritten = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)object);
            Assert.assertEquals((Object)"{\n  \"map1\" : {\n    \"foo\" : \"bar\",\n    \"\" : \"empty\"\n  },\n  \"map2\" : {\n    \"foo\" : {\n      \"test\" : \"value1\"\n    },\n    \"\" : {\n      \"test\" : \"value2\"\n    }\n  }\n}", (Object)jsonWritten);
            ClassWithMapAndJacksonInject objectRead = (ClassWithMapAndJacksonInject)mapper.readValue("{\n  \"map1\" : {\n    \"foo\" : \"bar\",\n    \"\" : \"empty\"\n  },\n  \"map2\" : {\n    \"foo\" : {\n      \"test\" : \"value1\"\n    },\n    \"\" : {\n      \"test\" : \"value2\"\n    }\n  }\n}", ClassWithMapAndJacksonInject.class);
            Assert.assertEquals((Object)object, (Object)objectRead);
            Assert.assertEquals((Object)"empty", (Object)objectRead.getStringStringMap().get(""));
        }

        @Test
        public void testInjectNormalWithEmptyKeysAndInjectClass() throws JsonProcessingException {
            Properties props = new Properties();
            props.setProperty(DruidSecondaryModuleTest.PROPERTY_NAME, DruidSecondaryModuleTest.PROPERTY_VALUE);
            Injector injector = DruidSecondaryModuleTest.makeInjectorWithProperties(props);
            ObjectMapper mapper = DruidSecondaryModuleTest.makeObjectMapper(injector);
            String json = "{\n  \"map1\" : {\n    \"foo\" : \"bar\",\n    \"\" : \"empty\"\n  },\n  \"map2\" : {\n    \"foo\" : {\n      \"test\" : \"value1\",\n      \"\"     : \"nice try\"\n    },\n    \"\" : {\n      \"test\" : \"value2\",\n      \"\"     : \"nice try\"\n    }\n  }\n}";
            String expectedSerializedJson = "{\n  \"map1\" : {\n    \"foo\" : \"bar\",\n    \"\" : \"empty\"\n  },\n  \"map2\" : {\n    \"foo\" : {\n      \"test\" : \"value1\"\n    },\n    \"\" : {\n      \"test\" : \"value2\"\n    }\n  }\n}";
            ClassWithMapAndJacksonInject object = new ClassWithMapAndJacksonInject((Map<String, String>)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"", (Object)"empty"), (Map<String, ClassWithJacksonInject>)ImmutableMap.of((Object)"foo", (Object)new ClassWithJacksonInject("value1", (InjectedParameter)injector.getInstance(InjectedParameter.class)), (Object)"", (Object)new ClassWithJacksonInject("value2", (InjectedParameter)injector.getInstance(InjectedParameter.class))));
            String jsonWritten = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)object);
            Assert.assertEquals((Object)"{\n  \"map1\" : {\n    \"foo\" : \"bar\",\n    \"\" : \"empty\"\n  },\n  \"map2\" : {\n    \"foo\" : {\n      \"test\" : \"value1\"\n    },\n    \"\" : {\n      \"test\" : \"value2\"\n    }\n  }\n}", (Object)jsonWritten);
            ClassWithMapAndJacksonInject objectRead = (ClassWithMapAndJacksonInject)mapper.readValue("{\n  \"map1\" : {\n    \"foo\" : \"bar\",\n    \"\" : \"empty\"\n  },\n  \"map2\" : {\n    \"foo\" : {\n      \"test\" : \"value1\",\n      \"\"     : \"nice try\"\n    },\n    \"\" : {\n      \"test\" : \"value2\",\n      \"\"     : \"nice try\"\n    }\n  }\n}", ClassWithMapAndJacksonInject.class);
            Assert.assertEquals((Object)object, (Object)objectRead);
            Assert.assertEquals((Object)"empty", (Object)objectRead.getStringStringMap().get(""));
        }

        private static class ClassWithJacksonInject {
            private final String test;
            private InjectedParameter injected;

            @JsonCreator
            public ClassWithJacksonInject(@JsonProperty(value="test") String test, @JacksonInject InjectedParameter injected) {
                this.test = test;
                this.injected = injected;
            }

            @JsonProperty(value="test")
            public String getTest() {
                return this.test;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ClassWithJacksonInject that = (ClassWithJacksonInject)o;
                return Objects.equals(this.test, that.test) && Objects.equals(this.injected.val, that.injected.val);
            }

            public int hashCode() {
                return Objects.hash(this.test, this.injected.val);
            }
        }

        private static class ClassWithEmptyProperty {
            private final String test;
            private InjectedParameter injected;

            @JsonCreator
            public ClassWithEmptyProperty(@JsonProperty(value="test") String test, @JacksonInject @JsonProperty(value="") InjectedParameter injected) {
                this.test = test;
                this.injected = injected;
            }

            @JsonProperty
            public String getTest() {
                return this.test;
            }
        }

        private static class ClassWithMapAndJacksonInject {
            private final Map<String, String> stringStringMap;
            private final Map<String, ClassWithJacksonInject> stringJacksonInjectMap;

            @JsonCreator
            public ClassWithMapAndJacksonInject(@JsonProperty(value="map1") Map<String, String> stringStringMap, @JsonProperty(value="map2") Map<String, ClassWithJacksonInject> stringJacksonInjectMap) {
                this.stringStringMap = stringStringMap;
                this.stringJacksonInjectMap = stringJacksonInjectMap;
            }

            @JsonProperty(value="map1")
            public Map<String, String> getStringStringMap() {
                return this.stringStringMap;
            }

            @JsonProperty(value="map2")
            public Map<String, ClassWithJacksonInject> getStringJacksonInjectMap() {
                return this.stringJacksonInjectMap;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ClassWithMapAndJacksonInject that = (ClassWithMapAndJacksonInject)o;
                return Objects.equals(this.stringStringMap, that.stringStringMap) && Objects.equals(this.stringJacksonInjectMap, that.stringJacksonInjectMap);
            }

            public int hashCode() {
                return Objects.hash(this.stringStringMap, this.stringJacksonInjectMap);
            }
        }
    }
}

