/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.guice.ConditionalMultibind;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConditionalMultibindTest {
    private static final String ANIMAL_TYPE = "animal.type";
    private Properties props;

    @Before
    public void setUp() {
        this.props = new Properties();
    }

    @Test
    public void testMultiConditionalBind_cat() {
        this.props.setProperty(ANIMAL_TYPE, "cat");
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"cat"), Cat.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"dog"), Dog.class);
            }
        }});
        Set animalSet = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Animal>>(){}));
        Assert.assertEquals((long)1L, (long)animalSet.size());
        Assert.assertEquals((Object)animalSet, (Object)ImmutableSet.of((Object)new Cat()));
    }

    @Test
    public void testMultiConditionalBind_cat_dog() {
        this.props.setProperty(ANIMAL_TYPE, "pets");
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Cat.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Dog.class);
            }
        }});
        Set animalSet = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Animal>>(){}));
        Assert.assertEquals((long)2L, (long)animalSet.size());
        Assert.assertEquals((Object)animalSet, (Object)ImmutableSet.of((Object)new Cat(), (Object)new Dog()));
    }

    @Test
    public void testMultiConditionalBind_cat_dog_non_continuous_syntax() {
        this.props.setProperty(ANIMAL_TYPE, "pets");
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Cat.class);
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Dog.class);
            }
        }});
        Set animalSet = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Animal>>(){}));
        Assert.assertEquals((long)2L, (long)animalSet.size());
        Assert.assertEquals((Object)animalSet, (Object)ImmutableSet.of((Object)new Cat(), (Object)new Dog()));
    }

    @Test
    public void testMultiConditionalBind_multiple_modules() {
        this.props.setProperty(ANIMAL_TYPE, "pets");
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Cat.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Dog.class);
            }
        }, new Module(){

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"not_match"), Tiger.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Fish.class);
            }
        }});
        Set animalSet = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Animal>>(){}));
        Assert.assertEquals((long)3L, (long)animalSet.size());
        Assert.assertEquals((Object)animalSet, (Object)ImmutableSet.of((Object)new Cat(), (Object)new Dog(), (Object)new Fish()));
    }

    @Test
    public void testMultiConditionalBind_multiple_modules_with_annotation() {
        this.props.setProperty(ANIMAL_TYPE, "pets");
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class, SanDiego.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Cat.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Dog.class);
            }
        }, new Module(){

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class, SanDiego.class).addBinding((Object)new Bird()).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Tiger.class);
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class, SanJose.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Fish.class);
            }
        }});
        Set animalSet_1 = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Animal>>(){}, SanDiego.class));
        Assert.assertEquals((long)4L, (long)animalSet_1.size());
        Assert.assertEquals((Object)animalSet_1, (Object)ImmutableSet.of((Object)new Bird(), (Object)new Cat(), (Object)new Dog(), (Object)new Tiger()));
        Set animalSet_2 = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Animal>>(){}, SanJose.class));
        Assert.assertEquals((long)1L, (long)animalSet_2.size());
        Assert.assertEquals((Object)animalSet_2, (Object)ImmutableSet.of((Object)new Fish()));
    }

    @Test
    public void testMultiConditionalBind_inject() {
        this.props.setProperty(ANIMAL_TYPE, "pets");
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class).addBinding(Bird.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Cat.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Dog.class);
            }
        }, new Module(){

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, Animal.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"not_match"), Tiger.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), Fish.class);
            }
        }});
        PetShotAvails shop = new PetShotAvails();
        injector.injectMembers((Object)shop);
        Assert.assertEquals((long)4L, (long)shop.animals.size());
        Assert.assertEquals(shop.animals, (Object)ImmutableSet.of((Object)new Bird(), (Object)new Cat(), (Object)new Dog(), (Object)new Fish()));
    }

    @Test
    public void testMultiConditionalBind_typeLiteral() {
        this.props.setProperty(ANIMAL_TYPE, "pets");
        ImmutableSet set1 = ImmutableSet.of((Object)new Dog(), (Object)new Tiger());
        ImmutableSet set2 = ImmutableSet.of((Object)new Cat(), (Object)new Fish());
        ImmutableSet set3 = ImmutableSet.of((Object)new Cat());
        HashSet union = new HashSet();
        union.addAll(set1);
        union.addAll(set2);
        Zoo zoo1 = new Zoo(set1);
        Zoo zoo2 = new Zoo();
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){
            final /* synthetic */ Set val$set1;
            final /* synthetic */ Set val$set2;
            final /* synthetic */ Zoo val$zoo1;
            {
                this.val$set1 = set;
                this.val$set2 = set2;
                this.val$zoo1 = zoo;
            }

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, (TypeLiteral)new TypeLiteral<Set<Animal>>(){}).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), (Object)this.val$set1).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), (Object)this.val$set2);
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, (TypeLiteral)new TypeLiteral<Zoo<Animal>>(){}).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), (Object)this.val$zoo1);
            }
        }, new Module(){
            final /* synthetic */ Set val$set3;
            final /* synthetic */ Set val$union;
            {
                this.val$set3 = set;
                this.val$union = set2;
            }

            public void configure(Binder binder) {
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, (TypeLiteral)new TypeLiteral<Set<Animal>>(){}).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), (Object)this.val$set3);
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, (TypeLiteral)new TypeLiteral<Set<Animal>>(){}, SanDiego.class).addConditionBinding(ConditionalMultibindTest.ANIMAL_TYPE, Predicates.equalTo((Object)"pets"), (Object)this.val$union);
                ConditionalMultibind.create((Properties)ConditionalMultibindTest.this.props, (Binder)binder, (TypeLiteral)new TypeLiteral<Zoo<Animal>>(){}).addBinding((TypeLiteral)new TypeLiteral<Zoo<Animal>>(){});
            }
        }});
        Set actualAnimalSet = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Set<Animal>>>(){}));
        Assert.assertEquals((long)3L, (long)actualAnimalSet.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)set1, (Object)set2, (Object)set3), (Object)actualAnimalSet);
        actualAnimalSet = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Set<Animal>>>(){}, SanDiego.class));
        Assert.assertEquals((long)1L, (long)actualAnimalSet.size());
        Assert.assertEquals((Object)ImmutableSet.of(union), (Object)actualAnimalSet);
        Set actualZooSet = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Zoo<Animal>>>(){}));
        Assert.assertEquals((long)2L, (long)actualZooSet.size());
        Assert.assertEquals((Object)ImmutableSet.of(zoo1, zoo2), (Object)actualZooSet);
    }

    static class Cat
    extends Animal {
        Cat() {
            super("cat");
        }
    }

    static class Dog
    extends Animal {
        Dog() {
            super("dog");
        }
    }

    static class Fish
    extends Animal {
        Fish() {
            super("fish");
        }
    }

    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface SanDiego {
    }

    static class Bird
    extends Animal {
        Bird() {
            super("bird");
        }
    }

    static class Tiger
    extends Animal {
        Tiger() {
            super("tiger");
        }
    }

    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface SanJose {
    }

    static class PetShotAvails {
        @Inject
        Set<Animal> animals;

        PetShotAvails() {
        }
    }

    static class Zoo<T> {
        Set<T> animals;

        public Zoo() {
            this.animals = new HashSet<T>();
        }

        public Zoo(Set<T> animals) {
            this.animals = animals;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Zoo zoo = (Zoo)o;
            return this.animals != null ? this.animals.equals(zoo.animals) : zoo.animals == null;
        }

        public int hashCode() {
            return this.animals != null ? this.animals.hashCode() : 0;
        }

        public String toString() {
            return "Zoo{animals=" + String.valueOf(this.animals) + "}";
        }
    }

    static abstract class Animal {
        private final String type;

        Animal(String type) {
            this.type = type;
        }

        public String toString() {
            return "Animal{type='" + this.type + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Animal animal = (Animal)o;
            return this.type != null ? this.type.equals(animal.type) : animal.type == null;
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }
    }
}

