/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.apache.druid.segment.DimensionHandlerProvider;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BuiltInTypesModuleTest {
    @Nullable
    private static DimensionHandlerProvider DEFAULT_HANDLER_PROVIDER;

    @BeforeClass
    public static void setup() {
        DEFAULT_HANDLER_PROVIDER = (DimensionHandlerProvider)DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.get("json");
        DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.remove("json");
    }

    @AfterClass
    public static void teardown() {
        if (DEFAULT_HANDLER_PROVIDER == null) {
            DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.remove("json");
        } else {
            DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.put("json", DEFAULT_HANDLER_PROVIDER);
        }
    }

    @Test
    public void testDefaults() {
        DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.remove("json");
        Properties props = new Properties();
        Injector gadget = this.makeInjector(props);
        gadget.getInstance(BuiltInTypesModule.SideEffectRegisterer.class);
        DimensionHandlerProvider provider = (DimensionHandlerProvider)DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.get("json");
        Assert.assertTrue((boolean)(provider.get("test") instanceof NestedCommonFormatColumnHandler));
        Assert.assertEquals((Object)DimensionSchema.MultiValueHandling.SORTED_ARRAY, (Object)BuiltInTypesModule.getStringMultiValueHandlingMode());
    }

    @Test
    public void testOverride() {
        DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.remove("json");
        Properties props = new Properties();
        props.setProperty("druid.indexing.formats.stringMultiValueHandlingMode", "sorted_array");
        Injector gadget = this.makeInjector(props);
        gadget.getInstance(BuiltInTypesModule.SideEffectRegisterer.class);
        DimensionHandlerProvider provider = (DimensionHandlerProvider)DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.get("json");
        Assert.assertEquals((Object)DimensionSchema.MultiValueHandling.SORTED_ARRAY, (Object)BuiltInTypesModule.getStringMultiValueHandlingMode());
    }

    @Test
    public void testOverrideMultiValueHandlingModeCaseInsensitive() {
        Properties props = new Properties();
        props.setProperty("druid.indexing.formats.stringMultiValueHandlingMode", "ARRAY");
        Injector gadget = this.makeInjector(props);
        gadget.getInstance(BuiltInTypesModule.SideEffectRegisterer.class);
        Assert.assertEquals((Object)DimensionSchema.MultiValueHandling.ARRAY, (Object)BuiltInTypesModule.getStringMultiValueHandlingMode());
    }

    @Test
    public void testInvalidMultiValueHandlingMode() {
        Properties props = new Properties();
        props.setProperty("druid.indexing.formats.stringMultiValueHandlingMode", "boo");
        Injector gadget = this.makeInjector(props);
        Exception exception = (Exception)Assert.assertThrows(Exception.class, () -> gadget.getInstance(BuiltInTypesModule.SideEffectRegisterer.class));
        Assert.assertTrue((boolean)exception.getMessage().contains("Invalid value[boo] specified for 'druid.indexing.formats.stringMultiValueHandlingMode'. Supported values are [[SORTED_ARRAY, SORTED_SET, ARRAY]]."));
    }

    private Injector makeInjector(Properties props) {
        StartupInjectorBuilder bob = new StartupInjectorBuilder().forTests().withProperties(props);
        bob.addAll((List)ImmutableList.of(binder -> JsonConfigProvider.bind((Binder)binder, (String)"druid.indexing.formats", DefaultColumnFormatConfig.class), (Object)new BuiltInTypesModule()));
        return bob.build();
    }
}

