/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.granularity;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.DurationGranularity;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.junit.Assert;
import org.junit.Test;

public class QueryGranularityTest
extends InitializedNullHandlingTest {
    @Test
    public void testIterableNone() {
        Iterator iterator = Granularities.NONE.getIterable(Intervals.utc((long)0L, (long)1000L)).iterator();
        int count = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((long)count, (long)((Interval)iterator.next()).getStartMillis());
            ++count;
        }
    }

    @Test
    public void testIterableMinuteSimple() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T09:38:00.000Z"), DateTimes.of((String)"2011-01-01T09:39:00.000Z"), DateTimes.of((String)"2011-01-01T09:40:00.000Z")}), Granularities.MINUTE.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Minutes.THREE))));
    }

    @Test
    public void testIterableMinuteComplex() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:02.992Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T09:38:00.000Z"), DateTimes.of((String)"2011-01-01T09:39:00.000Z"), DateTimes.of((String)"2011-01-01T09:40:00.000Z"), DateTimes.of((String)"2011-01-01T09:41:00.000Z")}), Granularities.MINUTE.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Minutes.THREE))));
    }

    @Test
    public void testIterable15MinuteSimple() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:30:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T09:30:00.000Z"), DateTimes.of((String)"2011-01-01T09:45:00.000Z"), DateTimes.of((String)"2011-01-01T10:00:00.000Z")}), Granularities.FIFTEEN_MINUTE.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Minutes.minutes((int)45)))));
    }

    @Test
    public void testIterable15MinuteComplex() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:02.992Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T09:30:00.000Z"), DateTimes.of((String)"2011-01-01T09:45:00.000Z"), DateTimes.of((String)"2011-01-01T10:00:00.000Z"), DateTimes.of((String)"2011-01-01T10:15:00.000Z")}), Granularities.FIFTEEN_MINUTE.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Minutes.minutes((int)45)))));
    }

    @Test
    public void testIterableHourSimple() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:00:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T09:00:00.000Z"), DateTimes.of((String)"2011-01-01T10:00:00.000Z"), DateTimes.of((String)"2011-01-01T11:00:00.000Z")}), Granularities.HOUR.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Hours.hours((int)3)))));
    }

    @Test
    public void testIterableHourComplex() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:02.992Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T09:00:00.000Z"), DateTimes.of((String)"2011-01-01T10:00:00.000Z"), DateTimes.of((String)"2011-01-01T11:00:00.000Z"), DateTimes.of((String)"2011-01-01T12:00:00.000Z")}), Granularities.HOUR.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Hours.hours((int)3)))));
    }

    @Test
    public void testIterableDaySimple() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T00:00:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T00:00:00.000Z"), DateTimes.of((String)"2011-01-02T00:00:00.000Z"), DateTimes.of((String)"2011-01-03T00:00:00.000Z")}), Granularities.DAY.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Days.days((int)3)))));
    }

    @Test
    public void testIterableDayComplex() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:02.992Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T00:00:00.000Z"), DateTimes.of((String)"2011-01-02T00:00:00.000Z"), DateTimes.of((String)"2011-01-03T00:00:00.000Z"), DateTimes.of((String)"2011-01-04T00:00:00.000Z")}), Granularities.DAY.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Days.days((int)3)))));
    }

    @Test
    public void testIterableWeekSimple() {
        DateTime baseTime = DateTimes.of((String)"2011-01-03T00:00:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-03T00:00:00.000Z"), DateTimes.of((String)"2011-01-10T00:00:00.000Z"), DateTimes.of((String)"2011-01-17T00:00:00.000Z")}), Granularities.WEEK.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Weeks.THREE))));
    }

    @Test
    public void testIterableWeekComplex() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:02.992Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2010-12-27T00:00:00.000Z"), DateTimes.of((String)"2011-01-03T00:00:00.000Z"), DateTimes.of((String)"2011-01-10T00:00:00.000Z"), DateTimes.of((String)"2011-01-17T00:00:00.000Z")}), Granularities.WEEK.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Weeks.THREE))));
    }

    @Test
    public void testIterableMonthSimple() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T00:00:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T00:00:00.000Z"), DateTimes.of((String)"2011-02-01T00:00:00.000Z"), DateTimes.of((String)"2011-03-01T00:00:00.000Z")}), Granularities.MONTH.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Months.THREE))));
    }

    @Test
    public void testIterableMonthComplex() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T00:00:00.000Z"), DateTimes.of((String)"2011-02-01T00:00:00.000Z"), DateTimes.of((String)"2011-03-01T00:00:00.000Z"), DateTimes.of((String)"2011-04-01T00:00:00.000Z")}), Granularities.MONTH.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Months.THREE))));
    }

    @Test
    public void testIterableQuarterSimple() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T00:00:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T00:00:00.000Z"), DateTimes.of((String)"2011-04-01T00:00:00.000Z"), DateTimes.of((String)"2011-07-01T00:00:00.000Z")}), Granularities.QUARTER.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Months.NINE))));
    }

    @Test
    public void testIterableQuarterComplex() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T00:00:00.000Z"), DateTimes.of((String)"2011-04-01T00:00:00.000Z"), DateTimes.of((String)"2011-07-01T00:00:00.000Z"), DateTimes.of((String)"2011-10-01T00:00:00.000Z")}), Granularities.QUARTER.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Months.NINE))));
    }

    @Test
    public void testIterableYearSimple() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T00:00:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T00:00:00.000Z"), DateTimes.of((String)"2012-01-01T00:00:00.000Z"), DateTimes.of((String)"2013-01-01T00:00:00.000Z")}), Granularities.YEAR.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Years.THREE))));
    }

    @Test
    public void testIterableYearComplex() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:00.000Z");
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2011-01-01T00:00:00.000Z"), DateTimes.of((String)"2012-01-01T00:00:00.000Z"), DateTimes.of((String)"2013-01-01T00:00:00.000Z"), DateTimes.of((String)"2014-01-01T00:00:00.000Z")}), Granularities.YEAR.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Years.THREE))));
    }

    @Test
    public void testPeriodDaylightSaving() {
        DateTimeZone tz = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        DateTime baseTime = new DateTime((Object)"2012-11-04T00:00:00", tz);
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-04T00:00:00.000-07:00", tz), new DateTime((Object)"2012-11-05T00:00:00.000-08:00", tz), new DateTime((Object)"2012-11-06T00:00:00.000-08:00", tz)}), new PeriodGranularity(new Period((Object)"P1D"), null, tz).getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Days.days((int)3)))));
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-04T00:00:00.000-07:00", tz), new DateTime((Object)"2012-11-04T01:00:00.000-07:00", tz), new DateTime((Object)"2012-11-04T01:00:00.000-08:00", tz), new DateTime((Object)"2012-11-04T02:00:00.000-08:00", tz), new DateTime((Object)"2012-11-04T03:00:00.000-08:00", tz)}), new PeriodGranularity(new Period((Object)"PT1H"), null, tz).getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Hours.hours((int)5)))));
        PeriodGranularity hour = new PeriodGranularity(new Period((Object)"PT1H"), null, tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-04T00:00:00.000-07:00", tz), new DateTime((Object)"2012-11-04T01:00:00.000-07:00", tz), new DateTime((Object)"2012-11-04T01:00:00.000-08:00", tz), new DateTime((Object)"2012-11-04T02:00:00.000-08:00", tz), new DateTime((Object)"2012-11-04T03:00:00.000-08:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{hour.bucketStart(DateTimes.of((String)"2012-11-04T00:30:00-07:00")), hour.bucketStart(DateTimes.of((String)"2012-11-04T01:30:00-07:00")), hour.bucketStart(DateTimes.of((String)"2012-11-04T01:30:00-08:00")), hour.bucketStart(DateTimes.of((String)"2012-11-04T02:30:00-08:00")), hour.bucketStart(DateTimes.of((String)"2012-11-04T03:30:00-08:00"))}));
        PeriodGranularity p7days = new PeriodGranularity(new Period((Object)"P7D"), DateTimes.of((String)"2022-03-24T02:35:00.000-07:00"), tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2022-03-03T02:35:00.000-08:00", tz), new DateTime((Object)"2022-03-10T02:35:00.000-08:00", tz), new DateTime((Object)"2022-03-24T02:35:00.000-07:00", tz), new DateTime((Object)"2022-03-31T02:35:00.000-07:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{p7days.bucketStart(DateTimes.of((String)"2022-03-04T02:35:00.000-08:00")), p7days.bucketStart(DateTimes.of((String)"2022-03-16T02:35:00.000-07:00")), p7days.bucketStart(DateTimes.of((String)"2022-03-26T02:35:00.000-07:00")), p7days.bucketStart(DateTimes.of((String)"2022-03-31T03:35:00.000-07:00"))}));
        PeriodGranularity week = new PeriodGranularity(new Period((Object)"P1W"), DateTimes.of((String)"2022-03-24T02:35:00.000-07:00"), tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2022-03-03T02:35:00.000-08:00", tz), new DateTime((Object)"2022-03-10T02:35:00.000-08:00", tz), new DateTime((Object)"2022-03-24T02:35:00.000-07:00", tz), new DateTime((Object)"2022-03-31T02:35:00.000-07:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{week.bucketStart(DateTimes.of((String)"2022-03-04T02:35:00.000-08:00")), week.bucketStart(DateTimes.of((String)"2022-03-16T02:35:00.000-07:00")), week.bucketStart(DateTimes.of((String)"2022-03-26T02:35:00.000-07:00")), week.bucketStart(DateTimes.of((String)"2022-03-31T03:35:00.000-07:00"))}));
        PeriodGranularity month = new PeriodGranularity(new Period((Object)"P1M"), DateTimes.of((String)"2022-03-24T02:35:00.000-07:00"), tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2022-02-24T02:35:00.000-08:00", tz), new DateTime((Object)"2022-02-24T02:35:00.000-08:00", tz), new DateTime((Object)"2022-03-24T02:35:00.000-07:00", tz), new DateTime((Object)"2022-03-24T02:35:00.000-07:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{month.bucketStart(DateTimes.of((String)"2022-03-04T02:35:00.000-08:00")), month.bucketStart(DateTimes.of((String)"2022-03-16T02:35:00.000-07:00")), month.bucketStart(DateTimes.of((String)"2022-03-26T02:35:00.000-07:00")), month.bucketStart(DateTimes.of((String)"2022-03-31T03:35:00.000-07:00"))}));
        PeriodGranularity year = new PeriodGranularity(new Period((Object)"P1Y"), DateTimes.of((String)"2022-03-24T02:35:00.000-07:00"), tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2021-03-24T02:35:00.000-07:00", tz), new DateTime((Object)"2021-03-24T02:35:00.000-07:00", tz), new DateTime((Object)"2022-03-24T02:35:00.000-07:00", tz), new DateTime((Object)"2022-03-24T02:35:00.000-07:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{year.bucketStart(DateTimes.of((String)"2022-03-04T02:35:00.000-08:00")), year.bucketStart(DateTimes.of((String)"2022-03-16T02:35:00.000-07:00")), year.bucketStart(DateTimes.of((String)"2022-03-26T02:35:00.000-07:00")), year.bucketStart(DateTimes.of((String)"2022-03-31T03:35:00.000-07:00"))}));
    }

    @Test
    public void testIterableMonth() {
        DateTimeZone tz = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        DateTime baseTime = new DateTime((Object)"2012-11-03T10:00:00", tz);
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-01T00:00:00.000-07:00", tz), new DateTime((Object)"2012-12-01T00:00:00.000-08:00", tz), new DateTime((Object)"2013-01-01T00:00:00.000-08:00", tz), new DateTime((Object)"2013-02-01T00:00:00.000-08:00", tz)}), new PeriodGranularity(new Period((Object)"P1M"), null, tz).getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Months.months((int)3)))));
    }

    @Test
    public void testIterableWeek() {
        DateTimeZone tz = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        DateTime baseTime = new DateTime((Object)"2012-11-03T10:00:00", tz);
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-10-29T00:00:00.000-07:00", tz), new DateTime((Object)"2012-11-05T00:00:00.000-08:00", tz), new DateTime((Object)"2012-11-12T00:00:00.000-08:00", tz), new DateTime((Object)"2012-11-19T00:00:00.000-08:00", tz)}), new PeriodGranularity(new Period((Object)"P1W"), null, tz).getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Weeks.weeks((int)3)))));
        this.assertSameInterval(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-03T10:00:00.000-07:00", tz), new DateTime((Object)"2012-11-10T10:00:00.000-08:00", tz), new DateTime((Object)"2012-11-17T10:00:00.000-08:00", tz)}), new PeriodGranularity(new Period((Object)"P1W"), baseTime, tz).getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Weeks.weeks((int)3)))));
    }

    @Test
    public void testPeriodTruncateDays() {
        DateTimeZone tz = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        DateTime origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        PeriodGranularity periodOrigin = new PeriodGranularity(new Period((Object)"P2D"), origin, tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-12-31T05:00:00.000-08:00", tz), new DateTime((Object)"2012-01-02T05:00:00.000-08:00", tz), new DateTime((Object)"2012-01-04T05:00:00.000-08:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{periodOrigin.bucketStart(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-01-02T07:00:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-01-04T07:20:04.123-08:00"))}));
        PeriodGranularity periodNoOrigin = new PeriodGranularity(new Period((Object)"P2D"), null, tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-01-01T00:00:00.000-08:00", tz), new DateTime((Object)"2012-01-01T00:00:00.000-08:00", tz), new DateTime((Object)"2012-01-03T00:00:00.000-08:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{periodNoOrigin.bucketStart(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00")), periodNoOrigin.bucketStart(DateTimes.of((String)"2012-01-02T07:00:04.123-08:00")), periodNoOrigin.bucketStart(DateTimes.of((String)"2012-01-04T07:20:04.123-08:00"))}));
    }

    @Test
    public void testPeriodTruncateMinutes() {
        DateTime origin = DateTimes.of((String)"2012-01-02T00:05:00.000Z");
        PeriodGranularity periodOrigin = new PeriodGranularity(new Period((Object)"PT15M"), origin, null);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2012-01-01T04:50:00.000Z"), DateTimes.of((String)"2012-01-02T07:05:00.000Z"), DateTimes.of((String)"2012-01-04T00:20:00.000Z")}), Lists.newArrayList((Object[])new DateTime[]{periodOrigin.bucketStart(DateTimes.of((String)"2012-01-01T05:00:04.123Z")), periodOrigin.bucketStart(DateTimes.of((String)"2012-01-02T07:08:04.123Z")), periodOrigin.bucketStart(DateTimes.of((String)"2012-01-04T00:20:04.123Z"))}));
        PeriodGranularity periodNoOrigin = new PeriodGranularity(new Period((Object)"PT15M"), null, null);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2012-01-01T05:00:00.000Z"), DateTimes.of((String)"2012-01-02T07:00:00.000Z"), DateTimes.of((String)"2012-01-04T00:15:00.000Z")}), Lists.newArrayList((Object[])new DateTime[]{periodNoOrigin.bucketStart(DateTimes.of((String)"2012-01-01T05:00:04.123Z")), periodNoOrigin.bucketStart(DateTimes.of((String)"2012-01-02T07:00:04.123Z")), periodNoOrigin.bucketStart(DateTimes.of((String)"2012-01-04T00:20:04.123Z"))}));
    }

    @Test
    public void testCompoundPeriodTruncate() {
        DateTimeZone tz = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        DateTime origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        PeriodGranularity periodOrigin = new PeriodGranularity(new Period((Object)"P1M2D"), origin, tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-11-30T05:00:00.000-08:00", tz), new DateTime((Object)"2012-01-02T05:00:00.000-08:00", tz), new DateTime((Object)"2012-02-04T05:00:00.000-08:00", tz), new DateTime((Object)"2012-02-04T05:00:00.000-08:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{periodOrigin.bucketStart(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-01-02T07:00:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-03-01T07:20:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-02-04T05:00:00.000-08:00"))}));
        PeriodGranularity periodNoOrigin = new PeriodGranularity(new Period((Object)"P1M2D"), null, tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"1970-01-01T00:00:00.000-08:00", tz), new DateTime((Object)"2011-12-12T00:00:00.000-08:00", tz), new DateTime((Object)"2012-01-14T00:00:00.000-08:00", tz), new DateTime((Object)"2012-02-16T00:00:00.000-08:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{periodNoOrigin.bucketStart(DateTimes.of((String)"1970-01-01T05:02:04.123-08:00")), periodNoOrigin.bucketStart(DateTimes.of((String)"2012-01-01T05:02:04.123-08:00")), periodNoOrigin.bucketStart(DateTimes.of((String)"2012-01-15T07:01:04.123-08:00")), periodNoOrigin.bucketStart(DateTimes.of((String)"2012-02-16T00:00:00.000-08:00"))}));
        tz = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        periodOrigin = new PeriodGranularity(new Period((Object)"PT12H5M"), origin, tz);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-01-01T04:50:00.000-08:00", tz), new DateTime((Object)"2012-01-02T05:00:00.000-08:00", tz), new DateTime((Object)"2012-01-02T17:05:00.000-08:00", tz), new DateTime((Object)"2012-02-03T22:25:00.000-08:00", tz)}), Lists.newArrayList((Object[])new DateTime[]{periodOrigin.bucketStart(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-01-02T07:00:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-01-03T00:20:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-02-03T22:25:00.000-08:00"))}));
    }

    @Test
    public void testCompoundPeriodMillisTruncate() {
        DateTime origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        PeriodGranularity periodOrigin = new PeriodGranularity(new Period((Object)"PT12H5M"), origin, DateTimeZone.UTC);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2012-01-01T04:50:00.000-08:00"), DateTimes.of((String)"2012-01-02T05:00:00.000-08:00"), DateTimes.of((String)"2012-01-02T17:05:00.000-08:00"), DateTimes.of((String)"2012-02-03T22:25:00.000-08:00")}), Lists.newArrayList((Object[])new DateTime[]{periodOrigin.bucketStart(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-01-02T07:00:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-01-03T00:20:04.123-08:00")), periodOrigin.bucketStart(DateTimes.of((String)"2012-02-03T22:25:00.000-08:00"))}));
    }

    @Test
    public void testDurationBucketStart() {
        DateTime origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        DurationGranularity gran = new DurationGranularity(new Period((Object)"PT12H5M").toStandardDuration().getMillis(), origin);
        this.assertSameDateTime(Lists.newArrayList((Object[])new DateTime[]{DateTimes.of((String)"2012-01-01T04:50:00.000-08:00"), DateTimes.of((String)"2012-01-02T05:00:00.000-08:00"), DateTimes.of((String)"2012-01-02T17:05:00.000-08:00"), DateTimes.of((String)"2012-02-03T22:25:00.000-08:00")}), Lists.newArrayList((Object[])new DateTime[]{gran.bucketStart(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00")), gran.bucketStart(DateTimes.of((String)"2012-01-02T07:00:04.123-08:00")), gran.bucketStart(DateTimes.of((String)"2012-01-03T00:20:04.123-08:00")), gran.bucketStart(DateTimes.of((String)"2012-02-03T22:25:00.000-08:00"))}));
        Assert.assertEquals((long)DateTimes.of((String)"2012-01-01T04:50:00.000-08:00").getMillis(), (long)gran.bucketStart(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00").getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2012-01-02T05:00:00.000-08:00").getMillis(), (long)gran.bucketStart(DateTimes.of((String)"2012-01-02T07:00:04.123-08:00").getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2012-01-02T17:05:00.000-08:00").getMillis(), (long)gran.bucketStart(DateTimes.of((String)"2012-01-03T00:20:04.123-08:00").getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2012-02-03T22:25:00.000-08:00").getMillis(), (long)gran.bucketStart(DateTimes.of((String)"2012-02-03T22:25:00.000-08:00").getMillis()));
    }

    @Test
    public void testDurationIncrement() {
        DateTime origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        DurationGranularity gran = new DurationGranularity(new Period((Object)"PT12H5M").toStandardDuration().getMillis(), origin);
        Assert.assertEquals((Object)DateTimes.of((String)"2012-01-01T17:05:04.123-08:00"), (Object)gran.increment(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00")));
        Assert.assertEquals((Object)DateTimes.of((String)"2012-01-02T19:05:04.123-08:00"), (Object)gran.increment(DateTimes.of((String)"2012-01-02T07:00:04.123-08:00")));
        Assert.assertEquals((Object)DateTimes.of((String)"2012-01-03T12:25:04.123-08:00"), (Object)gran.increment(DateTimes.of((String)"2012-01-03T00:20:04.123-08:00")));
        Assert.assertEquals((Object)DateTimes.of((String)"2012-02-04T10:30:00.000-08:00"), (Object)gran.increment(DateTimes.of((String)"2012-02-03T22:25:00.000-08:00")));
    }

    @Test
    public void testDurationIncrementOnMillis() {
        DateTime origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        DurationGranularity gran = new DurationGranularity(new Period((Object)"PT12H5M").toStandardDuration().getMillis(), origin);
        Assert.assertEquals((long)DateTimes.of((String)"2012-01-01T17:05:04.123-08:00").getMillis(), (long)gran.increment(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00").getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2012-01-02T19:05:04.123-08:00").getMillis(), (long)gran.increment(DateTimes.of((String)"2012-01-02T07:00:04.123-08:00")).getMillis());
        Assert.assertEquals((long)DateTimes.of((String)"2012-01-03T12:25:04.123-08:00").getMillis(), (long)gran.increment(DateTimes.of((String)"2012-01-03T00:20:04.123-08:00")).getMillis());
        Assert.assertEquals((long)DateTimes.of((String)"2012-02-04T10:30:00.000-08:00").getMillis(), (long)gran.increment(DateTimes.of((String)"2012-02-03T22:25:00.000-08:00")).getMillis());
    }

    @Test
    public void testDurationToDateTime() {
        DateTime origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        DurationGranularity gran = new DurationGranularity(new Period((Object)"PT12H5M").toStandardDuration().getMillis(), origin);
        Assert.assertEquals((Object)DateTimes.of((String)"2012-01-01T05:00:04.123-08:00"), (Object)gran.toDateTime(DateTimes.of((String)"2012-01-01T05:00:04.123-08:00").getMillis()));
    }

    @Test
    public void testIterableAllSimple() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T00:00:00.000Z");
        this.assertSameInterval(Collections.singletonList(baseTime), Granularities.ALL.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Days.days((int)3)))));
    }

    @Test
    public void testIterableAllComplex() {
        DateTime baseTime = DateTimes.of((String)"2011-01-01T09:38:02.992Z");
        this.assertSameInterval(Collections.singletonList(baseTime), Granularities.ALL.getIterable(new Interval((ReadableInstant)baseTime, (ReadableInstant)baseTime.plus((ReadablePeriod)Days.days((int)3)))));
    }

    @Test
    public void testSerializePeriod() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String json = "{ \"type\": \"period\", \"period\": \"P1D\" }";
        Granularity gran = (Granularity)mapper.readValue(json, Granularity.class);
        Assert.assertEquals((Object)new PeriodGranularity(new Period((Object)"P1D"), null, null), (Object)gran);
        json = "{ \"type\": \"period\", \"period\": \"P2D\" }";
        gran = (Granularity)mapper.readValue(json, Granularity.class);
        Assert.assertEquals((Object)new PeriodGranularity(new Period((Object)"P2D"), null, null), (Object)gran);
        json = "{ \"type\": \"period\", \"period\": \"P1D\",\"timeZone\": \"America/Los_Angeles\", \"origin\": \"1970-01-01T00:00:00Z\"}";
        gran = (Granularity)mapper.readValue(json, Granularity.class);
        Assert.assertEquals((Object)new PeriodGranularity(new Period((Object)"P1D"), DateTimes.EPOCH, DateTimes.inferTzFromString((String)"America/Los_Angeles")), (Object)gran);
        PeriodGranularity expected = new PeriodGranularity(new Period((Object)"P1D"), DateTimes.of((String)"2012-01-01"), DateTimes.inferTzFromString((String)"America/Los_Angeles"));
        String jsonOut = mapper.writeValueAsString((Object)expected);
        Assert.assertEquals((Object)expected, (Object)mapper.readValue(jsonOut, Granularity.class));
        String illegalJson = "{ \"type\": \"period\", \"period\": \"P0D\" }";
        try {
            mapper.readValue(illegalJson, Granularity.class);
            Assert.fail();
        }
        catch (JsonMappingException jsonMappingException) {
            // empty catch block
        }
    }

    @Test
    public void testSerializeDuration() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String json = "{ \"type\": \"duration\", \"duration\": \"3600000\" }";
        Granularity gran = (Granularity)mapper.readValue(json, Granularity.class);
        Assert.assertEquals((Object)new DurationGranularity(3600000L, null), (Object)gran);
        json = "{ \"type\": \"duration\", \"duration\": \"5\", \"origin\": \"2012-09-01T00:00:00.002Z\" }";
        gran = (Granularity)mapper.readValue(json, Granularity.class);
        Assert.assertEquals((Object)new DurationGranularity(5L, 2L), (Object)gran);
        DurationGranularity expected = new DurationGranularity(5L, 2L);
        Assert.assertEquals((Object)expected, (Object)mapper.readValue(mapper.writeValueAsString((Object)expected), Granularity.class));
        String illegalJson = "{ \"type\": \"duration\", \"duration\": \"0\" }";
        try {
            mapper.readValue(illegalJson, Granularity.class);
            Assert.fail();
        }
        catch (JsonMappingException jsonMappingException) {
            // empty catch block
        }
    }

    @Test
    public void testStandardGranularitiesSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        for (GranularityType granularityType : GranularityType.values()) {
            Granularity granularity = granularityType.getDefaultGranularity();
            Assert.assertEquals((Object)granularity, (Object)mapper.readValue("\"" + StringUtils.toUpperCase((String)granularityType.name()) + "\"", Granularity.class));
            Assert.assertEquals((Object)granularity, (Object)mapper.readValue("\"" + StringUtils.toLowerCase((String)granularityType.name()) + "\"", Granularity.class));
            Assert.assertEquals((Object)granularity, (Object)mapper.readValue(mapper.writeValueAsString((Object)granularity), Granularity.class));
            if (granularityType == GranularityType.ALL || granularityType == GranularityType.NONE) {
                Assert.assertEquals((Object)("{\"type\":\"" + StringUtils.toLowerCase((String)granularityType.name()) + "\"}"), (Object)mapper.writeValueAsString((Object)granularity));
                continue;
            }
            Assert.assertEquals((Object)("\"" + StringUtils.toUpperCase((String)granularityType.name()) + "\""), (Object)mapper.writeValueAsString((Object)granularity));
        }
    }

    @Test
    public void testMerge() {
        Assert.assertNull((Object)Granularity.mergeGranularities(null));
        Assert.assertNull((Object)Granularity.mergeGranularities((List)ImmutableList.of()));
        Assert.assertNull((Object)Granularity.mergeGranularities((List)Lists.newArrayList((Object[])new Granularity[]{null, Granularities.DAY})));
        Assert.assertNull((Object)Granularity.mergeGranularities((List)Lists.newArrayList((Object[])new Granularity[]{Granularities.DAY, null})));
        Assert.assertNull((Object)Granularity.mergeGranularities((List)Lists.newArrayList((Object[])new Granularity[]{Granularities.DAY, null, Granularities.DAY})));
        Assert.assertNull((Object)Granularity.mergeGranularities((List)ImmutableList.of((Object)Granularities.ALL, (Object)Granularities.DAY)));
        Assert.assertEquals((Object)Granularities.ALL, (Object)Granularity.mergeGranularities((List)ImmutableList.of((Object)Granularities.ALL, (Object)Granularities.ALL)));
    }

    private void assertSameDateTime(List<DateTime> expected, Iterable<DateTime> actual) {
        Assert.assertEquals((long)expected.size(), (long)Iterables.size(actual));
        Iterator<DateTime> actualIter = actual.iterator();
        Iterator<DateTime> expectedIter = expected.iterator();
        while (actualIter.hasNext() && expectedIter.hasNext()) {
            Assert.assertEquals((Object)expectedIter.next(), (Object)actualIter.next());
        }
        Assert.assertFalse((String)"actualIter not exhausted!?", (boolean)actualIter.hasNext());
        Assert.assertFalse((String)"expectedIter not exhausted!?", (boolean)expectedIter.hasNext());
    }

    private void assertSameInterval(List<DateTime> expected, Iterable<Interval> actual) {
        Assert.assertEquals((long)expected.size(), (long)Iterables.size(actual));
        Iterator<Interval> actualIter = actual.iterator();
        Iterator<DateTime> expectedIter = expected.iterator();
        while (actualIter.hasNext() && expectedIter.hasNext()) {
            Assert.assertEquals((Object)expectedIter.next(), (Object)actualIter.next().getStart());
        }
        Assert.assertFalse((String)"actualIter not exhausted!?", (boolean)actualIter.hasNext());
        Assert.assertFalse((String)"expectedIter not exhausted!?", (boolean)expectedIter.hasNext());
    }

    @Test
    public void testTruncateKathmandu() {
        DateTimeZone tz = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("Asia/Kathmandu"));
        DateTime date = new DateTime((Object)"2011-03-15T21:42:23.898+05:45", tz);
        PeriodGranularity year = new PeriodGranularity(new Period((Object)"P1Y"), null, tz);
        PeriodGranularity hour = new PeriodGranularity(new Period((Object)"PT1H"), null, tz);
        PeriodGranularity twoHour = new PeriodGranularity(new Period((Object)"PT2H"), null, tz);
        this.assertBucketStart((Granularity)year, date, new DateTime((Object)"2011-01-01T00:00:00.000+05:45", tz));
        this.assertBucketStart((Granularity)hour, date, new DateTime((Object)"2011-03-15T21:00:00.000+05:45", tz));
        this.assertBucketStart((Granularity)twoHour, date, new DateTime((Object)"2011-03-15T20:00:00.000+05:45", tz));
    }

    @Test
    public void testTruncateDhaka() {
        DateTimeZone tz = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("Asia/Dhaka"));
        DateTime date = new DateTime((Object)"2011-03-15T21:42:23.898+06:00", tz);
        PeriodGranularity year = new PeriodGranularity(new Period((Object)"P1Y"), null, tz);
        PeriodGranularity hour = new PeriodGranularity(new Period((Object)"PT1H"), null, tz);
        PeriodGranularity twoHour = new PeriodGranularity(new Period((Object)"PT2H"), null, tz);
        this.assertBucketStart((Granularity)year, date, new DateTime((Object)"2011-01-01T00:00:00.000+06:00", tz));
        this.assertBucketStart((Granularity)hour, date, new DateTime((Object)"2011-03-15T21:00:00.000+06:00", tz));
        this.assertBucketStart((Granularity)twoHour, date, new DateTime((Object)"2011-03-15T20:00:00.000+06:00", tz));
    }

    @Test
    public void testToVirtualColumn() {
        PeriodGranularity hour = new PeriodGranularity(new Period((Object)"PT1H"), null, null);
        DateTime origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        DateTimeZone tz = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        PeriodGranularity hourWithOrigin = new PeriodGranularity(new Period((Object)"PT1H"), origin, tz);
        PeriodGranularity hourWithTz = new PeriodGranularity(new Period((Object)"PT1H"), null, tz);
        DurationGranularity duration = new DurationGranularity(new Period((Object)"PT12H5M").toStandardDuration().getMillis(), origin);
        ExpressionVirtualColumn column = Granularities.toVirtualColumn((Granularity)hour, (String)"__virtualGranularity");
        Assert.assertEquals((Object)"timestamp_floor(__time,'PT1H')", (Object)column.getExpression());
        column = Granularities.toVirtualColumn((Granularity)hourWithOrigin, (String)"__virtualGranularity");
        Assert.assertEquals((Object)"__time", (Object)column.getExpression());
        column = Granularities.toVirtualColumn((Granularity)hourWithTz, (String)"__virtualGranularity");
        Assert.assertEquals((Object)"__time", (Object)column.getExpression());
        column = Granularities.toVirtualColumn((Granularity)duration, (String)"__virtualGranularity");
        Assert.assertEquals((Object)"__time", (Object)column.getExpression());
        column = Granularities.toVirtualColumn((Granularity)Granularities.NONE, (String)"__virtualGranularity");
        Assert.assertEquals((Object)"__time", (Object)column.getExpression());
        column = Granularities.toVirtualColumn((Granularity)Granularities.ALL, (String)"__virtualGranularity");
        Assert.assertNull((Object)column);
        column = Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__virtualGranularity");
        Assert.assertEquals((Object)"timestamp_floor(__time,'PT1H')", (Object)column.getExpression());
        column = Granularities.toVirtualColumn((Granularity)Granularities.MINUTE, (String)"__virtualGranularity");
        Assert.assertEquals((Object)"timestamp_floor(__time,'PT1M')", (Object)column.getExpression());
        column = Granularities.toVirtualColumn((Granularity)Granularities.FIFTEEN_MINUTE, (String)"__virtualGranularity");
        Assert.assertEquals((Object)"timestamp_floor(__time,'PT15M')", (Object)column.getExpression());
    }

    @Test
    public void testFromVirtualColumn() {
        ExpressionVirtualColumn hourly = Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"v0");
        ExpressionVirtualColumn day = Granularities.toVirtualColumn((Granularity)Granularities.DAY, (String)"v0");
        ExpressionVirtualColumn hourlyNonstandardTime = new ExpressionVirtualColumn("v0", "timestamp_floor(__gran, 'PT1H')", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn ceilHour = new ExpressionVirtualColumn("v0", "timestamp_ceil(__time, 'PT1M')", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn floorWithExpression = new ExpressionVirtualColumn("v0", "timestamp_floor(timestamp_parse(timestamp,null,'UTC'), 'PT1M')", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn floorWithTimezone = new ExpressionVirtualColumn("v0", "timestamp_floor(__time, 'PT1M', null,'America/Los_Angeles')", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn floorWithOriginTimezone = new ExpressionVirtualColumn("v0", "timestamp_floor(__time, 'PT1M', '2012-01-02T05:00:00.000-08:00','America/Los_Angeles')", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)Granularities.HOUR, (Object)Granularities.fromVirtualColumn((VirtualColumn)hourly));
        Assert.assertEquals((Object)Granularities.DAY, (Object)Granularities.fromVirtualColumn((VirtualColumn)day));
        Assert.assertEquals((Object)Granularities.HOUR, (Object)Granularities.fromVirtualColumn((VirtualColumn)hourlyNonstandardTime));
        Assert.assertNull((Object)Granularities.fromVirtualColumn((VirtualColumn)ceilHour));
        Assert.assertNull((Object)Granularities.fromVirtualColumn((VirtualColumn)floorWithExpression));
        DateTime origin = DateTimes.of((String)"2012-01-02T05:00:00.000-08:00");
        DateTimeZone tz = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        PeriodGranularity minuteWithTz = new PeriodGranularity(new Period((Object)"PT1M"), null, tz);
        PeriodGranularity minuteWithOrigin = new PeriodGranularity(new Period((Object)"PT1M"), origin, tz);
        Assert.assertEquals((Object)minuteWithTz, (Object)Granularities.fromVirtualColumn((VirtualColumn)floorWithTimezone));
        Assert.assertEquals((Object)minuteWithOrigin, (Object)Granularities.fromVirtualColumn((VirtualColumn)floorWithOriginTimezone));
    }

    private void assertBucketStart(Granularity granularity, DateTime in, DateTime expectedInProperTz) {
        Assert.assertEquals((String)StringUtils.format((String)"Granularity [%s] toDateTime(bucketStart(DateTime))", (Object[])new Object[]{granularity}), (Object)expectedInProperTz, (Object)granularity.toDateTime(granularity.bucketStart(in).getMillis()));
        Assert.assertEquals((String)StringUtils.format((String)"Granularity [%s] bucketStart(DateTime)", (Object[])new Object[]{granularity}), (Object)expectedInProperTz.withZone(in.getZone()), (Object)granularity.bucketStart(in));
        Assert.assertEquals((String)StringUtils.format((String)"Granularity [%s] bucketStart(long)", (Object[])new Object[]{granularity}), (long)expectedInProperTz.getMillis(), (long)granularity.bucketStart(in.getMillis()));
    }
}

