/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.cast;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.write.cast.TypeCastSelectors;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class TypeCastSelectorsTest
extends InitializedNullHandlingTest {
    private final ColumnSelectorFactory testColumnSelectorFactory = new TestColumnSelectorFactory(RowSignature.builder().add("x", ColumnType.STRING).add("y", ColumnType.STRING).add("z", ColumnType.STRING).add("da", ColumnType.DOUBLE_ARRAY).build(), (Map<String, Object>)ImmutableMap.builder().put((Object)"x", (Object)"12.3").put((Object)"y", (Object)"abc").put((Object)"da", (Object)new Object[]{1.2, 2.3}).build());

    @Test
    public void test_readXAsLong() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"x", (ColumnType)ColumnType.LONG);
        Assert.assertEquals((long)12L, (long)selector.getLong());
        Assert.assertEquals((double)12.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)12.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertFalse((boolean)selector.isNull());
        Assert.assertEquals((Object)12L, (Object)selector.getObject());
    }

    @Test
    public void test_readXAsDouble() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"x", (ColumnType)ColumnType.DOUBLE);
        Assert.assertEquals((long)12L, (long)selector.getLong());
        Assert.assertEquals((double)12.3, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)12.3f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertFalse((boolean)selector.isNull());
        Assert.assertEquals((Object)12.3, (Object)selector.getObject());
    }

    @Test
    public void test_readXAsFloat() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"x", (ColumnType)ColumnType.FLOAT);
        Assert.assertEquals((long)12L, (long)selector.getLong());
        Assert.assertEquals((double)12.3, (double)selector.getDouble(), (double)0.001);
        Assert.assertEquals((float)12.3f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertFalse((boolean)selector.isNull());
        Assert.assertEquals((Object)12.3, (Object)selector.getObject());
    }

    @Test
    public void test_readXAsLongArray() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"x", (ColumnType)ColumnType.LONG_ARRAY);
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getLong());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getDouble());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getFloat());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).isNull());
        Assert.assertArrayEquals((Object[])new Object[]{12L}, (Object[])((Object[])selector.getObject()));
    }

    @Test
    public void test_readXAsStringArray() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"x", (ColumnType)ColumnType.STRING_ARRAY);
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getLong());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getDouble());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getFloat());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).isNull());
        Assert.assertArrayEquals((Object[])new Object[]{"12.3"}, (Object[])((Object[])selector.getObject()));
    }

    @Test
    public void test_readYAsLong() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"y", (ColumnType)ColumnType.LONG);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertTrue((boolean)selector.isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readYAsDouble() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"y", (ColumnType)ColumnType.DOUBLE);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertTrue((boolean)selector.isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readYAsFloat() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"y", (ColumnType)ColumnType.FLOAT);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertTrue((boolean)selector.isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readYAsLongArray() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"y", (ColumnType)ColumnType.LONG_ARRAY);
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getLong());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getDouble());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getFloat());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).isNull());
        Assert.assertArrayEquals((Object[])new Object[]{null}, (Object[])((Object[])selector.getObject()));
    }

    @Test
    public void test_readYAsStringArray() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"y", (ColumnType)ColumnType.STRING_ARRAY);
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getLong());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getDouble());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getFloat());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).isNull());
        Assert.assertArrayEquals((Object[])new Object[]{"abc"}, (Object[])((Object[])selector.getObject()));
    }

    @Test
    public void test_readZAsLong() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"z", (ColumnType)ColumnType.LONG);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertTrue((boolean)selector.isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readZAsDouble() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"z", (ColumnType)ColumnType.DOUBLE);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertTrue((boolean)selector.isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readZAsFloat() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"z", (ColumnType)ColumnType.FLOAT);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertTrue((boolean)selector.isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readZAsLongArray() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"z", (ColumnType)ColumnType.LONG_ARRAY);
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getLong());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getDouble());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getFloat());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readZAsStringArray() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"z", (ColumnType)ColumnType.STRING_ARRAY);
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getLong());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getDouble());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getFloat());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readDaAsLong() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"da", (ColumnType)ColumnType.LONG);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertTrue((boolean)selector.isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readDaAsDouble() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"da", (ColumnType)ColumnType.DOUBLE);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertTrue((boolean)selector.isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readDaAsFloat() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"da", (ColumnType)ColumnType.FLOAT);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        Assert.assertTrue((boolean)selector.isNull());
        Assert.assertNull((Object)selector.getObject());
    }

    @Test
    public void test_readDaAsLongArray() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"da", (ColumnType)ColumnType.LONG_ARRAY);
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getLong());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getDouble());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getFloat());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).isNull());
        Assert.assertArrayEquals((Object[])new Object[]{1L, 2L}, (Object[])((Object[])selector.getObject()));
    }

    @Test
    public void test_readDaAsStringArray() {
        ColumnValueSelector selector = TypeCastSelectors.makeColumnValueSelector((ColumnSelectorFactory)this.testColumnSelectorFactory, (String)"da", (ColumnType)ColumnType.STRING_ARRAY);
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getLong());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getDouble());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).getFloat());
        Assert.assertThrows(DruidException.class, () -> ((ColumnValueSelector)selector).isNull());
        Assert.assertArrayEquals((Object[])new Object[]{"1.2", "2.3"}, (Object[])((Object[])selector.getObject()));
    }

    private static class TestColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final RowSignature signature;
        private final Map<String, Object> columnValues;

        public TestColumnSelectorFactory(RowSignature signature, Map<String, Object> columnValues) {
            this.signature = signature;
            this.columnValues = columnValues;
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            throw new UnsupportedOperationException();
        }

        public ColumnValueSelector<?> makeColumnValueSelector(final String columnName) {
            return new ColumnValueSelector<Object>(){

                public double getDouble() {
                    throw new UnsupportedOperationException("Should not be called");
                }

                public float getFloat() {
                    throw new UnsupportedOperationException("Should not be called");
                }

                public long getLong() {
                    throw new UnsupportedOperationException("Should not be called");
                }

                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    throw new UnsupportedOperationException("Should not be called");
                }

                public boolean isNull() {
                    throw new UnsupportedOperationException("Should not be called");
                }

                @Nullable
                public Object getObject() {
                    return columnValues.get(columnName);
                }

                public Class<?> classOfObject() {
                    throw new UnsupportedOperationException("Should not be called");
                }
            };
        }

        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            return this.signature.getColumnCapabilities(column);
        }
    }
}

