/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import java.util.Collections;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.frame.write.RowBasedFrameWriterFactory;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.frame.write.columnar.ColumnarFrameWriterFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.filter.AllNullColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class FrameWritersTest
extends InitializedNullHandlingTest {
    private static final int ALLOCATOR_CAPACITY = 1000;

    @Test
    public void test_rowBasedV1() {
        FrameWriterFactory factory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED_V1, (MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG).build(), Collections.singletonList(new KeyColumn("x", KeyOrder.ASCENDING)), (boolean)false);
        MatcherAssert.assertThat((Object)factory, (Matcher)CoreMatchers.instanceOf(RowBasedFrameWriterFactory.class));
        Assert.assertEquals((long)1000L, (long)factory.allocatorCapacity());
    }

    @Test
    public void test_rowBasedV2() {
        FrameWriterFactory factory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED_V2, (MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG).build(), Collections.singletonList(new KeyColumn("x", KeyOrder.ASCENDING)), (boolean)false);
        MatcherAssert.assertThat((Object)factory, (Matcher)CoreMatchers.instanceOf(RowBasedFrameWriterFactory.class));
        Assert.assertEquals((long)1000L, (long)factory.allocatorCapacity());
    }

    @Test
    public void test_columnar() {
        FrameWriterFactory factory = FrameWriters.makeColumnBasedFrameWriterFactory((MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(1000), (RowSignature)RowSignature.builder().add("a", ColumnType.LONG).add("b", ColumnType.FLOAT).add("c", ColumnType.DOUBLE).add("d", ColumnType.STRING).add("e", ColumnType.LONG_ARRAY).add("f", ColumnType.FLOAT_ARRAY).add("g", ColumnType.DOUBLE_ARRAY).add("h", ColumnType.STRING_ARRAY).build(), Collections.emptyList());
        MatcherAssert.assertThat((Object)factory, (Matcher)CoreMatchers.instanceOf(ColumnarFrameWriterFactory.class));
        Assert.assertEquals((long)1000L, (long)factory.allocatorCapacity());
    }

    @Test
    public void test_columnar_unsupportedColumnType() {
        FrameWriterFactory factory = FrameWriters.makeColumnBasedFrameWriterFactory((MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(1000), (RowSignature)RowSignature.builder().add("x", ColumnType.ofArray((ColumnType)ColumnType.LONG_ARRAY)).build(), Collections.emptyList());
        UnsupportedColumnTypeException e = (UnsupportedColumnTypeException)Assert.assertThrows(UnsupportedColumnTypeException.class, () -> factory.newFrameWriter((ColumnSelectorFactory)new AllNullColumnSelectorFactory()));
        Assert.assertEquals((Object)"x", (Object)e.getColumnName());
        Assert.assertEquals((Object)ColumnType.ofArray((ColumnType)ColumnType.LONG_ARRAY), (Object)e.getColumnType());
    }

    @Test
    public void test_rowBased_sortColumnsNotPrefix() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> FrameWriters.makeFrameWriterFactory((FrameType)FrameType.latestRowBased(), (MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG).add("y", ColumnType.LONG).build(), Collections.singletonList(new KeyColumn("y", KeyOrder.ASCENDING)), (boolean)false));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Sort column [y] must be a prefix of the signature")));
    }

    @Test
    public void test_columnar_cantSort() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> FrameWriters.makeColumnBasedFrameWriterFactory((MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(1000), (RowSignature)RowSignature.builder().add("x", ColumnType.LONG).build(), Collections.singletonList(new KeyColumn("x", KeyOrder.ASCENDING))));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Columnar frames cannot be sorted")));
    }
}

