/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.test;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;

public class FailingFrameProcessor
implements FrameProcessor<Long> {
    private final ReadableFrameChannel inChannel;
    private final WritableFrameChannel outChannel;
    private final int numFramesBeforeFailure;
    private int numFramesSoFar = 0;

    public FailingFrameProcessor(ReadableFrameChannel inChannel, WritableFrameChannel outChannel, int numFramesBeforeFailure) {
        this.inChannel = inChannel;
        this.outChannel = outChannel;
        this.numFramesBeforeFailure = numFramesBeforeFailure;
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outChannel);
    }

    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        if (readableInputs.contains(0)) {
            if (this.inChannel.isFinished()) {
                throw new RuntimeException("failure!");
            }
            if (this.numFramesSoFar >= this.numFramesBeforeFailure) {
                throw new RuntimeException("failure!");
            }
            this.outChannel.write(this.inChannel.read());
            ++this.numFramesSoFar;
            if (this.numFramesSoFar >= this.numFramesBeforeFailure) {
                throw new RuntimeException("failure!");
            }
        }
        return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[0]);
    }
}

