/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.FloatArrayFieldReader;
import org.apache.druid.frame.field.IndexArrayFieldPointer;
import org.apache.druid.frame.field.NumericArrayFieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

@RunWith(value=Parameterized.class)
public class FloatArrayFieldReaderTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public ColumnValueSelector writeSelector;
    private final FrameType frameType;
    private WritableMemory memory;
    private FieldWriter fieldWriter;
    private static final Object[] FLOATS_ARRAY_1 = new Object[]{null, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_NORMAL), null, Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), null, Float.valueOf(0.0f), Float.valueOf(1.234234f), Float.valueOf(-1.344234f), Float.valueOf(Float.NaN), Float.valueOf(129123.125f), null, Float.valueOf(-2.1312214E7f), Float.valueOf(1111.0f), null, Float.valueOf(23.0f)};
    private static final Object[] FLOATS_ARRAY_2 = new Object[]{null, Float.valueOf(Float.MAX_VALUE), null, Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(-0.0f), Float.valueOf(0.0f), Float.valueOf(-1.234234f), Float.valueOf(Float.MIN_VALUE), Float.valueOf(1.3442343f), Float.valueOf(-129123.125f), Float.valueOf(2.1312214E7f), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(-1111.0f), Float.valueOf(1223.0f), Float.valueOf(Float.MIN_NORMAL), null, Float.valueOf(Float.NaN), null};
    private static final List<Float> FLOATS_LIST_1 = Arrays.stream(FLOATS_ARRAY_1).map(val -> (Float)val).collect(Collectors.toList());
    private static final List<Float> FLOATS_LIST_2 = Arrays.stream(FLOATS_ARRAY_2).map(val -> (Float)val).collect(Collectors.toList());

    public FloatArrayFieldReaderTest(FrameType frameType) {
        this.frameType = frameType;
    }

    @Parameterized.Parameters(name="frameType = {0}")
    public static Iterable<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (FrameType frameType : FrameType.values()) {
            if (!frameType.isRowBased()) continue;
            constructors.add(new Object[]{frameType});
        }
        return constructors;
    }

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = NumericArrayFieldWriter.getFloatArrayFieldWriter((ColumnValueSelector)this.writeSelector, (FrameType)this.frameType);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void test_isNull_null() {
        this.writeToMemory(null, 1L);
        Assert.assertTrue((boolean)new FloatArrayFieldReader(this.frameType).isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_aValue() {
        this.writeToMemory(FLOATS_ARRAY_1, 1L);
        Assert.assertFalse((boolean)new FloatArrayFieldReader(this.frameType).isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_emptyArray() {
        this.writeToMemory(new Object[0], 1L);
        Assert.assertFalse((boolean)new FloatArrayFieldReader(this.frameType).isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_arrayWithSingleNullElement() {
        this.writeToMemory(new Object[]{null}, 1L);
        Assert.assertFalse((boolean)new FloatArrayFieldReader(this.frameType).isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_makeColumnValueSelector_null() {
        long sz = this.writeToMemory(null, 1L);
        ColumnValueSelector readSelector = new FloatArrayFieldReader(this.frameType).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        Assert.assertTrue((boolean)readSelector.isNull());
    }

    @Test
    public void test_makeColumnValueSelector_aValue() {
        long sz = this.writeToMemory(FLOATS_ARRAY_1, 1L);
        ColumnValueSelector readSelector = new FloatArrayFieldReader(this.frameType).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        this.assertResults(FLOATS_LIST_1, readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_multipleValues() {
        long sz = this.writeToMemory(FLOATS_ARRAY_1, 1L);
        long sz2 = this.writeToMemory(FLOATS_ARRAY_2, 1L + sz);
        IndexArrayFieldPointer pointer = new IndexArrayFieldPointer((List<Long>)ImmutableList.of((Object)1L, (Object)(1L + sz)), (List<Long>)ImmutableList.of((Object)sz, (Object)sz2));
        ColumnValueSelector readSelector = new FloatArrayFieldReader(this.frameType).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)pointer);
        pointer.setPointer(0);
        this.assertResults(FLOATS_LIST_1, readSelector.getObject());
        pointer.setPointer(1);
        this.assertResults(FLOATS_LIST_2, readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_emptyArray() {
        long sz = this.writeToMemory(new Object[0], 1L);
        ColumnValueSelector readSelector = new FloatArrayFieldReader(this.frameType).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        this.assertResults(Collections.emptyList(), readSelector.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_arrayWithSingleNullElement() {
        long sz = this.writeToMemory(new Object[]{null}, 1L);
        ColumnValueSelector readSelector = new FloatArrayFieldReader(this.frameType).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L, sz));
        this.assertResults(Collections.singletonList(null), readSelector.getObject());
    }

    private long writeToMemory(Object value, long initialPosition) {
        Mockito.when((Object)this.writeSelector.getObject()).thenReturn(value);
        long bytesWritten = this.fieldWriter.writeTo(this.memory, initialPosition, this.memory.getCapacity() - initialPosition);
        if (bytesWritten < 0L) {
            throw new ISE("Could not write", new Object[0]);
        }
        return bytesWritten;
    }

    private void assertResults(List<Float> expected, Object actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
        }
        Assert.assertTrue((boolean)(actual instanceof Object[]));
        ArrayList<Float> actualList = new ArrayList<Float>();
        for (Object val : (Object[])actual) {
            actualList.add((Float)val);
        }
        Assert.assertEquals(expected, actualList);
    }
}

