/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;

public class TestArrayCursorFactory
extends QueryableIndexCursorFactory {
    private final RowSignature signature;

    public TestArrayCursorFactory(QueryableIndex index) {
        super(index);
        this.signature = TestArrayCursorFactory.computeRowSignature(index);
    }

    public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
        final CursorHolder delegate = super.makeCursorHolder(spec);
        return new CursorHolder(){

            @Nullable
            public Cursor asCursor() {
                return new DecoratedCursor(delegate.asCursor());
            }

            @Nullable
            public List<OrderBy> getOrdering() {
                return delegate.getOrdering();
            }

            public void close() {
                delegate.close();
            }
        };
    }

    public RowSignature getRowSignature() {
        return this.signature;
    }

    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        ColumnCapabilities ourType = this.getRowSignature().getColumnCapabilities(column);
        if (ourType != null) {
            return ColumnCapabilitiesImpl.copyOf((ColumnCapabilities)super.getColumnCapabilities(column)).setType(ourType.toColumnType());
        }
        return super.getColumnCapabilities(column);
    }

    private static RowSignature computeRowSignature(QueryableIndex index) {
        RowSignature.Builder builder = RowSignature.builder();
        builder.addTimeColumn();
        for (String column : new QueryableIndexCursorFactory(index).getRowSignature().getColumnNames()) {
            ColumnType columnType;
            ColumnCapabilities columnCapabilities = index.getColumnCapabilities(column);
            ColumnType columnType2 = columnType = columnCapabilities == null ? null : columnCapabilities.toColumnType();
            if (columnType != null && columnType.equals((Object)ColumnType.STRING) && columnCapabilities.hasMultipleValues().isMaybeTrue()) {
                columnType = ColumnType.STRING_ARRAY;
            }
            builder.add(column, columnType);
        }
        return builder.build();
    }

    private class DecoratedCursor
    implements Cursor {
        private final Cursor cursor;

        public DecoratedCursor(Cursor cursor) {
            this.cursor = cursor;
        }

        public ColumnSelectorFactory getColumnSelectorFactory() {
            final ColumnSelectorFactory columnSelectorFactory = this.cursor.getColumnSelectorFactory();
            return new ColumnSelectorFactory(){

                public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                    if (!(dimensionSpec instanceof DefaultDimensionSpec)) {
                        throw new UnsupportedOperationException();
                    }
                    ColumnCapabilities capabilities = this.getColumnCapabilities(dimensionSpec.getDimension());
                    if (capabilities == null || capabilities.is((TypeDescriptor)ValueType.ARRAY)) {
                        throw new UnsupportedOperationException("Must not call makeDimensionSelector on ARRAY");
                    }
                    return columnSelectorFactory.makeDimensionSelector(dimensionSpec);
                }

                public ColumnValueSelector makeColumnValueSelector(String columnName) {
                    ColumnCapabilities capabilities = this.getColumnCapabilities(columnName);
                    if (capabilities != null && capabilities.toColumnType().equals((Object)ColumnType.STRING_ARRAY)) {
                        final DimensionSelector delegate = columnSelectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)columnName));
                        return new ObjectColumnSelector<Object[]>(){

                            public Object[] getObject() {
                                IndexedInts row = delegate.getRow();
                                int sz = row.size();
                                Object[] retVal = new Object[sz];
                                for (int i = 0; i < sz; ++i) {
                                    retVal[i] = delegate.lookupName(row.get(i));
                                }
                                return retVal;
                            }

                            public Class<Object[]> classOfObject() {
                                return Object[].class;
                            }

                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            }
                        };
                    }
                    return columnSelectorFactory.makeColumnValueSelector(columnName);
                }

                @Nullable
                public ColumnCapabilities getColumnCapabilities(String column) {
                    return TestArrayCursorFactory.this.getColumnCapabilities(column);
                }
            };
        }

        public void advance() {
            this.cursor.advance();
        }

        public void advanceUninterruptibly() {
            this.cursor.advanceUninterruptibly();
        }

        public boolean isDone() {
            return this.cursor.isDone();
        }

        public boolean isDoneOrInterrupted() {
            return this.cursor.isDoneOrInterrupted();
        }

        public void reset() {
            this.cursor.reset();
        }
    }
}

