/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.error;

import java.util.Map;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.Forbidden;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionTest {
    @Test
    public void testNoCause() {
        StackTraceElement[] stackTrace;
        DruidException exception = DruidException.defensive().build("defensive", new Object[0]);
        for (StackTraceElement stackTraceElement : stackTrace = exception.getStackTrace()) {
            Assert.assertFalse((boolean)stackTraceElement.getClassName().startsWith(DruidException.CLASS_NAME_STR));
        }
    }

    @Test
    public void testNoStacktrace() {
        ErrorResponse errorResponse = new ErrorResponse(Forbidden.exception());
        Map asMap = errorResponse.getAsMap();
        DruidException exception = ErrorResponse.fromMap((Map)asMap).getUnderlyingException();
        Assert.assertTrue((boolean)(exception.getCause() instanceof DruidException));
        Assert.assertEquals((long)0L, (long)exception.getCause().getStackTrace().length);
    }
}

